/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.DataTypeDeclaration;
import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.StandardSQLDataType;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.SurrogateKey;
import jp.sourceforge.tmdmaker.model.SurrogateKeyRef;
import jp.sourceforge.tmdmaker.model.VirtualEntity;

public class ImplementRule {
    private static boolean foreignKeyEnabled;

    public static List<AbstractEntityModel> findNotImplementModel(AbstractEntityModel model) {
        ArrayList<AbstractEntityModel> subsets = new ArrayList<AbstractEntityModel>();
        ArrayList<AbstractEntityModel> ves = new ArrayList<AbstractEntityModel>();
        ArrayList<AbstractEntityModel> results = new ArrayList<AbstractEntityModel>();
        ImplementRule.findNotImplementSubset(subsets, model);
        ImplementRule.findNotImplementVirtualEntity(ves, model);
        for (AbstractEntityModel m : subsets) {
            ImplementRule.findNotImplementVirtualEntity(ves, m);
        }
        results.addAll(subsets);
        results.addAll(ves);
        return results;
    }

    private static void findNotImplementSubset(List<AbstractEntityModel> results, AbstractEntityModel model) {
        SubsetType type = model.findSubsetType();
        if (type == null) {
            return;
        }
        for (AbstractConnectionModel connection : type.getModelSourceConnections()) {
            SubsetEntity subset = (SubsetEntity)connection.getTarget();
            if (subset.isNotImplement()) {
                results.add(subset);
            }
            ImplementRule.findNotImplementSubset(results, subset);
        }
    }

    private static void findNotImplementVirtualEntity(List<AbstractEntityModel> results, AbstractEntityModel model) {
        for (AbstractConnectionModel connection : model.getModelSourceConnections()) {
            ConnectableElement e = connection.getTarget();
            if (!(e instanceof VirtualEntity)) continue;
            VirtualEntity ve = (VirtualEntity)e;
            if (ve.isNotImplement()) {
                results.add(ve);
            }
            ImplementRule.findNotImplementVirtualEntity(results, ve);
        }
    }

    public static List<IAttribute> findAllImplementAttributes(AbstractEntityModel model) {
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        SurrogateKey surrogateKey = model.getKeyModels().getSurrogateKey();
        if (surrogateKey.isEnabled()) {
            attributes.add(surrogateKey);
        }
        ImplementRule.addIdentifier(model, attributes);
        Map<AbstractEntityModel, ReusedIdentifier> reused = model.getReusedIdentifiers();
        for (Map.Entry<AbstractEntityModel, ReusedIdentifier> entry : reused.entrySet()) {
            ReusedIdentifier ri = entry.getValue();
            if (ri == null) continue;
            if (ri.isSurrogateKeyEnabled()) {
                for (SurrogateKeyRef s : ri.getSurrogateKeys()) {
                    attributes.add(s);
                }
                continue;
            }
            for (IdentifierRef ref : ri.getUniqueIdentifiers()) {
                attributes.add(ref);
            }
        }
        attributes.addAll(model.getAttributes());
        for (AbstractEntityModel m : model.getImplementDerivationModels()) {
            attributes.addAll(m.getAttributes());
        }
        return attributes;
    }

    private static void addIdentifier(AbstractEntityModel model, List<IAttribute> attributes) {
        if (model instanceof Entity) {
            attributes.add(((Entity)model).getIdentifier());
        }
        if (model instanceof Detail && ((Detail)model).isDetailIdentifierEnabled()) {
            attributes.add(((Detail)model).getDetailIdentifier());
        }
        if (model instanceof SubsetEntity) {
            ReusedIdentifier reused = ((SubsetEntity)model).getOriginalReusedIdentifier();
            for (IdentifierRef ref : reused.getUniqueIdentifiers()) {
                attributes.add(ref);
            }
        }
    }

    public static AbstractEntityModel findOriginalImplementModel(AbstractEntityModel model) {
        if (model != null && model.isNotImplement()) {
            if (model instanceof SubsetEntity) {
                return ImplementRule.findOriginalImplementModel(((SubsetEntity)model).getSuperset());
            }
            if (model instanceof VirtualEntity) {
                return ImplementRule.findOriginalImplementModel(((VirtualEntity)model).getRealEntity());
            }
            return model;
        }
        return model;
    }

    public static void setModelDefaultValue(AbstractEntityModel model) {
        if (ImplementRule.isEmpty(model.getImplementName())) {
            model.setImplementName(model.getName());
        }
    }

    public static void setIdentifierDefaultValue(Identifier identifier) {
        if (ImplementRule.isEmpty(identifier.getImplementName())) {
            identifier.setImplementName(identifier.getName());
        }
        if (identifier.getDataTypeDeclaration() == null) {
            identifier.setDataTypeDeclaration(new DataTypeDeclaration(StandardSQLDataType.NUMERIC, 10, 0));
        }
    }

    public static void setSurrogateKeyDefaultValue(SurrogateKey surrogateKey) {
        DataTypeDeclaration dtd;
        String implementName = surrogateKey.getImplementName();
        if (ImplementRule.isEmpty(implementName)) {
            surrogateKey.setImplementName(surrogateKey.getName());
        }
        if ((dtd = surrogateKey.getDataTypeDeclaration()) == null) {
            surrogateKey.setDataTypeDeclaration(new DataTypeDeclaration(StandardSQLDataType.NUMERIC, 10, 0));
        }
    }

    public static boolean isForeignKeyEnabled() {
        return foreignKeyEnabled;
    }

    public static void setForeignKeyEnabled(boolean foreignKeyEnabled) {
        ImplementRule.foreignKeyEnabled = foreignKeyEnabled;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }
}

