/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.generate.html.relationshiplist;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.generate.html.Messages;
import jp.sourceforge.tmdmaker.generate.html.internal.HtmlGeneratorUtils;
import jp.sourceforge.tmdmaker.generate.html.relationshiplist.RelationshipMapping;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.generate.Generator;
import jp.sourceforge.tmdmaker.model.generate.GeneratorRuntimeException;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipListHtmlGenerator
implements Generator {
    private static Logger logger = LoggerFactory.getLogger(RelationshipListHtmlGenerator.class);

    public String getGeneratorName() {
        return Messages.RelationshipListHtmlGenerator_GeneratorName;
    }

    public String getGroupName() {
        return "HTML";
    }

    public void execute(String rootDir, List<AbstractEntityModel> models) {
        logger.info("generate");
        VelocityContext context = HtmlGeneratorUtils.getVecityContext();
        Map<AbstractEntityModel, List<RelationshipMapping>> relationshipMappingMap = this.createData(models);
        context.put("entities", relationshipMappingMap.keySet());
        context.put("mappings", relationshipMappingMap.entrySet());
        try {
            HtmlGeneratorUtils.outputCSS(rootDir);
            HtmlGeneratorUtils.applyTemplate("relationship_list.html", this.getClass(), new File(rootDir, "relationship_list.html"), context);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new GeneratorRuntimeException((Throwable)e);
        }
        try {
            HtmlGeneratorUtils.copyStream(HtmlGeneratorUtils.class.getResourceAsStream("stylesheet.css"), new FileOutputStream(new File(rootDir, "stylesheet.css")));
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage());
            throw new GeneratorRuntimeException((Throwable)e);
        }
    }

    private Map<AbstractEntityModel, List<RelationshipMapping>> createData(List<AbstractEntityModel> models) {
        LinkedHashMap<AbstractEntityModel, List<RelationshipMapping>> relationshipMappingMap = new LinkedHashMap<AbstractEntityModel, List<RelationshipMapping>>();
        for (AbstractEntityModel source : models) {
            ArrayList<RelationshipMapping> relationshipMappingList = new ArrayList<RelationshipMapping>();
            for (AbstractEntityModel target : models) {
                relationshipMappingList.add(new RelationshipMapping(source, target));
            }
            relationshipMappingMap.put(source, relationshipMappingList);
        }
        return relationshipMappingMap;
    }

    public boolean isImplementModelOnly() {
        return false;
    }
}

