/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.VirtualEntityType;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;

public class VirtualEntity
extends AbstractEntityModel {
    private ReusedIdentifier originalReusedIdentifier;
    private VirtualEntityType virtualEntityType = VirtualEntityType.NORMAL;

    protected VirtualEntity() {
    }

    protected static VirtualEntity build(AbstractEntityModel source, String virtualEntityName, VirtualEntityType type) {
        VirtualEntity ve = new VirtualEntity();
        ve.setName(virtualEntityName);
        ve.setOriginalReusedIdentifier(source.createReusedIdentifier());
        ve.setVirtualEntityType(type);
        ImplementRule.setModelDefaultValue(ve);
        return ve;
    }

    public ReusedIdentifier getOriginalReusedIdentifier() {
        return this.originalReusedIdentifier;
    }

    public void setOriginalReusedIdentifier(ReusedIdentifier originalReusedIdentifier) {
        this.originalReusedIdentifier = originalReusedIdentifier;
        this.firePropertyChange("p_reused", null, null);
    }

    @Override
    public boolean isEntityTypeEditable() {
        return false;
    }

    public VirtualEntityType getVirtualEntityType() {
        return this.virtualEntityType;
    }

    public void setVirtualEntityType(VirtualEntityType virtualEntityType) {
        this.virtualEntityType = virtualEntityType;
    }

    @Override
    public ReusedIdentifier createReusedIdentifier() {
        ReusedIdentifier returnValue = new ReusedIdentifier(this.keyModels.getSurrogateKey());
        returnValue.addAll(this.originalReusedIdentifier.getIdentifiers());
        return returnValue;
    }

    @Override
    public boolean isDeletable() {
        return this.getModelSourceConnections().size() == 0;
    }

    @Override
    public VirtualEntity getCopy() {
        VirtualEntity copy = new VirtualEntity();
        this.copyTo(copy);
        return copy;
    }

    public AbstractEntityModel getRealEntity() {
        return (AbstractEntityModel)this.getModelTargetConnections().get(0).getSource();
    }

    @Override
    public void copyTo(AbstractEntityModel to) {
        if (to instanceof VirtualEntity) {
            ((VirtualEntity)to).setVirtualEntityType(this.getVirtualEntityType());
        }
        super.copyTo(to);
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean canCreateSubset() {
        return false;
    }

    @Override
    public boolean canCreateMultivalueOr() {
        return false;
    }

    @Override
    public boolean canCreateVirtualEntity() {
        return false;
    }
}

