/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.editor.draw2d.anchors;

import jp.sourceforge.tmdmaker.model.constraint.AnchorConstraint;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class XYChopboxAnchor
extends ChopboxAnchor {
    private AnchorConstraint anchorConstraint = new AnchorConstraint();

    public XYChopboxAnchor(IFigure owner) {
        super(owner);
    }

    public XYChopboxAnchor(IFigure owner, AnchorConstraint anchorConstraint) {
        super(owner);
        this.anchorConstraint = anchorConstraint;
    }

    public void setLocation(AnchorConstraint anchorConstraint) {
        this.anchorConstraint = anchorConstraint;
        this.fireAnchorMoved();
    }

    public Point getLocation(Point reference) {
        if (!this.anchorConstraint.isInitialPoint()) {
            return this.calculateNewPoint();
        }
        return super.getLocation(reference);
    }

    private Point calculateNewPoint() {
        Rectangle bounds = this.getBox();
        Point point = new Point(bounds.x + bounds.width * this.anchorConstraint.getX() / 100, bounds.y + bounds.height * this.anchorConstraint.getY() / 100);
        this.getOwner().translateToAbsolute((Translatable)point);
        return point;
    }

    public Point getReferencePoint() {
        if (!this.anchorConstraint.isInitialPoint()) {
            return this.calculateNewPoint();
        }
        return super.getReferencePoint();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XYChopboxAnchor) {
            XYChopboxAnchor other = (XYChopboxAnchor)((Object)obj);
            return other.getOwner() == this.getOwner() && other.getBox().equals((Object)this.getBox()) && other.anchorConstraint.equals((Object)this.anchorConstraint) && super.equals((Object)other) && this.hashCode() == other.hashCode();
        }
        return false;
    }

    public int hashCode() {
        if (this.getOwner() != null) {
            return this.getOwner().hashCode();
        }
        return super.hashCode();
    }
}

