/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.editor.draw2d;

import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.constraint.Constraint;
import org.eclipse.draw2d.geometry.Rectangle;

public class ConstraintConverter {
    public static Rectangle getRectangle(ModelElement model) {
        if (model == null) {
            return null;
        }
        Constraint constraint = model.getConstraint();
        if (constraint == null) {
            return null;
        }
        return new Rectangle(constraint.x, constraint.y, constraint.width, constraint.height);
    }

    public static Rectangle getResetRectangle(ModelElement model) {
        Constraint constraint = model.getConstraint();
        return new Rectangle(constraint.x, constraint.y, -1, -1);
    }

    public static Rectangle getTranslatedRectangle(ModelElement model, int x, int y) {
        Constraint constraint = model.getConstraint().getTranslated(x, y);
        return new Rectangle(constraint.x, constraint.y, constraint.width, constraint.height);
    }

    public static void setConstraint(ModelElement model, Rectangle rectangle) {
        model.setConstraint(new Constraint(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
    }

    public static void setConstraint(ModelElement model, int x, int y) {
        Constraint constraint = model.getConstraint();
        model.setConstraint(new Constraint(x, y, constraint.width, constraint.height));
    }

    public static void setTranslatedConstraint(ModelElement model, ModelElement base, int x, int y) {
        model.setConstraint(base.getConstraint().getTranslated(x, y));
    }

    public static void copyConstraint(ModelElement model, ModelElement base) {
        Constraint c = base.getConstraint().getCopy();
        c.x += 10;
        c.y += 10;
        model.setConstraint(c);
    }

    public static boolean isInitialPosition(ModelElement model) {
        Constraint c = model.getConstraint();
        return c.x == 0 && c.y == 0;
    }
}

