/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.node;

import java.beans.PropertyChangeEvent;
import java.util.List;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType;
import jp.sourceforge.tmdmaker.ui.dialogs.VirtualSupersetCreateDialog;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.figure.node.SubsetTypeFigure;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.ConnectionDeleteCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.ModelEditCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.VirtualSubsetReplaceCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.VirtualSupersetTypeChangeCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.node.AbstractSubsetTypeEditPart;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class VirtualSupersetTypeEditPart
extends AbstractSubsetTypeEditPart<VirtualSupersetType> {
    public VirtualSupersetTypeEditPart(VirtualSupersetType type) {
        this.setModel(type);
    }

    @Override
    protected void updateFigure(IFigure figure) {
        SubsetTypeFigure sf = (SubsetTypeFigure)figure;
        VirtualSupersetType model = (VirtualSupersetType)this.getModel();
        sf.setVertical(model.isVertical());
        sf.setSameType(model.isApplyAttribute());
    }

    public Command getCommand(Request request) {
        if (!"open".equals(request.getType())) {
            return super.getCommand(request);
        }
        VirtualSupersetType type = (VirtualSupersetType)this.getModel();
        VirtualSuperset superset = type.getSuperset();
        Diagram diagram = superset.getDiagram();
        List list = type.getSubsetList();
        VirtualSupersetCreateDialog dialog = new VirtualSupersetCreateDialog(this.getViewer().getControl().getShell(), diagram, superset, list);
        if (dialog.open() != 0) {
            return null;
        }
        CompoundCommand ccommand = new CompoundCommand();
        List<AbstractEntityModel> selectedList = dialog.getSelection();
        if (selectedList.size() == 0) {
            ccommand.add((Command)new ConnectionDeleteCommand((AbstractConnectionModel)superset.getCreationRelationship()));
        } else {
            VirtualSuperset edited = dialog.getEditedValue();
            ccommand.add((Command)new ModelEditCommand((AbstractEntityModel)superset, (AbstractEntityModel)edited));
            ccommand.add((Command)new VirtualSupersetTypeChangeCommand(superset.getVirtualSupersetType(), dialog.getEditedAggregator().isApplyAttribute()));
            ccommand.add((Command)new VirtualSubsetReplaceCommand(superset, dialog.getSelection()));
        }
        return ccommand;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_property_superset_type")) {
            this.refreshVisuals();
        } else {
            super.propertyChange(evt);
        }
    }
}

