/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.editor.gef3.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.TMDEditor;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.other.Memo;
import jp.sourceforge.tmdmaker.model.other.TurboFile;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.ConstraintConverter;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.ConstraintChangeCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.EntityModelAddCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.MemoAddCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.MemoChangeCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.node.AbstractTMDEditPart;
import jp.sourceforge.tmdmaker.ui.views.properties.DiagramPropertySource;
import jp.sourceforge.tmdmaker.ui.views.properties.IPropertyAvailable;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.ui.views.properties.IPropertySource;

public class DiagramEditPart
extends AbstractTMDEditPart<Diagram>
implements IPropertyAvailable {
    public DiagramEditPart(Diagram diagram) {
        this.setModel(diagram);
    }

    protected IFigure createFigure() {
        FreeformLayer figure = new FreeformLayer();
        figure.setLayoutManager((LayoutManager)new FreeformLayout());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DiagramEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_property_children")) {
            this.refreshChildren();
        }
    }

    protected List<ModelElement> getModelChildren() {
        return ((Diagram)this.getModel()).getChildren();
    }

    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            ss = snapStrategies.toArray(ss);
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(key);
    }

    @Override
    public IPropertySource getPropertySource(TMDEditor editor) {
        return new DiagramPropertySource(editor, (Diagram)this.getModel());
    }

    private class DiagramEditPolicy
    extends XYLayoutEditPolicy {
        private DiagramEditPolicy() {
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            DiagramEditPart.this.logger.debug(((Object)((Object)this)).getClass() + "#createChildEditPolicy()");
            return new ResizableEditPolicy();
        }

        protected Command createChangeConstraintCommand(EditPart child, Object rectangle) {
            DiagramEditPart.this.logger.debug(((Object)((Object)this)).getClass() + "#createChangeConstraintCommand()");
            ConstraintChangeCommand command = new ConstraintChangeCommand((ModelElement)child.getModel(), (Rectangle)rectangle);
            return command;
        }

        protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object rectangle) {
            DiagramEditPart.this.logger.debug("resizedirection:" + request.getResizeDirection());
            DiagramEditPart.this.logger.debug("NORTH_SOUTH/EAST_WEST:5/24");
            return super.createChangeConstraintCommand(request, child, rectangle);
        }

        protected Command getCreateCommand(CreateRequest request) {
            DiagramEditPart.this.logger.debug(((Object)((Object)this)).getClass() + "#getCreateCommand()" + request.getNewObjectType());
            Rectangle rectangle = this.getTrimmedRectangle(request);
            ConnectableElement model = (ConnectableElement)request.getNewObject();
            ConstraintConverter.setConstraint((ModelElement)model, rectangle);
            if (model instanceof TurboFile) {
                return this.createTurboFileCommand(rectangle, model);
            }
            if (model instanceof AbstractEntityModel) {
                return new EntityModelAddCommand((Diagram)DiagramEditPart.this.getModel(), rectangle.x, rectangle.y);
            }
            if (model instanceof Memo) {
                return this.createMemoCommand(rectangle, model);
            }
            return null;
        }

        private Rectangle getTrimmedRectangle(CreateRequest request) {
            Rectangle rectangle = (Rectangle)this.getConstraintFor(request);
            rectangle.height = -1;
            rectangle.width = -1;
            return rectangle;
        }

        private EntityModelAddCommand createTurboFileCommand(Rectangle rectangle, ConnectableElement model) {
            TurboFile turbo = (TurboFile)model;
            turbo.setName(Messages.TurboFile);
            return new EntityModelAddCommand((Diagram)DiagramEditPart.this.getModel(), (AbstractEntityModel)turbo, rectangle.x, rectangle.y);
        }

        private Command createMemoCommand(Rectangle rectangle, ConnectableElement model) {
            Memo memo = (Memo)model;
            CompoundCommand command = new CompoundCommand();
            command.add((Command)new MemoAddCommand((Diagram)DiagramEditPart.this.getModel(), memo, rectangle.x, rectangle.y));
            command.add((Command)new MemoChangeCommand(memo, Messages.Memo));
            return command;
        }
    }
}

