/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.ui.refactoring.ChangePreviewViewerInput;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class TextEditChangePreviewViewer
implements IChangePreviewViewer {
    private ComparePreviewer fViewer;

    public static ChangePreviewViewerInput createInput(TextEditBasedChange change) {
        return new ChangePreviewViewerInput((Change)change);
    }

    public static ChangePreviewViewerInput createInput(Change change, TextEditBasedChangeGroup group, int surroundingLines) {
        TextEditBasedChangeInput input = new TextEditBasedChangeInput(change);
        input.group = group;
        input.surroundingLines = surroundingLines;
        return input;
    }

    public static ChangePreviewViewerInput createInput(Change change, TextEditBasedChangeGroup[] groups, IRegion range) {
        TextEditBasedChangeInput input = new TextEditBasedChangeInput(change);
        input.groups = groups;
        input.range = range;
        return input;
    }

    @Override
    public void createControl(Composite parent) {
        this.fViewer = new ComparePreviewer(parent);
    }

    @Override
    public Control getControl() {
        return this.fViewer;
    }

    @Override
    public void setInput(ChangePreviewViewerInput input) {
        try {
            Change change = input.getChange();
            if (input instanceof TextEditBasedChangeInput) {
                TextEditBasedChangeInput extended = (TextEditBasedChangeInput)input;
                if (extended.group != null && extended.surroundingLines >= 0) {
                    TextEditBasedChangeGroup group = extended.group;
                    TextEditBasedChange editChange = group.getTextEditChange();
                    this.setInput(editChange, editChange.getCurrentContent(group.getRegion(), true, 2, (IProgressMonitor)new NullProgressMonitor()), editChange.getPreviewContent(new TextEditBasedChangeGroup[]{group}, group.getRegion(), true, 2, (IProgressMonitor)new NullProgressMonitor()), editChange.getTextType());
                    return;
                }
                if (extended.groups != null && extended.groups.length > 0 && extended.range != null) {
                    TextEditBasedChange editChange = extended.groups[0].getTextEditChange();
                    TextEditBasedChangeGroup[] groups = extended.groups;
                    GroupCategory cfr_ignored_0 = extended.groupCategory;
                    this.setInput(editChange, editChange.getCurrentContent(extended.range, true, 0, (IProgressMonitor)new NullProgressMonitor()), editChange.getPreviewContent(groups, extended.range, true, 0, (IProgressMonitor)new NullProgressMonitor()), editChange.getTextType());
                    return;
                }
            } else {
                if (change instanceof TextEditBasedChange) {
                    TextEditBasedChange editChange = (TextEditBasedChange)change;
                    this.setInput(editChange, editChange.getCurrentContent((IProgressMonitor)new NullProgressMonitor()), editChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor()), editChange.getTextType());
                    return;
                }
                this.fViewer.setInput(null);
            }
        }
        catch (CoreException e) {
            RefactoringUIPlugin.log(e);
            this.fViewer.setInput(null);
        }
        catch (AssertionFailedException e) {
            RefactoringUIPlugin.log(e);
            this.fViewer.setInput(null);
        }
    }

    public void refresh() {
        this.fViewer.getViewer().refresh();
    }

    private void setInput(TextEditBasedChange change, String left, String right, String type) {
        Object element = change.getModifiedElement();
        IResource resource = null;
        if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class);
            if (workbenchAdapter != null) {
                this.fViewer.setLabel(workbenchAdapter.getLabel(element));
                this.fViewer.setImageDescriptor(workbenchAdapter.getImageDescriptor(element));
            } else {
                this.fViewer.setLabel(null);
                this.fViewer.setImageDescriptor(null);
            }
            resource = (IResource)adaptable.getAdapter(IResource.class);
        } else {
            this.fViewer.setLabel(null);
            this.fViewer.setImageDescriptor(null);
        }
        this.fViewer.setInput(new DiffNode((ITypedElement)new CompareElement(left, type, resource), (ITypedElement)new CompareElement(right, type, resource)));
    }

    private static class CompareElement
    implements ITypedElement,
    IEncodedStreamContentAccessor,
    IResourceProvider {
        private static final String ENCODING = "UTF-8";
        private String fContent;
        private String fType;
        private IResource fResource;

        public CompareElement(String content, String type, IResource resource) {
            this.fContent = content;
            this.fType = type;
            this.fResource = resource;
        }

        public String getName() {
            return RefactoringUIMessages.ComparePreviewer_element_name;
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return this.fType;
        }

        public InputStream getContents() throws CoreException {
            try {
                return new ByteArrayInputStream(this.fContent.getBytes(ENCODING));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new ByteArrayInputStream(this.fContent.getBytes());
            }
        }

        public String getCharset() {
            return ENCODING;
        }

        public IResource getResource() {
            return this.fResource;
        }
    }

    private static class ComparePreviewer
    extends CompareViewerSwitchingPane {
        private CompareConfiguration fCompareConfiguration = new CompareConfiguration();
        private String fLabel;
        private ImageDescriptor fDescriptor;
        private Image fImage;

        public ComparePreviewer(Composite parent) {
            super(parent, 0x800800, true);
            this.fCompareConfiguration.setLeftEditable(false);
            this.fCompareConfiguration.setLeftLabel(RefactoringUIMessages.ComparePreviewer_original_source);
            this.fCompareConfiguration.setRightEditable(false);
            this.fCompareConfiguration.setRightLabel(RefactoringUIMessages.ComparePreviewer_refactored_source);
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (fImage != null && !fImage.isDisposed()) {
                        fImage.dispose();
                    }
                }
            });
            Dialog.applyDialogFont((Control)this);
        }

        public void setLabel(String label) {
            this.fLabel = label;
        }

        public void setImageDescriptor(ImageDescriptor imageDescriptor) {
            this.fDescriptor = imageDescriptor;
        }

        protected Viewer getViewer(Viewer oldViewer, Object input) {
            return CompareUI.findContentViewer((Viewer)oldViewer, (ICompareInput)((ICompareInput)input), (Composite)this, (CompareConfiguration)this.fCompareConfiguration);
        }

        public void setText(String text) {
            if (this.fLabel != null) {
                super.setText(this.fLabel);
            } else {
                super.setText(text);
            }
            Image current = null;
            if (this.fDescriptor != null) {
                current = this.fImage;
                this.fImage = this.fDescriptor.createImage();
            } else {
                current = this.fImage;
                this.fImage = null;
            }
            this.setImage(this.fImage);
            if (current != null) {
                current.dispose();
            }
        }
    }

    private static class TextEditBasedChangeInput
    extends ChangePreviewViewerInput {
        TextEditBasedChangeGroup group;
        int surroundingLines;
        TextEditBasedChangeGroup[] groups;
        IRegion range;
        GroupCategory groupCategory;

        public TextEditBasedChangeInput(Change change) {
            super(change);
        }
    }
}

