/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.dialogs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import jp.sourceforge.tmdmaker.ui.dialogs.components.ImplementInfoEditPanel;
import jp.sourceforge.tmdmaker.ui.dialogs.components.IndexSettingPanel;
import jp.sourceforge.tmdmaker.ui.dialogs.components.ModelSelectPanel;
import jp.sourceforge.tmdmaker.ui.dialogs.components.SurrogateKeyPanel;
import jp.sourceforge.tmdmaker.ui.dialogs.models.EditImplementAttribute;
import jp.sourceforge.tmdmaker.ui.dialogs.models.EditImplementEntity;
import jp.sourceforge.tmdmaker.ui.dialogs.models.EditSurrogateKey;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ImplementInfoEditDialog
extends Dialog {
    private ImplementInfoEditPanel panel1;
    private EditImplementEntity implementModel;
    private AbstractEntityModel model;
    private List<EditImplementAttribute> editAttributeList = new ArrayList<EditImplementAttribute>();
    private AbstractEntityModel editedValueEntity;
    private List<EditImplementAttribute> editedValueAttributes = new ArrayList<EditImplementAttribute>();
    private List<EditImplementAttribute> editedValueIdentifiers = new ArrayList<EditImplementAttribute>();
    private Map<AbstractEntityModel, List<EditImplementAttribute>> otherModelAttributesMap = new HashMap<AbstractEntityModel, List<EditImplementAttribute>>();
    private ModelSelectPanel panel2;
    private IndexSettingPanel panel3;
    private SurrogateKeyPanel panel4;
    private Button updateButton;

    public ImplementInfoEditDialog(Shell parentShell, AbstractEntityModel model) {
        super(parentShell);
        this.model = model;
        this.implementModel = new EditImplementEntity(model);
        this.implementModel.addPropertyChangeListener(new ImplementInfoUpdateListener());
        this.editAttributeList = this.implementModel.getAttributes();
        this.otherModelAttributesMap = this.implementModel.getOtherModelAttributesMap();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.EditImplementInformation);
        TabFolder tabFolder = new TabFolder(parent, 0);
        TabItem item1 = new TabItem(tabFolder, 0);
        item1.setText(Messages.TableDesign);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(768);
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)gridLayout);
        this.panel1 = new ImplementInfoEditPanel(composite, 0, this.implementModel);
        this.panel1.setLayoutData(gridData);
        gridData = new GridData(768);
        this.panel2 = new ModelSelectPanel(composite, 0);
        List selectModels = this.model.getImplementDerivationModels();
        List notSelectModels = ImplementRule.findNotImplementModel((AbstractEntityModel)this.model);
        notSelectModels.removeAll(selectModels);
        this.panel2.initializeValue(selectModels, notSelectModels);
        this.panel2.setLayoutData(gridData);
        item1.setControl((Control)composite);
        this.updateButton = new Button(composite, 0);
        this.updateButton.setText(Messages.ReflectAttribute);
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Map.Entry entry : ImplementInfoEditDialog.this.otherModelAttributesMap.entrySet()) {
                    ImplementInfoEditDialog.this.editAttributeList.removeAll((Collection)entry.getValue());
                }
                for (AbstractEntityModel m : ImplementInfoEditDialog.this.panel2.getSelectModels()) {
                    List list = (List)ImplementInfoEditDialog.this.otherModelAttributesMap.get(m);
                    if (list == null) continue;
                    ImplementInfoEditDialog.this.editAttributeList.addAll(list);
                }
                ImplementInfoEditDialog.this.panel1.updateTable();
            }
        });
        TabItem item2 = new TabItem(tabFolder, 0);
        item2.setText(Messages.KeyDefinitions);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        this.panel3 = new IndexSettingPanel(composite, 0, this.implementModel);
        this.panel3.setLayoutData(gridData);
        this.panel3.updateTable();
        gridData = new GridData(768);
        this.panel4 = new SurrogateKeyPanel(composite, 0, this.implementModel);
        this.panel4.setLayoutData(gridData);
        this.panel4.refreshVisual();
        item2.setControl((Control)composite);
        composite.pack();
        return composite;
    }

    protected void okPressed() {
        this.editedValueEntity = this.model.getCopy();
        this.editedValueEntity.setImplementName(this.panel1.getImplementName());
        this.editedValueEntity.setImplementDerivationModels(this.panel2.getSelectModels());
        this.editedValueEntity.setKeyModels(this.implementModel.getKeyModels());
        this.createEditAttributeResult();
        super.okPressed();
    }

    private void createEditAttributeResult() {
        for (EditImplementAttribute ea : this.implementModel.getAttributes()) {
            if (!ea.isEdited()) continue;
            this.editedValueAttributes.add(ea);
        }
    }

    public AbstractEntityModel getEditedValueEntity() {
        return this.editedValueEntity;
    }

    public List<EditImplementAttribute> getEditedValueAttributes() {
        return this.editedValueAttributes;
    }

    public List<EditImplementAttribute> getEditedValueIdentifiers() {
        return this.editedValueIdentifiers;
    }

    public EditSurrogateKey getEditedSurrogateKey() {
        return this.implementModel.getSurrogateKey();
    }

    private class ImplementInfoUpdateListener
    implements PropertyChangeListener {
        private ImplementInfoUpdateListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("attributes")) {
                ImplementInfoEditDialog.this.panel1.updateTable();
                ImplementInfoEditDialog.this.panel3.updateTable();
                ImplementInfoEditDialog.this.panel4.refreshVisual();
            } else if (evt.getPropertyName().equals("surrogate")) {
                ImplementInfoEditDialog.this.panel3.updateTable();
                ImplementInfoEditDialog.this.panel1.updateTable();
            } else if (evt.getPropertyName().equals("keymodels")) {
                ImplementInfoEditDialog.this.panel3.updateTable();
            }
        }
    }
}

