/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.constraint.AnchorConstraint;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.AnchorConstraintManager;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.ConstraintConverter;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.anchors.XYChopboxAnchor;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.anchors.XYChopboxAnchorHelper;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.figure.node.TFormFigure;
import jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.node.AbstractTMDEditPart;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ReconnectRequest;

public abstract class AbstractModelEditPart<T extends ConnectableElement>
extends AbstractTMDEditPart<T>
implements NodeEditPart {
    private ConnectionAnchor anchor;

    @Override
    public void activate() {
        this.logger.debug(this.getClass() + "#activate()");
        super.activate();
        ((ConnectableElement)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void deactivate() {
        this.logger.debug(this.getClass() + "#deactivate()");
        super.deactivate();
        ((ConnectableElement)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
    }

    protected ConnectionAnchor getConnectionAnchor() {
        if (this.anchor == null) {
            this.anchor = new XYChopboxAnchor(this.getFigure());
        }
        return this.anchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        AbstractConnectionModel relationship = (AbstractConnectionModel)connection.getModel();
        XYChopboxAnchor anchor = new XYChopboxAnchor(this.getFigure(), AnchorConstraintManager.getSourceAnchorConstraint(relationship));
        return anchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        IFigure thisFigure = this.getFigure();
        if (request instanceof ReconnectRequest) {
            ReconnectRequest reconnectRequest = (ReconnectRequest)request;
            ConnectionEditPart connectionEditPart = reconnectRequest.getConnectionEditPart();
            AbstractConnectionModel relationship = (AbstractConnectionModel)connectionEditPart.getModel();
            if (relationship.getSource() == relationship.getTarget()) {
                return new XYChopboxAnchor(thisFigure);
            }
            EditPart editPart = reconnectRequest.getTarget();
            if (editPart == null || !editPart.getModel().equals(relationship.getSource())) {
                return new XYChopboxAnchor(thisFigure);
            }
            Point location = new Point(reconnectRequest.getLocation());
            thisFigure.translateToRelative((Translatable)location);
            IFigure sourceFigure = ((AbstractModelEditPart)connectionEditPart.getSource()).getFigure();
            AnchorConstraint newAnchorConstraint = new XYChopboxAnchorHelper(sourceFigure.getBounds()).calculateAnchorConstraint(location);
            return new XYChopboxAnchor(thisFigure, newAnchorConstraint);
        }
        return new XYChopboxAnchor(thisFigure);
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        AbstractConnectionModel relationship = (AbstractConnectionModel)connection.getModel();
        XYChopboxAnchor anchor = new XYChopboxAnchor(this.getFigure(), AnchorConstraintManager.getTargetAnchorConstraint(relationship));
        return anchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        this.logger.debug("getTargetConnectionAnchor(Request request)");
        IFigure thisFigure = this.getFigure();
        if (request instanceof ReconnectRequest) {
            ReconnectRequest reconnectRequest = (ReconnectRequest)request;
            ConnectionEditPart connectionEditPart = reconnectRequest.getConnectionEditPart();
            AbstractConnectionModel relationship = (AbstractConnectionModel)connectionEditPart.getModel();
            if (relationship.getSource() == relationship.getTarget()) {
                return new XYChopboxAnchor(thisFigure);
            }
            EditPart editPart = reconnectRequest.getTarget();
            if (editPart == null || !editPart.getModel().equals(relationship.getTarget())) {
                return new XYChopboxAnchor(thisFigure);
            }
            Point location = new Point(reconnectRequest.getLocation());
            thisFigure.translateToRelative((Translatable)location);
            IFigure targetFigure = ((AbstractModelEditPart)connectionEditPart.getTarget()).getFigure();
            AnchorConstraint newAnchorConstraint = new XYChopboxAnchorHelper(targetFigure.getBounds()).calculateAnchorConstraint(location);
            return new XYChopboxAnchor(thisFigure, newAnchorConstraint);
        }
        return new XYChopboxAnchor(thisFigure);
    }

    protected List<AbstractConnectionModel> getModelSourceConnections() {
        return ((ConnectableElement)this.getModel()).getModelSourceConnections();
    }

    protected List<AbstractConnectionModel> getModelTargetConnections() {
        return ((ConnectableElement)this.getModel()).getModelTargetConnections();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.logger.debug(this.getClass() + "." + evt.getPropertyName());
        if (evt.getPropertyName().equals("_property_name")) {
            this.handleNameChange(evt);
        } else if (evt.getPropertyName().equals("_property_constraint")) {
            this.handleConstraintChange(evt);
        } else if (evt.getPropertyName().equals("p_attribute")) {
            this.handleAttributeChange(evt);
        } else if (evt.getPropertyName().equals("p_source_connection")) {
            this.handleSourceConnectionChange(evt);
        } else if (evt.getPropertyName().equals("p_target_connection")) {
            this.handleTargetConnectionChange(evt);
        } else if (evt.getPropertyName().equals("p_reused")) {
            this.handleReUseKeyChange(evt);
        } else if (evt.getPropertyName().equals("_property_identifier")) {
            this.handleIdentifierChange(evt);
        } else if (evt.getPropertyName().equals("p_attribute_reorder")) {
            this.logger.warn("Handle Reorder Occured.");
            this.refreshChildren();
        } else {
            this.logger.warn("Not Handle Event Occured.");
        }
    }

    protected void handleNameChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleConstraintChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleAttributeChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
        this.refreshChildren();
    }

    protected void handleIdentifierChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleSourceConnectionChange(PropertyChangeEvent evt) {
        this.refreshSourceConnections();
    }

    protected void handleTargetConnectionChange(PropertyChangeEvent evt) {
        this.refreshTargetConnections();
    }

    protected void handleAttributeReorder(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleReUseKeyChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    public void refresh() {
        super.refresh();
        this.refleshConnections();
    }

    protected void refreshVisuals() {
        this.logger.debug(String.valueOf(this.getClass().toString()) + "(" + ((ConnectableElement)this.getModel()).getName() + ") #refreshVisuals()");
        super.refreshVisuals();
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)this.convert((ConnectableElement)this.getModel()));
        this.updateFigure(this.getFigure());
    }

    protected Rectangle convert(T model) {
        return ConstraintConverter.getRectangle(model);
    }

    public void updateAppearance() {
        this.refreshVisuals();
    }

    protected void refleshConnections() {
        for (AbstractConnectionModel connection : this.getModelSourceConnections()) {
            connection.fireParentMoved();
        }
        for (AbstractConnectionModel connection : this.getModelTargetConnections()) {
            connection.fireParentMoved();
        }
    }

    protected abstract void updateFigure(IFigure var1);

    public IFigure getContentPane() {
        return ((TFormFigure)this.getFigure()).getAttributeCompartmentFigure();
    }

    public abstract boolean canAutoSize();

    public boolean canCreateSubset() {
        return ((ConnectableElement)this.getModel()).canCreateSubset();
    }

    public boolean canCreateMultivalueOr() {
        return ((ConnectableElement)this.getModel()).canCreateMultivalueOr();
    }

    public boolean canCreateMultivalueAnd() {
        return ((ConnectableElement)this.getModel()).canCreateMultivalueAnd();
    }

    public boolean canCreateVirtualEntity() {
        return ((ConnectableElement)this.getModel()).canCreateVirtualEntity();
    }

    public boolean canCallSelectionAction() {
        return true;
    }
}

