/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.actions;

import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.rule.SubsetRule;
import jp.sourceforge.tmdmaker.ui.actions.AbstractEntitySelectionAction;
import jp.sourceforge.tmdmaker.ui.dialogs.SubsetCreateDialog;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.adjuster.SubsetTypeAdjuster;
import jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.node.AbstractModelEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IWorkbenchPart;

public class SubsetCreateAction
extends AbstractEntitySelectionAction {
    public static final String ID = "_SUBSET";

    public SubsetCreateAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.CreateSubset);
        this.setId(ID);
    }

    @Override
    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() != 1) {
            return false;
        }
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof AbstractModelEditPart) {
            return this.getPart().canCreateSubset();
        }
        return false;
    }

    public void run() {
        AbstractModelEditPart<? extends AbstractEntityModel> part = this.getPart();
        AbstractEntityModel model = this.getModel();
        SubsetType subsetType = SubsetRule.setupSubsetType((AbstractEntityModel)model);
        new SubsetTypeAdjuster(model, subsetType).adjust();
        SubsetCreateDialog dialog = new SubsetCreateDialog(part.getViewer().getControl().getShell(), subsetType, model);
        if (dialog.open() == 0) {
            CompoundCommand ccommand = dialog.getCcommand();
            this.execute((Command)ccommand);
        }
    }
}

