/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.serializer.handler.patch;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.Entity2VirtualSupersetTypeRelationship;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType2VirtualSupersetRelationship;
import jp.sourceforge.tmdmaker.serializer.handler.patch.AbstractSerializerHandler;
import jp.sourceforge.tmdmaker.serializer.handler.patch.AnchorConstraintMigrator;

public class Patch040SerializerHandler
extends AbstractSerializerHandler {
    @Override
    public Diagram handleAfterDeserialize(Diagram in) {
        if (this.versionUnderEqual(in, 0, 4, 0)) {
            this.logger.info("apply patch 0.4.0");
            for (ModelElement o : in.getChildren()) {
                if (o instanceof AbstractEntityModel) {
                    AbstractEntityModel model = (AbstractEntityModel)o;
                    this.convertRelatedRelationships(model);
                }
                if (!(o instanceof VirtualSuperset)) continue;
                this.convertVirtualSupersetType2VirtualSupersetRelationship((VirtualSuperset)o);
            }
        }
        return in;
    }

    private void convertRelatedRelationships(AbstractEntityModel model) {
        this.convertNullLocationPoint(model.getModelSourceConnections());
        this.convertNullLocationPoint(model.getModelTargetConnections());
    }

    private void convertNullLocationPoint(List<AbstractConnectionModel> connections) {
        AnchorConstraintMigrator converter = new AnchorConstraintMigrator();
        for (AbstractConnectionModel c : connections) {
            converter.convertNullLocationPoint(c);
        }
    }

    private void convertVirtualSupersetType2VirtualSupersetRelationship(VirtualSuperset superset) {
        AbstractConnectionModel acm = (AbstractConnectionModel)superset.getModelTargetConnections().get(0);
        if (acm instanceof VirtualSupersetType2VirtualSupersetRelationship) {
            return;
        }
        RelatedRelationship rr = (RelatedRelationship)acm;
        VirtualSupersetType type = (VirtualSupersetType)rr.getSource();
        VirtualSupersetType2VirtualSupersetRelationship newRelationship = new VirtualSupersetType2VirtualSupersetRelationship();
        ArrayList<Entity2VirtualSupersetTypeRelationship> newSubsetList = new ArrayList<Entity2VirtualSupersetTypeRelationship>();
        for (AbstractConnectionModel c : type.getModelTargetConnections()) {
            newSubsetList.add((Entity2VirtualSupersetTypeRelationship)c);
        }
        rr.disconnect();
        newRelationship.setSource((ConnectableElement)type);
        newRelationship.setTarget((ConnectableElement)superset);
        newRelationship.setSubset2typeRelationshipList(newSubsetList);
        newRelationship.connect();
    }
}

