/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.wizard;

import java.io.InputStream;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.extension.SerializerFactory;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.persistence.SerializationException;
import jp.sourceforge.tmdmaker.model.persistence.Serializer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewDiagramWizard
extends Wizard
implements INewWizard {
    private static Logger logger = LoggerFactory.getLogger(NewDiagramWizard.class);
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private NewDiagramCreationPage page;

    public NewDiagramWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.CreateNewDiagram);
    }

    public boolean performFinish() {
        IFile file = this.page.createNewFile();
        if (file == null) {
            return false;
        }
        IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
        }
        catch (PartInitException e) {
            logger.error("open error.", (Throwable)e);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        this.page = new NewDiagramCreationPage(Messages.NewDiagram, this.selection);
        this.addPage((IWizardPage)this.page);
        super.addPages();
    }

    private static class NewDiagramCreationPage
    extends WizardNewFileCreationPage {
        public NewDiagramCreationPage(String string, IStructuredSelection selection) {
            super(string, selection);
            this.setFileExtension("tmd");
            this.setFileName("diagram.tmd");
            this.setTitle(Messages.NewDiagramWizardTitle);
            this.setDescription(Messages.NewDiagramWizardDescription);
        }

        protected InputStream getInitialContents() {
            Diagram diagram = new Diagram();
            try {
                Serializer serializer = SerializerFactory.getInstance();
                return serializer.serialize(diagram);
            }
            catch (SerializationException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

