/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import jp.sourceforge.tmdmaker.TMDEditor;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityModelEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityEditComponentPolicy;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.TMDModelGraphicalNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.property.EntityPropertySource;
import jp.sourceforge.tmdmaker.property.IPropertyAvailable;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.ui.views.properties.IPropertySource;

public class EntityEditPart
extends AbstractEntityModelEditPart<Entity>
implements IPropertyAvailable {
    public EntityEditPart(Entity entity) {
        this.setModel(entity);
    }

    @Override
    protected void updateFigure(IFigure figure) {
        logger.debug(this.getClass() + "#updateFigure()");
        EntityFigure entityFigure = (EntityFigure)figure;
        Entity entity = (Entity)this.getModel();
        entityFigure.setNotImplement(entity.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(entity.getName());
        entityFigure.setEntityType(entity.getEntityType().getLabel());
        entityFigure.setColor(this.getForegroundColor(), this.getBackgroundColor());
        entityFigure.setIdentifier(entity.getIdentifier().getName());
        entityFigure.addRelationship(this.extractRelationship(entity));
    }

    @Override
    protected ModelAppearance getAppearance() {
        ModelAppearance appearance = null;
        if (((Entity)this.getModel()).getEntityType().equals((Object)EntityType.RESOURCE)) {
            appearance = ModelAppearance.RESOURCE;
        } else if (((Entity)this.getModel()).getEntityType().equals((Object)EntityType.EVENT)) {
            appearance = ModelAppearance.EVENT;
        }
        return appearance;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EntityEditComponentPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TMDModelGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }

    @Override
    public IPropertySource getPropertySource(TMDEditor editor) {
        return new EntityPropertySource(editor, (Entity)this.getModel());
    }
}

