/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.beans.PropertyChangeEvent;
import jp.sourceforge.tmdmaker.TMDEditor;
import jp.sourceforge.tmdmaker.editpart.AbstractTMDEditPart;
import jp.sourceforge.tmdmaker.editpolicy.AttributeComponentEditPolicy;
import jp.sourceforge.tmdmaker.model.Attribute;
import jp.sourceforge.tmdmaker.property.AttributePropertySource;
import jp.sourceforge.tmdmaker.property.IPropertyAvailable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.EditPolicy;
import org.eclipse.ui.views.properties.IPropertySource;

public class AttributeEditPart
extends AbstractTMDEditPart<Attribute>
implements IPropertyAvailable {
    public AttributeEditPart(Attribute attribute) {
        this.setModel(attribute);
    }

    protected IFigure createFigure() {
        Label label = new Label();
        label.setText(this.createAttributeName((Attribute)this.getModel()));
        label.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        label.setLabelAlignment(1);
        return label;
    }

    private String createAttributeName(Attribute attribute) {
        StringBuilder name = new StringBuilder(attribute.getName());
        if (attribute.isDerivation()) {
            name.append("(D)");
        }
        return name.toString();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new AttributeComponentEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_property_name")) {
            logger.debug("Handle Name Event.");
            this.handleNameChange(evt);
        } else {
            logger.warn("Not Handle Event Occured.");
        }
    }

    protected void refreshVisuals() {
        Label f = (Label)this.getFigure();
        f.setText(this.createAttributeName((Attribute)this.getModel()));
        this.getParent().refresh();
    }

    protected void handleNameChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    @Override
    public IPropertySource getPropertySource(TMDEditor editor) {
        return new AttributePropertySource(editor, (Attribute)this.getModel());
    }
}

