/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.beans.PropertyChangeListener;
import jp.sourceforge.tmdmaker.model.ModelElement;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTMDEditPart<T extends ModelElement>
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    protected static Logger logger;

    public AbstractTMDEditPart() {
        logger = LoggerFactory.getLogger(this.getClass());
    }

    public void activate() {
        super.activate();
        this.getModel().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void deactivate() {
        super.deactivate();
        this.getModel().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void performRequest(Request req) {
        Object requestType = req.getType();
        logger.debug(this.getClass() + " " + requestType);
        if (requestType.equals("open")) {
            this.executeEditCommand(this.getCommand(req));
        } else if (requestType.equals("direct edit")) {
            this.onDirectEdit();
        } else {
            super.performRequest(req);
        }
    }

    public T getModel() {
        return (T)((ModelElement)super.getModel());
    }

    protected void executeEditCommand(Command command) {
        this.getViewer().getEditDomain().getCommandStack().execute(command);
    }

    protected void onDirectEdit() {
    }
}

