/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.eclipse.gmf.runtime.draw2d.ui.graphics.GCUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image.ImageConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGImageConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.AbstractRenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.factory.RenderedImageKey;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;

public final class SVGImage
extends AbstractRenderedImage {
    public SVGImage(byte[] buff, RenderedImageKey key) {
        super(buff, key);
        if (key.getExtraData() == null) {
            key.setExtraData(this.getDocument());
        }
    }

    @Override
    protected Image renderImage() {
        try {
            if (GCUtilities.supportsAdvancedGraphics()) {
                SVGImageConverter converter = new SVGImageConverter();
                return converter.renderSVGtoSWTImage(this.getDocument(), this.getRenderInfo());
            }
            SVGImageConverter converter = new SVGImageConverter();
            BufferedImage img = converter.renderSVGToAWTImage(this.getDocument(), this.getRenderInfo());
            return ImageConverter.convert(img);
        }
        catch (Exception exception) {
            try {
                SVGImageConverter converter = new SVGImageConverter();
                BufferedImage img = converter.renderSVGToAWTImage(this.getDocument(), this.getRenderInfo());
                return ImageConverter.convert(img);
            }
            catch (Exception exception2) {
                return new Image((Device)Display.getDefault(), 8, 8);
            }
        }
    }

    public Document getDocument() {
        Document document = null;
        if (this.getKey().getExtraData() != null) {
            return (Document)this.getKey().getExtraData();
        }
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        ByteArrayInputStream in = new ByteArrayInputStream(this.getBuffer());
        try {
            document = f.createDocument(this.getKey().getURLString(), (InputStream)in);
        }
        catch (IOException iOException) {}
        return document;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.equals(BufferedImage.class)) {
            BufferedImage buffImg = null;
            try {
                SVGImageConverter converter = new SVGImageConverter();
                buffImg = converter.renderSVGToAWTImage(this.getDocument(), this.getRenderInfo());
            }
            catch (Exception exception) {
                buffImg = new BufferedImage(8, 8, 2);
            }
            return buffImg;
        }
        return super.getAdapter(adapter);
    }

    public BufferedImage getBufferedImage() {
        return (BufferedImage)this.getAdapter(BufferedImage.class);
    }
}

