/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.dialog.component.SubsetSettingPanel;
import jp.sourceforge.tmdmaker.dialog.model.EditSubsetEntity;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import jp.sourceforge.tmdmaker.model.rule.SubsetRule;
import jp.sourceforge.tmdmaker.ui.command.Entity2SubsetTypeCreateCommand;
import jp.sourceforge.tmdmaker.ui.command.ImplementDerivationModelsDeleteCommand;
import jp.sourceforge.tmdmaker.ui.command.ModelConstraintChangeCommand;
import jp.sourceforge.tmdmaker.ui.command.SubsetCreateCommand;
import jp.sourceforge.tmdmaker.ui.command.SubsetDeleteCommand;
import jp.sourceforge.tmdmaker.ui.command.SubsetNameChangeCommand;
import jp.sourceforge.tmdmaker.ui.command.SubsetTypeChangeCommand;
import jp.sourceforge.tmdmaker.ui.command.SubsetTypeDeleteCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SubsetCreateDialog
extends Dialog {
    private SubsetSettingPanel panel;
    private SubsetType.SubsetTypeValue subsetType;
    private boolean exceptNull;
    private List<IAttribute> attributes;
    private List<EditSubsetEntity> subsetEntities = new ArrayList<EditSubsetEntity>();
    private IAttribute selectedAttribute;
    private SubsetType.SubsetTypeValue editedSubsetType;
    private IAttribute editedPartitionAttribute;
    private List<EditSubsetEntity> editedSubsetEntities;
    private List<EditSubsetEntity> deletedSubsetEntities;
    private boolean editedExceptNull;
    private AbstractEntityModel model;
    private SubsetType orgSubsetType;
    private CompoundCommand ccommand;

    public SubsetCreateDialog(Shell parentShell, SubsetType subsetType, AbstractEntityModel model) {
        super(parentShell);
        this.subsetType = subsetType.getSubsetType();
        this.exceptNull = subsetType.isExceptNull();
        this.attributes = model.getAttributes();
        this.selectedAttribute = subsetType.getPartitionAttribute();
        for (SubsetEntity se : subsetType.getSubsetList()) {
            this.subsetEntities.add(new EditSubsetEntity(se));
        }
        this.model = model;
        this.orgSubsetType = subsetType;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.EditSubset);
        Composite composite = new Composite(parent, 0);
        this.panel = new SubsetSettingPanel(composite, 0);
        this.panel.initializeValue(this.subsetType.equals((Object)SubsetType.SubsetTypeValue.SAME), this.exceptNull, this.attributes, this.subsetEntities, this.selectedAttribute);
        composite.pack();
        return composite;
    }

    protected void okPressed() {
        this.editedSubsetType = this.createEditedSubsetType();
        int partitionSelectionIndex = this.panel.getSelectedPartitionAttributeIndex();
        if (partitionSelectionIndex != -1) {
            this.editedPartitionAttribute = this.attributes.get(partitionSelectionIndex);
        }
        this.editedSubsetEntities = this.panel.getSubsetEntityList();
        this.deletedSubsetEntities = this.panel.getDeletedSubsetEntityList();
        this.editedExceptNull = this.panel.isExceptNull();
        this.ccommand = new CompoundCommand();
        this.addSuitableSubsetTypeCommand(this.ccommand, this.model, this.orgSubsetType, this.getEditedSubsetType(), this.getEditedPartitionAttribute(), this.isEditedExceptNull());
        this.addSuitableSubsetEntityCommand(this.ccommand, this.model, this.orgSubsetType, this.getEditedSubsetEntities());
        this.addSubsetDeleteCommand(this.ccommand, this.model, this.orgSubsetType, this.getDeletedSubsetEntities());
        super.okPressed();
    }

    public CompoundCommand getCcommand() {
        return this.ccommand;
    }

    private SubsetType.SubsetTypeValue createEditedSubsetType() {
        if (this.panel.isSameTypeSelected()) {
            return SubsetType.SubsetTypeValue.SAME;
        }
        return SubsetType.SubsetTypeValue.DIFFERENT;
    }

    private SubsetType.SubsetTypeValue getEditedSubsetType() {
        return this.editedSubsetType;
    }

    private IAttribute getEditedPartitionAttribute() {
        return this.editedPartitionAttribute;
    }

    private List<EditSubsetEntity> getEditedSubsetEntities() {
        return this.editedSubsetEntities;
    }

    private List<EditSubsetEntity> getDeletedSubsetEntities() {
        return this.deletedSubsetEntities;
    }

    private boolean isEditedExceptNull() {
        return this.editedExceptNull;
    }

    private int calcurateSubsetNameSize(List<EditSubsetEntity> editSubsets) {
        int nameLength = 0;
        for (EditSubsetEntity e : editSubsets) {
            nameLength = Math.max(nameLength, e.getName().length());
        }
        return nameLength;
    }

    private int calcurateSubsetWidth(List<EditSubsetEntity> editSubsets) {
        int subsetNameLength = this.calcurateSubsetNameSize(editSubsets);
        int reusedNameLength = this.model.calcurateMaxIdentifierRefSize();
        int charLength = Math.max(subsetNameLength, reusedNameLength) * 12;
        return charLength + 14;
    }

    private void addSuitableSubsetEntityCommand(CompoundCommand ccommand, AbstractEntityModel model, SubsetType subsetType, List<EditSubsetEntity> editSubsets) {
        int subsetwidth = this.calcurateSubsetWidth(editSubsets);
        int totalWidthHalf = editSubsets.size() * subsetwidth / 2;
        int subsetX = totalWidthHalf * -1;
        for (EditSubsetEntity e : editSubsets) {
            Command command;
            if (e.isAdded()) {
                SubsetEntity subset = SubsetRule.createSubsetEntity((AbstractEntityModel)model, (String)e.getName());
                command = new SubsetCreateCommand(model, subsetType, subset);
                ccommand.add(command);
                command = new ModelConstraintChangeCommand((ModelElement)subset, subsetX, 50);
                ccommand.add(command);
            } else if (e.isNameChanged()) {
                SubsetEntity subsetEntity = e.getOriginal();
                command = new SubsetNameChangeCommand(subsetEntity, e.getName());
                ccommand.add(command);
            }
            subsetX += subsetwidth;
        }
    }

    private void addSubsetDeleteCommand(CompoundCommand ccommand, AbstractEntityModel model, SubsetType subsetType, List<EditSubsetEntity> deleteSubsets) {
        ArrayList<EditSubsetEntity> deletedList = new ArrayList<EditSubsetEntity>();
        for (EditSubsetEntity e : deleteSubsets) {
            if (e.getOriginal() == null) continue;
            deletedList.add(e);
        }
        AbstractEntityModel original = null;
        for (EditSubsetEntity e : deletedList) {
            SubsetEntity subset = e.getOriginal();
            if (original == null) {
                original = ImplementRule.findOriginalImplementModel((AbstractEntityModel)subset);
            }
            if (subset == null) continue;
            SubsetDeleteCommand command = new SubsetDeleteCommand(subset);
            ccommand.add((Command)command);
            if (!subset.isNotImplement()) continue;
            ccommand.add((Command)new ImplementDerivationModelsDeleteCommand((AbstractEntityModel)subset, original));
        }
        if (deletedList.size() > 0) {
            SubsetTypeDeleteCommand command = new SubsetTypeDeleteCommand(model.getDiagram(), subsetType);
            ccommand.add((Command)command);
        }
    }

    private void addSuitableSubsetTypeCommand(CompoundCommand ccommand, AbstractEntityModel model, SubsetType subsetType, SubsetType.SubsetTypeValue newSubsetType, IAttribute selectedPartitionAttribute, boolean newExceptNull) {
        if (subsetType.isNew()) {
            subsetType.setExceptNull(newExceptNull);
            subsetType.setSubsetType(newSubsetType);
            ccommand.add((Command)new Entity2SubsetTypeCreateCommand(model, subsetType, selectedPartitionAttribute));
        } else {
            ccommand.add((Command)new SubsetTypeChangeCommand(subsetType, newSubsetType, selectedPartitionAttribute, newExceptNull));
        }
    }
}

