/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog;

import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.dialog.component.ModelSelectPanel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GeneratorDialog
extends Dialog {
    private Text savePathInputText;
    private ModelSelectPanel panel;
    private String defaultSavePath;
    private String generatorName;
    private List<AbstractEntityModel> notSelectedModels;
    private List<AbstractEntityModel> selectedModels;
    private String savePath;

    public GeneratorDialog(Shell parentShell, String defaultSavePath, String generatorName, List<AbstractEntityModel> selectModels, List<AbstractEntityModel> notSelectModels) {
        super(parentShell);
        this.defaultSavePath = defaultSavePath;
        this.generatorName = generatorName;
        this.selectedModels = selectModels;
        this.notSelectedModels = notSelectModels;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.generatorName);
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(Messages.Destination);
        gridData.horizontalSpan = 2;
        pathLabel.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        this.savePathInputText = new Text(composite, 2048);
        gridData.widthHint = 150;
        this.savePathInputText.setLayoutData((Object)gridData);
        this.savePathInputText.setText(this.defaultSavePath);
        this.savePathInputText.setEditable(false);
        Button button = new Button(composite, 0);
        button.setText(Messages.Redirection);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                DirectoryDialog dialog = new DirectoryDialog(GeneratorDialog.this.getShell(), 8192);
                String rootDir = dialog.open();
                if (rootDir != null) {
                    GeneratorDialog.this.savePathInputText.setText(rootDir);
                }
            }
        });
        gridData = new GridData();
        Label filler = new Label(composite, 0);
        gridData.horizontalSpan = 2;
        filler.setLayoutData((Object)gridData);
        gridData = new GridData();
        Label modelLabel = new Label(composite, 0);
        modelLabel.setText(Messages.OutputModel);
        gridData.horizontalSpan = 2;
        modelLabel.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        this.panel = new ModelSelectPanel(composite, 0);
        gridData.horizontalSpan = 2;
        this.panel.setLayoutData(gridData);
        this.panel.initializeValue(this.selectedModels, this.notSelectedModels);
        composite.pack();
        return composite;
    }

    protected void okPressed() {
        this.savePath = this.savePathInputText.getText();
        this.selectedModels = this.panel.getSelectModels();
        super.okPressed();
    }

    public String getSavePath() {
        return this.savePath;
    }

    public List<AbstractEntityModel> getSelectedModels() {
        return this.selectedModels;
    }
}

