/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;

public class Detail
extends AbstractEntityModel {
    private ReusedIdentifier originalReusedIdentifier;
    private Identifier detailIdentifier = new Identifier();

    public void setDetailIdentifierName(String name) {
        String oldValue = this.detailIdentifier.getName();
        this.detailIdentifier.setName(name);
        if (oldValue == null || !oldValue.equals(name)) {
            this.firePropertyChange("_property_identifier", oldValue, name);
            this.fireIdentifierChanged(null);
        }
    }

    public Identifier getDetailIdentifier() {
        return this.detailIdentifier;
    }

    public void setDetailIdentifier(Identifier detailIdentifier) {
        Identifier oldValue = this.detailIdentifier;
        this.detailIdentifier = detailIdentifier;
        this.firePropertyChange("_property_identifier", oldValue, detailIdentifier);
    }

    public ReusedIdentifier getOriginalReusedIdentifier() {
        return this.originalReusedIdentifier;
    }

    public void setOriginalReusedIdentifier(ReusedIdentifier originalReusedIdentifier) {
        this.originalReusedIdentifier = originalReusedIdentifier;
    }

    @Override
    public boolean isEntityTypeEditable() {
        return false;
    }

    @Override
    public ReusedIdentifier createReusedIdentifier() {
        ReusedIdentifier returnValue = new ReusedIdentifier(this.keyModels.getSarogateKey());
        returnValue.addAll(this.originalReusedIdentifier.getIdentifires());
        returnValue.addIdentifier(this.detailIdentifier);
        return returnValue;
    }

    @Override
    public boolean isDeletable() {
        return this.getModelSourceConnections().size() == 1 && this.getModelTargetConnections().size() == 1;
    }

    @Override
    public void copyTo(AbstractEntityModel to) {
        if (to instanceof Detail) {
            Detail toDetail = (Detail)to;
            toDetail.setDetailIdentifierName(this.getDetailIdentifier().getName());
            toDetail.getDetailIdentifier().copyFrom(this.getDetailIdentifier());
        }
        super.copyTo(to);
    }

    @Override
    public Detail getCopy() {
        Detail copy = new Detail();
        this.copyTo(copy);
        return copy;
    }

    @Override
    public int calcurateMaxIdentifierRefSize() {
        int di = this.detailIdentifier.getName().length();
        int oi = this.calcurateMaxOriginalIdentifierRefSize();
        int imax = Math.max(di, oi);
        return Math.max(imax, super.calcurateMaxIdentifierRefSize());
    }

    private int calcurateMaxOriginalIdentifierRefSize() {
        int i = 0;
        for (IdentifierRef ir : this.originalReusedIdentifier.getUniqueIdentifieres()) {
            i = Math.max(ir.getName().length(), i);
        }
        return i;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }
}

