/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class ExpandAllAction
extends Action
implements ISelectionChangedListener {
    private final AbstractTreeViewer viewer;

    public ExpandAllAction(AbstractTreeViewer viewer) {
        this.viewer = viewer;
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void run() {
        this.expandAllFromSelection();
    }

    protected void expandAllFromSelection() {
        AbstractTreeViewer tree = this.viewer;
        if (tree == null) {
            return;
        }
        ISelection selection = tree.getSelection();
        if (!selection.isEmpty()) {
            Iterator elements = ((IStructuredSelection)selection).iterator();
            try {
                tree.getControl().setRedraw(false);
                while (elements.hasNext()) {
                    Object next = elements.next();
                    tree.expandToLevel(next, -1);
                }
            }
            finally {
                tree.getControl().setRedraw(true);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            this.setEnabled(!ss.isEmpty());
            return;
        }
        this.setEnabled(false);
    }
}

