/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog.component;

import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.model.StandardSQLDataType;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AttributePanel
extends Composite {
    private Label inputNameLabel = null;
    private Text inputNameText = null;
    private Label descriptionLabel = null;
    private Text validationRuleTextArea = null;
    private Label validationRuleLabel = null;
    private Label lockLabel = null;
    private Text lockTextArea = null;
    private Label dataLabel = null;
    private Combo dataCombo = null;
    private Label derivationRuleLabel = null;
    private Text derivationRuleTextArea = null;
    private Text descriptionTextArea = null;
    private Composite dataTypeComposite = null;
    private Text precisionText = null;
    private Text scaleText = null;
    private Label pLabel = null;
    private Label sLabel = null;
    private Label implementNameLabel = null;
    private Text implementNameText = null;
    private Button derivationCheckBox = null;
    private Button btnAutoIncrementCheckButton = null;
    private Text textDefaultValue;

    public AttributePanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.pack();
    }

    private void initialize() {
        GridData gridData10 = new GridData();
        gridData10.horizontalAlignment = 4;
        gridData10.verticalAlignment = 4;
        GridData gridData11 = new GridData();
        gridData11.horizontalAlignment = 4;
        gridData11.heightHint = 60;
        gridData11.verticalAlignment = 4;
        GridData gridData8 = new GridData();
        gridData8.widthHint = -1;
        gridData8.verticalAlignment = 4;
        gridData8.horizontalAlignment = 4;
        GridData gridData7 = new GridData();
        gridData7.heightHint = 60;
        gridData7.verticalAlignment = 4;
        gridData7.horizontalAlignment = 4;
        GridData gridData5 = new GridData();
        gridData5.horizontalAlignment = 4;
        gridData5.heightHint = 60;
        gridData5.verticalAlignment = 4;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.heightHint = 60;
        gridData.widthHint = 200;
        gridData.verticalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.inputNameLabel = new Label((Composite)this, 0);
        this.inputNameLabel.setText("\u540d\u79f0");
        this.inputNameLabel.setBounds(new Rectangle(0, -8, 41, 8));
        this.inputNameText = new Text((Composite)this, 2048);
        this.inputNameText.setLayoutData((Object)gridData8);
        this.implementNameLabel = new Label((Composite)this, 0);
        this.implementNameLabel.setText("\u5b9f\u88c5\u540d");
        this.implementNameText = new Text((Composite)this, 2048);
        this.implementNameText.setLayoutData((Object)gridData10);
        this.descriptionLabel = new Label((Composite)this, 0);
        this.descriptionLabel.setText("\u6458\u8981");
        this.descriptionTextArea = new Text((Composite)this, 2626);
        this.descriptionTextArea.setLayoutData((Object)gridData11);
        this.dataLabel = new Label((Composite)this, 0);
        this.dataLabel.setText("\u30c7\u30fc\u30bf\u5c5e\u6027");
        this.createDataTypeComposite();
        this.validationRuleLabel = new Label((Composite)this, 0);
        this.validationRuleLabel.setText("\u524d\u63d0");
        this.validationRuleTextArea = new Text((Composite)this, 2626);
        this.validationRuleTextArea.setLayoutData((Object)gridData);
        this.lockLabel = new Label((Composite)this, 0);
        this.lockLabel.setText("\u6a5f\u5bc6\u6027");
        this.lockTextArea = new Text((Composite)this, 2626);
        this.lockTextArea.setLayoutData((Object)gridData5);
        this.derivationRuleLabel = new Label((Composite)this, 0);
        this.derivationRuleLabel.setText("\u8a08\u7b97\u5f0f");
        this.derivationRuleTextArea = new Text((Composite)this, 2626);
        this.derivationRuleTextArea.setLayoutData((Object)gridData7);
        new Label((Composite)this, 0);
        this.derivationCheckBox = new Button((Composite)this, 32);
        this.derivationCheckBox.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.derivationCheckBox.setText("\u30c0\u30a4\u30a2\u30b0\u30e9\u30e0\u306b(D)\u3092\u8868\u793a\u3059\u308b");
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(346, 489));
    }

    private void createDataCombo() {
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.widthHint = 180;
        gridData1.horizontalSpan = 4;
        gridData1.verticalAlignment = 4;
        this.dataCombo = new Combo(this.dataTypeComposite, 8);
        this.dataCombo.setLayoutData((Object)gridData1);
        this.dataCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = ((Combo)e.getSource()).getSelectionIndex();
                AttributePanel.this.fireDataTypeChanged(index);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.dataCombo.add("");
        StandardSQLDataType[] standardSQLDataTypeArray = StandardSQLDataType.values();
        int n = standardSQLDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardSQLDataType dataType = standardSQLDataTypeArray[n2];
            this.dataCombo.add(dataType.getName());
            ++n2;
        }
    }

    public void initializeValue(EditAttribute ea) {
        this.inputNameText.setText(ea.getName());
        this.descriptionTextArea.setText(ea.getDescription());
        this.validationRuleTextArea.setText(ea.getValidationRule());
        this.lockTextArea.setText(ea.getLock());
        this.derivationRuleTextArea.setText(ea.getDerivationRule());
        this.derivationCheckBox.setSelection(ea.isDerivation());
        this.implementNameText.setText(ea.getImplementName());
        StandardSQLDataType dt = ea.getDataType();
        if (dt != null) {
            if (dt.isSupportSize()) {
                this.precisionText.setText(ea.getSize());
            }
            if (dt.isSupportScale()) {
                this.scaleText.setText(ea.getScale());
            }
            this.dataCombo.select(dt.ordinal() + 1);
            if (ea.getAutoIncrement() != null) {
                this.btnAutoIncrementCheckButton.setSelection(ea.getAutoIncrement().booleanValue());
            }
            if (ea.getDefaultValue() != null) {
                this.textDefaultValue.setText(ea.getDefaultValue());
            }
            this.fireDataTypeChanged(this.dataCombo.getSelectionIndex());
        }
    }

    private void fireDataTypeChanged(int index) {
        if (index > 0) {
            StandardSQLDataType dataType = StandardSQLDataType.values()[index - 1];
            this.precisionText.setEnabled(dataType.isSupportSize());
            this.scaleText.setEnabled(dataType.isSupportScale());
        } else {
            this.precisionText.setEnabled(true);
            this.scaleText.setEnabled(true);
        }
    }

    public String getDescription() {
        return this.descriptionTextArea.getText();
    }

    public StandardSQLDataType getDataType() {
        int selectionIndex = this.dataCombo.getSelectionIndex();
        if (selectionIndex > 0) {
            return StandardSQLDataType.values()[selectionIndex - 1];
        }
        return null;
    }

    public String getPresition() {
        if (this.precisionText.isEnabled()) {
            return this.precisionText.getText();
        }
        return "";
    }

    public String getScale() {
        if (this.scaleText.isEnabled()) {
            return this.scaleText.getText();
        }
        return "";
    }

    public Boolean getAutoIncrement() {
        if (this.btnAutoIncrementCheckButton.getSelection()) {
            return true;
        }
        return null;
    }

    public String getValidationRule() {
        return this.validationRuleTextArea.getText();
    }

    public String getLock() {
        return this.lockTextArea.getText();
    }

    public String getDerivationRule() {
        return this.derivationRuleTextArea.getText();
    }

    public boolean isDerivation() {
        return this.derivationCheckBox.getSelection();
    }

    public String getInputName() {
        return this.inputNameText.getText();
    }

    public String getImplementName() {
        return this.implementNameText.getText();
    }

    public String getDefaultValue() {
        return this.textDefaultValue.getText();
    }

    private void createDataTypeComposite() {
        GridData gridData4 = new GridData();
        gridData4.verticalAlignment = 4;
        gridData4.horizontalAlignment = 4;
        gridData4.widthHint = 30;
        GridData gridData3 = new GridData();
        gridData3.verticalAlignment = 4;
        gridData3.horizontalAlignment = 4;
        gridData3.widthHint = 50;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 4;
        gridLayout1.marginWidth = 5;
        gridLayout1.verticalSpacing = 5;
        gridLayout1.horizontalSpacing = 5;
        GridData gridData2 = new GridData();
        gridData2.widthHint = 272;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.heightHint = 140;
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 4;
        this.dataTypeComposite = new Composite((Composite)this, 0);
        this.dataTypeComposite.setLayoutData((Object)gridData2);
        this.dataTypeComposite.setLayout((Layout)gridLayout1);
        this.createDataCombo();
        this.pLabel = new Label(this.dataTypeComposite, 0);
        this.pLabel.setText("\u6841\u6570");
        this.precisionText = new Text(this.dataTypeComposite, 2048);
        this.precisionText.setLayoutData((Object)gridData3);
        this.sLabel = new Label(this.dataTypeComposite, 0);
        this.sLabel.setText("\u4f4d\u53d6\u308a");
        this.scaleText = new Text(this.dataTypeComposite, 2048);
        this.scaleText.setLayoutData((Object)gridData4);
        this.btnAutoIncrementCheckButton = new Button(this.dataTypeComposite, 32);
        this.btnAutoIncrementCheckButton.setLayoutData((Object)new GridData(4, 4, false, false, 4, 1));
        this.btnAutoIncrementCheckButton.setText("\u30aa\u30fc\u30c8\u30a4\u30f3\u30af\u30ea\u30e1\u30f3\u30c8");
        Label lblNewLabel = new Label(this.dataTypeComposite, 0);
        lblNewLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        lblNewLabel.setText("\u30c7\u30d5\u30a9\u30eb\u30c8\u5024");
        this.textDefaultValue = new Text(this.dataTypeComposite, 2048);
        this.textDefaultValue.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
    }

    public void addNameModifyListener(ModifyListener listener) {
        this.inputNameText.addModifyListener(listener);
    }

    public void removeNameModifyListener(ModifyListener listener) {
        this.inputNameText.removeModifyListener(listener);
    }
}

