/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.action;

import jp.sourceforge.tmdmaker.action.AbstractEntitySelectionAction;
import jp.sourceforge.tmdmaker.editpart.EntityEditPart;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.AbstractRelationship;
import jp.sourceforge.tmdmaker.model.Cardinality;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.Header2DetailRelationship;
import jp.sourceforge.tmdmaker.model.rule.EntityTypeRule;
import jp.sourceforge.tmdmaker.model.rule.RelationshipRule;
import jp.sourceforge.tmdmaker.ui.command.ConnectionCreateCommand;
import jp.sourceforge.tmdmaker.ui.command.ConnectionDeleteCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IWorkbenchPart;

public class MultivalueAndCreateAction
extends AbstractEntitySelectionAction {
    public static final String ID = "_MA";

    public MultivalueAndCreateAction(IWorkbenchPart part) {
        super(part);
        this.setText("\u591a\u5024\u306eAND(HDR-DTL)\u4f5c\u6210");
        this.setId(ID);
    }

    @Override
    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() == 1) {
            Object selection = this.getSelectedObjects().get(0);
            return selection instanceof EntityEditPart;
        }
        return false;
    }

    public void run() {
        AbstractEntityModel model = this.getModel();
        CompoundCommand ccommand = new CompoundCommand();
        HeaderDetailCreateCommand command = new HeaderDetailCreateCommand(model);
        ccommand.add((Command)command);
        if (EntityTypeRule.isEvent((AbstractEntityModel)model)) {
            for (AbstractConnectionModel con : model.getModelTargetConnections()) {
                AbstractRelationship relation;
                if (!(con instanceof AbstractRelationship) || !(relation = (AbstractRelationship)con).isMultiValue()) continue;
                AbstractEntityModel source = relation.getSource();
                ConnectionDeleteCommand command2 = new ConnectionDeleteCommand((AbstractConnectionModel)relation);
                ccommand.add((Command)command2);
                Detail detail = (Detail)command.getRelationship().getTarget();
                AbstractRelationship newRelation = RelationshipRule.createRelationship((AbstractEntityModel)source, (AbstractEntityModel)detail);
                newRelation.setTargetCardinality(Cardinality.MANY);
                ConnectionCreateCommand command3 = new ConnectionCreateCommand((AbstractConnectionModel)newRelation, (ConnectableElement)source, (ConnectableElement)detail);
                ccommand.add((Command)command3);
            }
        }
        this.execute(ccommand.unwrap());
    }

    private static class HeaderDetailCreateCommand
    extends Command {
        private Header2DetailRelationship relationship;

        public HeaderDetailCreateCommand(AbstractEntityModel header) {
            this.relationship = new Header2DetailRelationship(header);
            this.relationship.setTargetCardinality(Cardinality.MANY);
        }

        public void execute() {
            this.relationship.connect();
        }

        public void undo() {
            this.relationship.disconnect();
        }

        public Header2DetailRelationship getRelationship() {
            return this.relationship;
        }
    }
}

