/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;
import jp.sourceforge.tmdmaker.dialog.ModelEditDialog;
import jp.sourceforge.tmdmaker.dialog.TableEditDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityModelEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.TMDModelGraphicalNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.SubsetType2SubsetRelationship;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import jp.sourceforge.tmdmaker.ui.command.ImplementDerivationModelsDeleteCommand;
import jp.sourceforge.tmdmaker.ui.command.SubsetTypeDeleteCommand;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class SubsetEntityEditPart
extends AbstractEntityModelEditPart<SubsetEntity> {
    public SubsetEntityEditPart(SubsetEntity entity) {
        this.setModel(entity);
    }

    @Override
    protected void updateFigure(IFigure figure) {
        logger.debug(this.getClass() + "#updateFigure()");
        EntityFigure entityFigure = (EntityFigure)figure;
        SubsetEntity entity = (SubsetEntity)this.getModel();
        entityFigure.setNotImplement(entity.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(entity.getName());
        if (!entity.isSameSubset() || entity.getAttributes().size() != 0) {
            if (entity.isSupersetAnEntity()) {
                entityFigure.setIdentifier(((IdentifierRef)entity.getOriginalReusedIdentifier().getUniqueIdentifieres().get(0)).getName());
            } else {
                for (Identifier i : entity.getOriginalReusedIdentifier().getUniqueIdentifieres()) {
                    entityFigure.addRelationship(i.getName());
                }
            }
            entityFigure.addRelationship(this.extractRelationship(entity));
        }
        entityFigure.setColor(this.getForegroundColor(), this.getBackgroundColor());
    }

    @Override
    protected ModelAppearance getAppearance() {
        ModelAppearance appearance = null;
        if (((SubsetEntity)this.getModel()).getEntityType().equals((Object)EntityType.RESOURCE)) {
            appearance = ModelAppearance.RESOURCE_SUBSET;
        } else if (((SubsetEntity)this.getModel()).getEntityType().equals((Object)EntityType.EVENT)) {
            appearance = ModelAppearance.EVENT_SUBSET;
        }
        return appearance;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_property_partition")) {
            logger.debug(this.getClass() + ":" + "_property_partition");
            this.refreshVisuals();
        } else {
            super.propertyChange(evt);
        }
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new SubsetEntityComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TMDModelGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }

    @Override
    protected CompoundCommand createEditCommand(List<EditAttribute> editAttributeList, AbstractEntityModel editedValue) {
        CompoundCommand ccommand = super.createEditCommand(editAttributeList, editedValue);
        Command deleteCommand = this.getDeleteCommand(editedValue);
        if (deleteCommand != null) {
            ccommand.add(deleteCommand);
        }
        return ccommand;
    }

    @Override
    protected ModelEditDialog<SubsetEntity> getDialog() {
        return new TableEditDialog<SubsetEntity>(this.getControllShell(), "\u30b5\u30d6\u30bb\u30c3\u30c8\u8868\u7de8\u96c6", (AbstractEntityModel)this.getModel());
    }

    private static class SubsetEntityComponentEditPolicy
    extends ComponentEditPolicy {
        private SubsetEntityComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            CompoundCommand ccommand = new CompoundCommand();
            Diagram diagram = (Diagram)this.getHost().getParent().getModel();
            SubsetEntity model = (SubsetEntity)this.getHost().getModel();
            SubsetEntityDeleteCommand command1 = new SubsetEntityDeleteCommand(diagram, model);
            ccommand.add((Command)command1);
            if (model.isNotImplement()) {
                AbstractEntityModel original = ImplementRule.findOriginalImplementModel((AbstractEntityModel)model);
                ccommand.add((Command)new ImplementDerivationModelsDeleteCommand((AbstractEntityModel)model, original));
            }
            SubsetType2SubsetRelationship relationship = (SubsetType2SubsetRelationship)model.findRelationshipFromTargetConnections(SubsetType2SubsetRelationship.class).get(0);
            SubsetTypeDeleteCommand command2 = new SubsetTypeDeleteCommand(diagram, (SubsetType)relationship.getSource());
            ccommand.add((Command)command2);
            return ccommand;
        }
    }

    private static class SubsetEntityDeleteCommand
    extends Command {
        private Diagram diagram;
        private SubsetEntity model;
        private SubsetType2SubsetRelationship subsetType2SubsetEntityRelationship;

        public SubsetEntityDeleteCommand(Diagram diagram, SubsetEntity model) {
            this.diagram = diagram;
            this.model = model;
            this.subsetType2SubsetEntityRelationship = (SubsetType2SubsetRelationship)this.model.findRelationshipFromTargetConnections(SubsetType2SubsetRelationship.class).get(0);
        }

        public boolean canExecute() {
            return this.model.isDeletable();
        }

        public void execute() {
            this.subsetType2SubsetEntityRelationship.disconnect();
            this.diagram.removeChild((AbstractEntityModel)this.model);
        }

        public void undo() {
            this.diagram.addChild((AbstractEntityModel)this.model);
            this.subsetType2SubsetEntityRelationship.connect();
        }
    }
}

