/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import jp.sourceforge.tmdmaker.dialog.SupersetEditDialog;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpolicy.ReconnectableNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType;
import jp.sourceforge.tmdmaker.ui.command.ModelDeleteCommand;
import jp.sourceforge.tmdmaker.ui.command.ModelEditCommand;
import jp.sourceforge.tmdmaker.ui.command.VirtualSupersetTypeDeleteCommand;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class VirtualSupersetEditPart
extends AbstractEntityEditPart {
    @Override
    protected void updateFigure(IFigure figure) {
        EntityFigure entityFigure = (EntityFigure)figure;
        AbstractEntityModel entity = (AbstractEntityModel)this.getModel();
        entityFigure.setNotImplement(entity.isNotImplement());
        entityFigure.setEntityName(entity.getName());
        entityFigure.setEntityType(EntityType.VE.getLabel());
        this.setupColor((IFigure)entityFigure, ModelAppearance.SUPERSET_COLOR);
    }

    @Override
    protected void onDoubleClicked() {
        AbstractEntityModel entity = (AbstractEntityModel)this.getModel();
        SupersetEditDialog dialog = new SupersetEditDialog(this.getViewer().getControl().getShell(), entity);
        if (dialog.open() == 0) {
            this.getViewer().getEditDomain().getCommandStack().execute((Command)new ModelEditCommand(entity, dialog.getEditedValue()));
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new VirtualSupersetComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ReconnectableNodeEditPolicy());
    }

    private static class VirtualSupersetComponentEditPolicy
    extends ComponentEditPolicy {
        private VirtualSupersetComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            VirtualSuperset model = (VirtualSuperset)this.getHost().getModel();
            Diagram diagram = model.getDiagram();
            VirtualSupersetType aggregator = model.getVirtualSupersetType();
            CompoundCommand ccommand = new CompoundCommand();
            ccommand.add((Command)new VirtualSupersetTypeDeleteCommand(diagram, aggregator));
            ccommand.add((Command)new ModelDeleteCommand(diagram, (AbstractEntityModel)model));
            return ccommand.unwrap();
        }
    }
}

