/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog;

import jp.sourceforge.tmdmaker.dialog.component.EntityNameAndTypeSettingPanel;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.rule.EntityRecognitionRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EntityCreateDialog
extends Dialog {
    private String inputEntityName;
    private EntityType inputEntityType = EntityType.RESOURCE;
    private EntityNameAndTypeSettingPanel panel;
    private Identifier inputIdentifier;

    public EntityCreateDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u65b0\u898f\u4f5c\u6210");
        Composite composite = new Composite(parent, 0);
        FillLayout fl_composite = new FillLayout(256);
        fl_composite.marginWidth = 5;
        fl_composite.marginHeight = 5;
        composite.setLayout((Layout)fl_composite);
        this.panel = new EntityNameAndTypeSettingPanel(composite, 0);
        GridLayout gridLayout = (GridLayout)this.panel.getLayout();
        gridLayout.marginRight = 5;
        gridLayout.marginLeft = 5;
        this.panel.setEditIdentifier(new EditAttribute());
        return composite;
    }

    protected void okPressed() {
        this.inputEntityType = this.panel.getSelectedType();
        this.inputEntityName = this.panel.getEntityName();
        this.panel.getEditIdentifier();
        this.inputIdentifier = new Identifier(this.panel.getIdentifierName());
        EditAttribute editIdentifier = this.panel.getEditIdentifier();
        editIdentifier.copyTo((IAttribute)this.inputIdentifier);
        if (!this.validate()) {
            return;
        }
        super.okPressed();
    }

    private boolean validate() {
        return this.isIdentifierNameFilled() && this.isEntityNameFilled() || this.isLaputa();
    }

    private boolean isEntityNameFilled() {
        return this.inputEntityName != null && this.inputEntityName.length() > 0;
    }

    private boolean isIdentifierNameFilled() {
        String inputIdentifierName = this.inputIdentifier.getName();
        return inputIdentifierName != null && inputIdentifierName.length() > 0;
    }

    private boolean isLaputa() {
        return this.inputEntityType.equals((Object)EntityType.LAPUTA);
    }

    public EntityType getInputEntityType() {
        return this.inputEntityType;
    }

    public String getInputEntityName() {
        return this.inputEntityName;
    }

    public Identifier getInputIdentifier() {
        return this.inputIdentifier;
    }

    public AbstractEntityModel getCreateModel() {
        EntityRecognitionRule rule = EntityRecognitionRule.getInstance();
        if (this.isLaputa()) {
            return rule.createLaputa(this.getInputEntityName(), this.getInputIdentifier());
        }
        return rule.createEntity(this.getInputEntityName(), this.getInputIdentifier(), this.getInputEntityType());
    }
}

