/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.action;

import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.generate.GeneratorUtils;
import jp.sourceforge.tmdmaker.imagegenerator.Draw2dToImageConverter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DiagramImageGenerateAction
extends Action {
    private GraphicalViewer viewer;
    private IWorkbenchPart part;
    private Draw2dToImageConverter converter;
    public static final String ID = "DiagramImageGenerateAction";

    public DiagramImageGenerateAction(GraphicalViewer viewer, IWorkbenchPart part) {
        this.viewer = viewer;
        this.part = part;
        this.setText("\u30c0\u30a4\u30a2\u30b0\u30e9\u30e0\u304b\u3089\u753b\u50cf\u3092\u751f\u6210");
        this.setId(ID);
        this.converter = new Draw2dToImageConverter();
    }

    public void run() {
        FileDialog dialog = new FileDialog(this.viewer.getControl().getShell(), 8192);
        IFile editfile = GeneratorUtils.getEditFile(this.part);
        dialog.setFileName(editfile.getLocation().removeFileExtension().toOSString());
        dialog.setFilterPath(editfile.getLocation().removeFirstSegments(1).toOSString());
        String[] extensions = this.converter.getExtensions();
        dialog.setFilterExtensions(extensions);
        String file = dialog.open();
        if (file != null) {
            final StringBuffer filePath = new StringBuffer(file);
            final String extension = extensions[dialog.getFilterIndex()];
            if (!file.endsWith(extension)) {
                filePath.append(".");
                filePath.append(extension);
            }
            FreeformGraphicalRootEditPart rootEditPart = (FreeformGraphicalRootEditPart)this.getViewer().getRootEditPart();
            final IFigure figure = rootEditPart.getLayer((Object)"Printable Layers");
            try {
                new ProgressMonitorDialog(this.getViewer().getControl().getShell()).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask("\u751f\u6210", 1);
                        DiagramImageGenerateAction.this.converter.execute(figure, filePath.toString(), extension);
                        monitor.worked(1);
                        monitor.done();
                    }
                });
            }
            catch (Exception e) {
                TMDPlugin.showErrorDialog(e);
            }
            TMDPlugin.showMessageDialog(String.valueOf(this.getText()) + " \u5b8c\u4e86");
            try {
                GeneratorUtils.refreshGenerateResource(filePath.toString());
            }
            catch (Exception e) {
                TMDPlugin.showErrorDialog(e);
            }
        }
    }

    protected GraphicalViewer getViewer() {
        return this.viewer;
    }
}

