/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.SarogateKey;
import jp.sourceforge.tmdmaker.model.SarogateKeyRef;

public class ReusedIdentifier
implements Serializable {
    private List<IdentifierRef> identifieres = new ArrayList<IdentifierRef>();
    private List<SarogateKeyRef> sarogateKeys = new ArrayList<SarogateKeyRef>();

    public ReusedIdentifier() {
    }

    public ReusedIdentifier(Identifier identifier, SarogateKey sarogateKey) {
        this.addIdentifier(identifier);
        this.sarogateKeys.add(new SarogateKeyRef(sarogateKey));
    }

    public ReusedIdentifier(SarogateKey sarogateKey) {
        this.sarogateKeys.add(new SarogateKeyRef(sarogateKey));
    }

    public ReusedIdentifier(SarogateKey sarogateKey1, SarogateKey sarogateKey2) {
        this.sarogateKeys.add(new SarogateKeyRef(sarogateKey1));
        this.sarogateKeys.add(new SarogateKeyRef(sarogateKey2));
    }

    public List<IdentifierRef> getIdentifires() {
        return Collections.unmodifiableList(this.identifieres);
    }

    public List<SarogateKeyRef> getSarogateKeys() {
        return Collections.unmodifiableList(this.sarogateKeys);
    }

    public void addAll(List<IdentifierRef> identifieres) {
        for (IdentifierRef i : identifieres) {
            this.identifieres.add(new IdentifierRef(i));
        }
    }

    public void addIdentifier(Identifier identifier) {
        IdentifierRef identifierRef = new IdentifierRef(identifier);
        this.identifieres.add(identifierRef);
    }

    public void dispose() {
        this.identifieres.clear();
    }

    public boolean isSarogateKeyEnabled() {
        if (this.sarogateKeys != null && this.sarogateKeys.size() > 0) {
            SarogateKeyRef sarogateKey = this.sarogateKeys.get(0);
            return sarogateKey != null && sarogateKey.isEnabled();
        }
        return false;
    }
}

