/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.generate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.DataTypeDeclaration;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.KeyModel;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.SarogateKeyRef;
import jp.sourceforge.tmdmaker.model.StandardSQLDataType;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.NonUniqueIndex;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.UniqueIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdlUtilsConverter {
    private static Logger logger = LoggerFactory.getLogger(DdlUtilsConverter.class);
    private Map<Table, Map<String, List<Reference>>> foreignTables = new HashMap<Table, Map<String, List<Reference>>>();
    private boolean foreignKeyEnabled;

    public DdlUtilsConverter() {
        this(false);
    }

    public DdlUtilsConverter(boolean foreignKeyEnabled) {
        this.foreignKeyEnabled = foreignKeyEnabled;
    }

    public Database convert(Diagram diagram, List<AbstractEntityModel> models) {
        Database database = this.createDatabase(diagram);
        this.addModels(database, models);
        if (this.foreignKeyEnabled) {
            this.addForeignKeys(database);
        }
        return database;
    }

    private Database createDatabase(Diagram diagram) {
        Database database = new Database();
        database.setName(diagram.getName());
        return database;
    }

    private void addModels(Database database, List<AbstractEntityModel> models) {
        for (AbstractEntityModel model : models) {
            this.addModel(database, (ModelElement)model);
        }
    }

    private void addModel(Database database, ModelElement model) {
        if (!(model instanceof AbstractEntityModel)) {
            return;
        }
        AbstractEntityModel entity = (AbstractEntityModel)model;
        if (entity.isNotImplement()) {
            return;
        }
        database.addTable(this.convert(entity));
    }

    private Table convert(AbstractEntityModel entity) {
        Table table = new Table();
        table.setName(entity.getImplementName());
        table.setDescription(entity.getName());
        HashMap<IAttribute, Column> attributeColumnMap = new HashMap<IAttribute, Column>();
        this.addColumns(entity, table, attributeColumnMap);
        this.addIndices(entity, table, attributeColumnMap);
        this.setupForeignTables(entity, table);
        return table;
    }

    private void addColumns(AbstractEntityModel entity, Table table, Map<IAttribute, Column> attributeColumnMap) {
        List attributes = ImplementRule.findAllImplementAttributes((AbstractEntityModel)entity);
        for (IAttribute a : attributes) {
            Column column = this.convert(a);
            table.addColumn(column);
            attributeColumnMap.put(a, column);
        }
    }

    private void setupForeignTables(AbstractEntityModel entity, Table table) {
        HashMap<String, ArrayList<Reference>> foreinReferences = new HashMap<String, ArrayList<Reference>>();
        for (Map.Entry reusedMap : entity.getReusedIdentifieres().entrySet()) {
            Column originalColumn;
            Column localColumn;
            AbstractEntityModel foreignEntity = (AbstractEntityModel)reusedMap.getKey();
            ReusedIdentifier reused = (ReusedIdentifier)reusedMap.getValue();
            ArrayList<Reference> refences = new ArrayList<Reference>();
            if (reused.isSarogateKeyEnabled()) {
                for (SarogateKeyRef sref : reused.getSarogateKeys()) {
                    localColumn = this.convert((IAttribute)sref);
                    originalColumn = this.convert((IAttribute)sref.getOriginal());
                    this.addReference(refences, localColumn, originalColumn);
                }
            } else {
                for (IdentifierRef iref : reused.getIdentifires()) {
                    localColumn = this.convert((IAttribute)iref);
                    originalColumn = this.convert((IAttribute)iref.getOriginal());
                    this.addReference(refences, localColumn, originalColumn);
                }
            }
            foreinReferences.put(foreignEntity.getImplementName(), refences);
        }
        this.foreignTables.put(table, foreinReferences);
    }

    private void addReference(List<Reference> refences, Column localColumn, Column originalColumn) {
        Reference reference = new Reference(localColumn, originalColumn);
        refences.add(reference);
        logger.debug("\u53c2\u7167\uff1a " + localColumn.getName() + "->" + originalColumn.getName());
    }

    private void addForeignKeys(Database database) {
        for (Map.Entry<Table, Map<String, List<Reference>>> foreignRefrences : this.foreignTables.entrySet()) {
            Table table = foreignRefrences.getKey();
            Integer fidx = 0;
            for (Map.Entry<String, List<Reference>> foreignmap : foreignRefrences.getValue().entrySet()) {
                String tableName = foreignmap.getKey();
                fidx = fidx + 1;
                ForeignKey foreignKey = new ForeignKey("FK_" + tableName + fidx.toString());
                for (Reference ref : foreignmap.getValue()) {
                    foreignKey.addReference(ref);
                }
                foreignKey.setForeignTable(database.findTable(tableName));
                table.addForeignKey(foreignKey);
            }
        }
    }

    private void addIndices(AbstractEntityModel entity, Table table, Map<IAttribute, Column> attributeColumnMap) {
        for (KeyModel idx : entity.getKeyModels()) {
            if (idx.isMasterKey()) {
                this.markPrimaryKeys(table, idx);
                continue;
            }
            table.addIndex(this.convert(idx, attributeColumnMap));
        }
    }

    private void markPrimaryKeys(Table table, KeyModel idx) {
        for (IAttribute a : idx.getAttributes()) {
            Column c = table.findColumn(a.getImplementName());
            if (c == null) continue;
            c.setPrimaryKey(true);
        }
    }

    private Index convert(KeyModel key, Map<IAttribute, Column> attributeColumnMap) {
        Object index = null;
        index = key.isUnique() ? new UniqueIndex() : new NonUniqueIndex();
        index.setName(key.getName());
        for (IAttribute attr : key.getAttributes()) {
            Column column = attributeColumnMap.get(attr);
            if (column != null) {
                IndexColumn indexColumn = new IndexColumn(column);
                index.addColumn(indexColumn);
                continue;
            }
            logger.error("column not found." + attr.getName());
        }
        return index;
    }

    private Column convert(IAttribute attribute) {
        Column column = new Column();
        column.setName(attribute.getImplementName());
        DataTypeDeclaration dtd = attribute.getDataTypeDeclaration();
        if (dtd != null) {
            StandardSQLDataType dataType = dtd.getLogicalType();
            column.setTypeCode(dataType.getSqlType());
            if (dataType.isSupportSize() && dtd.getSize() != null) {
                column.setSize(dtd.getSize().toString());
            }
            if (dataType.isSupportScale() && dtd.getScale() != null) {
                column.setScale(dtd.getScale().intValue());
            }
        }
        column.setRequired(!attribute.isNullable());
        return column;
    }

    public void addCommonColumns(Database database, List<IAttribute> commonAttributes) {
        if (commonAttributes == null) {
            return;
        }
        Table[] tableArray = database.getTables();
        int n = tableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Table t = tableArray[n2];
            this.addCommonColumns(t, commonAttributes);
            ++n2;
        }
    }

    private void addCommonColumns(Table t, List<IAttribute> commonAttributes) {
        for (IAttribute a : commonAttributes) {
            t.addColumn(this.convert(a));
        }
    }
}

