/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.generate.keydefinitionlist;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.generate.Generator;
import jp.sourceforge.tmdmaker.generate.GeneratorRuntimeException;
import jp.sourceforge.tmdmaker.generate.HtmlGeneratorUtils;
import jp.sourceforge.tmdmaker.generate.keydefinitionlist.KeyDefinitionMapping;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.KeyModel;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDefinitionListHtmlGenerator
implements Generator {
    private static Logger logger = LoggerFactory.getLogger(KeyDefinitionListHtmlGenerator.class);

    public void execute(String rootDir, List<AbstractEntityModel> models) {
        VelocityContext context = HtmlGeneratorUtils.getVecityContext();
        try {
            HtmlGeneratorUtils.outputCSS(rootDir);
            HtmlGeneratorUtils.copyStream(KeyDefinitionListHtmlGenerator.class.getResourceAsStream("index.html"), new FileOutputStream(new File(rootDir, "keys_index.html")));
            context.put("entities", models);
            HtmlGeneratorUtils.applyTemplate("summary.html", this.getClass(), new File(rootDir, "summary.html"), context);
            HtmlGeneratorUtils.applyTemplate("key_list.html", this.getClass(), new File(rootDir, "key_list.html"), context);
            File keysDir = new File(rootDir, "keys");
            keysDir.mkdir();
            for (AbstractEntityModel m : models) {
                context.put("keys", (Object)m.getKeyModels());
                Map<IAttribute, List<KeyDefinitionMapping>> attributeKeyMap = this.createData(m);
                context.put("attributes", attributeKeyMap.keySet());
                context.put("mappings", attributeKeyMap.entrySet());
                context.put("entity", (Object)m);
                HtmlGeneratorUtils.applyTemplate("keys.html", this.getClass(), new File(keysDir, String.valueOf(m.getName()) + ".html"), context);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new GeneratorRuntimeException((Throwable)e);
        }
    }

    private Map<IAttribute, List<KeyDefinitionMapping>> createData(AbstractEntityModel model) {
        List attributes = ImplementRule.findAllImplementAttributes((AbstractEntityModel)model);
        LinkedHashMap<IAttribute, List<KeyDefinitionMapping>> data = new LinkedHashMap<IAttribute, List<KeyDefinitionMapping>>();
        for (IAttribute a : attributes) {
            ArrayList<KeyDefinitionMapping> list = new ArrayList<KeyDefinitionMapping>();
            for (KeyModel k : model.getKeyModels()) {
                list.add(new KeyDefinitionMapping(a, k));
            }
            data.put(a, list);
        }
        return data;
    }

    public String getGeneratorName() {
        return "\u30ad\u30fc\u5b9a\u7fa9\u66f8\u3092HTML\u5f62\u5f0f\u3067\u51fa\u529b";
    }

    public String getGroupName() {
        return "HTML";
    }

    public boolean isImplementModelOnly() {
        return true;
    }
}

