/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.dialog.TableEditDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.TMDModelGraphicalNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.SubsetType2SubsetRelationship;
import jp.sourceforge.tmdmaker.model.command.ImplementDerivationModelsDeleteCommand;
import jp.sourceforge.tmdmaker.model.command.ModelEditCommand;
import jp.sourceforge.tmdmaker.model.command.SubsetTypeDeleteCommand;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class SubsetEntityEditPart
extends AbstractEntityEditPart {
    @Override
    protected void updateFigure(IFigure figure) {
        logger.debug(this.getClass() + "#updateFigure()");
        EntityFigure entityFigure = (EntityFigure)figure;
        SubsetEntity entity = (SubsetEntity)this.getModel();
        entityFigure.setNotImplement(entity.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(entity.getName());
        if (entity.isSupersetAnEntity()) {
            entityFigure.setIdentifier(entity.getOriginalReusedIdentifier().getIdentifires().get(0).getName());
        } else {
            for (Identifier identifier : entity.getOriginalReusedIdentifier().getIdentifires()) {
                entityFigure.addRelationship(identifier.getName());
            }
        }
        for (Map.Entry entry : entity.getReusedIdentifieres().entrySet()) {
            for (Identifier identifier : ((ReusedIdentifier)entry.getValue()).getIdentifires()) {
                entityFigure.addRelationship(identifier.getName());
            }
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new SubsetEntityComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TMDModelGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }

    @Override
    protected void onDoubleClicked() {
        logger.debug(this.getClass() + "#onDoubleClicked()");
        SubsetEntity table = (SubsetEntity)this.getModel();
        TableEditDialog dialog = new TableEditDialog(this.getViewer().getControl().getShell(), "\u30b5\u30d6\u30bb\u30c3\u30c8\u8868\u7de8\u96c6", table);
        if (dialog.open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            List<EditAttribute> editAttributeList = dialog.getEditAttributeList();
            this.addAttributeEditCommands(ccommand, table, editAttributeList);
            AbstractEntityModel edited = dialog.getEditedValue();
            ModelEditCommand command = new ModelEditCommand(table, edited);
            ccommand.add((Command)command);
            if (table.isNotImplement() && !edited.isNotImplement()) {
                AbstractEntityModel original = ImplementRule.findOriginalImplementModel(table);
                ccommand.add((Command)new ImplementDerivationModelsDeleteCommand(table, original));
            }
            this.getViewer().getEditDomain().getCommandStack().execute((Command)ccommand);
        }
    }

    private static class SubsetEntityComponentEditPolicy
    extends ComponentEditPolicy {
        private SubsetEntityComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            CompoundCommand ccommand = new CompoundCommand();
            Diagram diagram = (Diagram)this.getHost().getParent().getModel();
            SubsetEntity model = (SubsetEntity)this.getHost().getModel();
            SubsetEntityDeleteCommand command1 = new SubsetEntityDeleteCommand(diagram, model);
            ccommand.add((Command)command1);
            if (model.isNotImplement()) {
                AbstractEntityModel original = ImplementRule.findOriginalImplementModel(model);
                ccommand.add((Command)new ImplementDerivationModelsDeleteCommand(model, original));
            }
            SubsetType2SubsetRelationship relationship = (SubsetType2SubsetRelationship)model.findRelationshipFromTargetConnections(SubsetType2SubsetRelationship.class).get(0);
            SubsetTypeDeleteCommand command2 = new SubsetTypeDeleteCommand(diagram, (SubsetType)relationship.getSource());
            ccommand.add((Command)command2);
            return ccommand;
        }
    }

    private static class SubsetEntityDeleteCommand
    extends Command {
        private Diagram diagram;
        private SubsetEntity model;
        private SubsetType2SubsetRelationship subsetType2SubsetEntityRelationship;

        public SubsetEntityDeleteCommand(Diagram diagram, SubsetEntity model) {
            this.diagram = diagram;
            this.model = model;
            this.subsetType2SubsetEntityRelationship = (SubsetType2SubsetRelationship)this.model.findRelationshipFromTargetConnections(SubsetType2SubsetRelationship.class).get(0);
        }

        public boolean canExecute() {
            return this.model.isDeletable();
        }

        public void execute() {
            this.subsetType2SubsetEntityRelationship.disconnect();
            this.diagram.removeChild(this.model);
        }

        public void undo() {
            this.diagram.addChild(this.model);
            this.subsetType2SubsetEntityRelationship.connect();
        }
    }
}

