/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.markers.GroupFilterConfigurationArea;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.ScopeArea;
import org.eclipse.ui.preferences.ViewSettingsDialog;
import org.eclipse.ui.views.markers.FilterConfigurationArea;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class FiltersConfigurationDialog
extends ViewSettingsDialog {
    private static final String SELECTED_FILTER_GROUP = "SELECTED_FILTER_GROUP";
    private Collection filterGroups;
    private CheckboxTableViewer filtersList;
    private GroupFilterConfigurationArea scopeArea = new ScopeArea();
    private MarkerFieldFilterGroup selectedFilterGroup;
    private ScrolledForm form;
    private MarkerContentGenerator generator;
    private Collection filterAreas;
    private boolean andFilters = false;
    private Button removeButton;
    private Button renameButton;
    private Button cloneButton;
    private Button andButton;
    private Button orButton;
    private Label andOrLabel;

    public FiltersConfigurationDialog(Shell parentShell, MarkerContentGenerator generator) {
        super(parentShell);
        this.filterGroups = this.makeWorkingCopy(generator.getAllFilters());
        this.generator = generator;
        this.andFilters = generator.andFilters();
    }

    boolean andFilters() {
        return this.andFilters;
    }

    public boolean close() {
        this.saveDialogSettings();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(MarkerMessages.configureFiltersDialog_title);
        Composite top = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)top);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        top.setLayout((Layout)layout);
        this.createFilterSelectionArea(top);
        Label seprator = new Label(top, 514);
        seprator.setLayoutData((Object)new GridData(0, 4, false, true));
        final FormToolkit toolkit = new FormToolkit(top.getDisplay());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolkit.dispose();
            }
        });
        this.form = toolkit.createScrolledForm(top);
        this.form.setBackground(parent.getBackground());
        GridData data = new GridData(4, 4, true, true);
        this.form.setLayoutData((Object)data);
        this.form.getBody().setLayout((Layout)new GridLayout());
        this.filterAreas = this.generator.createFilterConfigurationFields();
        this.createFieldArea(toolkit, this.form, this.scopeArea, true);
        Iterator areas = this.filterAreas.iterator();
        while (areas.hasNext()) {
            this.createFieldArea(toolkit, this.form, (FilterConfigurationArea)areas.next(), true);
        }
        if (this.filterGroups.isEmpty()) {
            this.setFieldsEnabled(false);
        } else {
            this.loadDialogSettings();
        }
        FiltersConfigurationDialog.applyDialogFont((Control)top);
        return top;
    }

    private void createFieldArea(FormToolkit toolkit, ScrolledForm form, FilterConfigurationArea area, boolean expand) {
        final ExpandableComposite expandable = toolkit.createExpandableComposite(form.getBody(), 2);
        expandable.setText(area.getTitle());
        expandable.setBackground(form.getBackground());
        expandable.setLayout((Layout)new GridLayout());
        expandable.setLayoutData((Object)new GridData(4, 4, true, area.grabExcessVerticalSpace()));
        expandable.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                expandable.getParent().layout(true);
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
        Composite sectionClient = toolkit.createComposite((Composite)expandable);
        sectionClient.setLayout((Layout)new GridLayout());
        sectionClient.setLayoutData((Object)new GridData(4, 0, true, false));
        sectionClient.setBackground(form.getBackground());
        area.createContents(sectionClient);
        expandable.setClient((Control)sectionClient);
        expandable.setExpanded(expand);
    }

    private void createFilterSelectionArea(Composite top) {
        Composite filtersComposite = new Composite(top, 0);
        filtersComposite.setLayout((Layout)new GridLayout(2, false));
        filtersComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label title = new Label(filtersComposite, 0);
        title.setText(MarkerMessages.filtersDialog_entriesTitle);
        GridData titleData = new GridData();
        titleData.horizontalSpan = 2;
        title.setLayoutData((Object)titleData);
        this.filtersList = CheckboxTableViewer.newCheckList((Composite)filtersComposite, (int)2048);
        this.filtersList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return FiltersConfigurationDialog.this.filterGroups.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.filtersList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((MarkerFieldFilterGroup)element).getName();
            }
        });
        if (this.selectedFilterGroup != null) {
            this.filtersList.setSelection((ISelection)new StructuredSelection((Object)this.selectedFilterGroup));
        }
        this.filtersList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FiltersConfigurationDialog.this.setSelectedFilter((MarkerFieldFilterGroup)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        this.filtersList.setInput((Object)this);
        Iterator filterIterator = this.filterGroups.iterator();
        while (filterIterator.hasNext()) {
            MarkerFieldFilterGroup group = (MarkerFieldFilterGroup)filterIterator.next();
            this.filtersList.setChecked((Object)group, group.isEnabled());
        }
        GridData listData = new GridData(4, 4, true, true);
        listData.widthHint = this.convertHorizontalDLUsToPixels(100);
        this.filtersList.getControl().setLayoutData((Object)listData);
        Composite buttons = new Composite(filtersComposite, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonLayout);
        GridData buttonsData = new GridData();
        buttonsData.verticalAlignment = 1;
        buttons.setLayoutData((Object)buttonsData);
        Button addNew = new Button(buttons, 8);
        addNew.setText(MarkerMessages.MarkerFilter_addFilterName);
        addNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersConfigurationDialog.this.addNewFilter(false);
            }
        });
        this.setButtonLayoutData(addNew);
        this.cloneButton = new Button(buttons, 8);
        this.cloneButton.setText(MarkerMessages.MarkerFilter_cloneFilterName);
        this.cloneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersConfigurationDialog.this.addNewFilter(true);
            }
        });
        this.setButtonLayoutData(this.cloneButton);
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(MarkerMessages.MarkerFilter_deleteSelectedName);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersConfigurationDialog.this.removeFilters(FiltersConfigurationDialog.this.filtersList.getSelection());
            }
        });
        this.setButtonLayoutData(this.removeButton);
        this.renameButton = new Button(buttons, 8);
        this.renameButton.setText(MarkerMessages.MarkerFilter_renameName);
        this.renameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarkerFieldFilterGroup filterGroup = (MarkerFieldFilterGroup)((IStructuredSelection)FiltersConfigurationDialog.this.filtersList.getSelection()).getFirstElement();
                FiltersConfigurationDialog.this.renameFilter(filterGroup);
            }
        });
        this.setButtonLayoutData(this.renameButton);
        this.andOrLabel = new Label(filtersComposite, 0);
        GridData labelData = new GridData();
        labelData.horizontalSpan = 2;
        this.andOrLabel.setLayoutData((Object)labelData);
        this.andOrLabel.setText(MarkerMessages.AND_OR_Label);
        this.andButton = new Button(filtersComposite, 16);
        GridData data = new GridData(768, 0, true, false);
        data.horizontalSpan = 2;
        data.horizontalIndent = 21;
        this.andButton.setLayoutData((Object)data);
        this.andButton.setText(MarkerMessages.AND_Title);
        this.andButton.setSelection(this.andFilters);
        this.andButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersConfigurationDialog.this.andFilters = true;
            }
        });
        this.orButton = new Button(filtersComposite, 16);
        data = new GridData(768, 0, true, false);
        data.horizontalSpan = 2;
        data.horizontalIndent = 21;
        this.orButton.setLayoutData((Object)data);
        this.orButton.setText(MarkerMessages.OR_Title);
        this.orButton.setSelection(!this.andFilters);
        this.orButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersConfigurationDialog.this.andFilters = false;
            }
        });
        this.filtersList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FiltersConfigurationDialog.this.updateAndOrEnblement();
            }
        });
    }

    private void addNewFilter(boolean cloneSelected) {
        String newName = this.getNewFilterName(this.getCurrentFilterNames(), null);
        if (newName != null) {
            this.createNewFilter(newName, cloneSelected);
        }
    }

    private String getNewFilterName(Collection avoidNames, String initialName) {
        InputDialog newDialog = new InputDialog(this.getShell(), MarkerMessages.MarkerFilterDialog_title, MarkerMessages.MarkerFilterDialog_message, initialName != null ? initialName : MarkerMessages.MarkerFilter_newFilterName, this.getNameValidator(avoidNames));
        if (newDialog.open() == 0) {
            return newDialog.getValue();
        }
        return null;
    }

    private IInputValidator getNameValidator(final Collection avoidNames) {
        return new IInputValidator(){

            public String isValid(String value) {
                String newText = value.trim();
                if (newText.length() == 0) {
                    return MarkerMessages.MarkerFilterDialog_emptyMessage;
                }
                if (avoidNames.contains(newText)) {
                    return NLS.bind((String)MarkerMessages.filtersDialog_conflictingName, (Object)newText);
                }
                return null;
            }
        };
    }

    private Collection getCurrentFilterNames() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator filterIterator = this.filterGroups.iterator();
        while (filterIterator.hasNext()) {
            names.add(((MarkerFieldFilterGroup)filterIterator.next()).getName());
        }
        return names;
    }

    private void createNewFilter(String newName, boolean cloneSelected) {
        MarkerFieldFilterGroup group = new MarkerFieldFilterGroup(null, this.generator);
        if (cloneSelected && this.selectedFilterGroup != null) {
            this.captureStateInto(group);
        }
        group.setName(newName);
        this.filterGroups.add(group);
        this.filtersList.refresh();
        this.filtersList.setSelection((ISelection)new StructuredSelection((Object)group));
        this.filtersList.setChecked((Object)group, true);
        this.updateAndOrEnblement();
    }

    private void renameFilter(MarkerFieldFilterGroup filterGroup) {
        if (filterGroup != null) {
            Collection names = this.getCurrentFilterNames();
            String initial = null;
            initial = filterGroup.getName();
            names.remove(initial);
            String newName = this.getNewFilterName(names, initial);
            if (newName != null) {
                filterGroup.setName(newName);
                this.filtersList.update((Object)filterGroup, null);
            }
        }
    }

    private void updateAndOrEnblement() {
        if (this.filtersList.getCheckedElements().length == 0) {
            this.andOrLabel.setEnabled(false);
            this.andButton.setEnabled(false);
            this.orButton.setEnabled(false);
        } else {
            this.andOrLabel.setEnabled(true);
            this.andButton.setEnabled(true);
            this.orButton.setEnabled(true);
        }
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().getSection(((Object)((Object)this)).getClass().getName());
        if (settings == null) {
            settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return settings;
    }

    Collection getFilters() {
        return this.filterGroups;
    }

    protected boolean isResizable() {
        return true;
    }

    private void loadDialogSettings() {
        IDialogSettings settings = this.getDialogSettings();
        String selection = settings.get(SELECTED_FILTER_GROUP);
        if (selection != null) {
            Iterator groups = this.filterGroups.iterator();
            while (groups.hasNext()) {
                MarkerFieldFilterGroup group = (MarkerFieldFilterGroup)groups.next();
                if (!group.getName().equals(selection)) continue;
                this.filtersList.setSelection((ISelection)new StructuredSelection((Object)group));
                return;
            }
        }
        this.filtersList.setSelection((ISelection)new StructuredSelection(this.filterGroups.iterator().next()));
    }

    private Collection makeWorkingCopy(Collection groups) {
        Iterator initialFiltersIterator = groups.iterator();
        ArrayList<MarkerFieldFilterGroup> returnFilters = new ArrayList<MarkerFieldFilterGroup>(groups.size());
        while (initialFiltersIterator.hasNext()) {
            MarkerFieldFilterGroup group = (MarkerFieldFilterGroup)initialFiltersIterator.next();
            MarkerFieldFilterGroup copy = group.makeWorkingCopy();
            if (copy == null) continue;
            returnFilters.add(copy);
        }
        return returnFilters;
    }

    protected void okPressed() {
        if (!this.shouldContinue()) {
            return;
        }
        Iterator filterGroupIterator = this.filterGroups.iterator();
        while (filterGroupIterator.hasNext()) {
            MarkerFieldFilterGroup group = (MarkerFieldFilterGroup)filterGroupIterator.next();
            group.setEnabled(this.filtersList.getChecked((Object)group));
        }
        this.captureStateInto(this.selectedFilterGroup);
        super.okPressed();
    }

    private void captureStateInto(MarkerFieldFilterGroup filterGroup) {
        if (filterGroup != null) {
            this.scopeArea.applyToGroup(filterGroup);
            Iterator areas = this.filterAreas.iterator();
            while (areas.hasNext()) {
                FilterConfigurationArea area = (FilterConfigurationArea)areas.next();
                if (area instanceof GroupFilterConfigurationArea) {
                    ((GroupFilterConfigurationArea)area).applyToGroup(filterGroup);
                }
                area.apply(filterGroup.getFilter(area.getField()));
            }
        }
    }

    protected void performDefaults() {
        this.filterGroups.clear();
        this.filterGroups.addAll(this.generator.getDeclaredFilters());
        this.filtersList.refresh();
        this.filtersList.setSelection((ISelection)new StructuredSelection(this.filterGroups.size() > 1 ? this.filterGroups.iterator().next() : new Object[]{}));
        this.andFilters = false;
        this.andButton.setSelection(this.andFilters);
        this.orButton.setSelection(!this.andFilters);
    }

    private boolean shouldContinue() {
        if (this.filtersList.getCheckedElements().length == 0) {
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)MarkerMessages.filtersDialogDeselectedFiltersTitle, (String)MarkerMessages.filtersDialogDeselectedFiltersMessage);
        }
        return true;
    }

    private void removeFilters(ISelection selection) {
        this.filterGroups.remove(((IStructuredSelection)selection).getFirstElement());
        this.filtersList.refresh();
        this.updateAndOrEnblement();
    }

    private void saveDialogSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (this.selectedFilterGroup != null) {
            settings.put(SELECTED_FILTER_GROUP, this.selectedFilterGroup.getName());
        }
    }

    private void setEnabled(boolean visible, Control control) {
        control.setEnabled(visible);
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                this.setEnabled(visible, children[i]);
                ++i;
            }
        }
    }

    private void setFieldsEnabled(boolean visible) {
        this.setEnabled(visible, (Control)this.form);
    }

    private void setSelectedFilter(MarkerFieldFilterGroup markerFieldFilterGroup) {
        if (this.selectedFilterGroup == markerFieldFilterGroup) {
            return;
        }
        this.removeButton.setEnabled(markerFieldFilterGroup != null && !markerFieldFilterGroup.isSystem());
        this.renameButton.setEnabled(markerFieldFilterGroup != null && !markerFieldFilterGroup.isSystem());
        this.cloneButton.setEnabled(markerFieldFilterGroup != null);
        MarkerFieldFilterGroup old = this.selectedFilterGroup;
        this.selectedFilterGroup = markerFieldFilterGroup;
        if (old != null) {
            this.scopeArea.applyToGroup(old);
        }
        if (this.selectedFilterGroup == null) {
            this.setFieldsEnabled(false);
            return;
        }
        this.setFieldsEnabled(true);
        this.scopeArea.initializeFromGroup(this.selectedFilterGroup);
        Iterator areas = this.filterAreas.iterator();
        while (areas.hasNext()) {
            FilterConfigurationArea area = (FilterConfigurationArea)areas.next();
            if (old != null) {
                if (area instanceof GroupFilterConfigurationArea) {
                    ((GroupFilterConfigurationArea)area).applyToGroup(old);
                }
                area.apply(old.getFilter(area.getField()));
            }
            if (area instanceof GroupFilterConfigurationArea) {
                ((GroupFilterConfigurationArea)area).initializeFromGroup(this.selectedFilterGroup);
            }
            area.initialize(this.selectedFilterGroup.getFilter(area.getField()));
        }
    }
}

