/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.core;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.start.ECFStartJob;
import org.eclipse.ecf.core.start.IECFStart;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.PlatformHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.core.IDisposable;
import org.eclipse.ecf.internal.core.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class ECFPlugin
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf";
    private static final String ECFNAMESPACE = "org.eclipse.ecf";
    private static final String CONTAINER_FACTORY_NAME = "containerFactory";
    private static final String CONTAINER_FACTORY_EPOINT = "org.eclipse.ecf.containerFactory";
    private static final String STARTUP_NAME = "start";
    public static final String START_EPOINT = "org.eclipse.ecf.start";
    public static final String PLUGIN_RESOURCE_BUNDLE = "org.eclipse.ecf.ECFPluginResources";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String SERVER_ATTRIBUTE = "server";
    public static final String HIDDEN_ATTRIBUTE = "hidden";
    public static final String ASYNCH_ATTRIBUTE = "asynchronous";
    public static final String CONTAINER_NAME = "container";
    public static final String CONTAINER_EPOINT = "org.eclipse.ecf.container";
    public static final String FACTORY_ATTRIBUTE = "factoryName";
    public static final String ID_ATTRIBUTE = "containerId";
    public static final String PARAMETER_ELEMENT = "parameter";
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_VALUE = "value";
    private static ECFPlugin plugin;
    private BundleContext context = null;
    private ServiceTracker extensionRegistryTracker = null;
    private Map disposables = new WeakHashMap();
    private IRegistryChangeListener registryManager = null;
    private ServiceRegistration containerFactoryServiceRegistration;
    private ServiceRegistration containerManagerServiceRegistration;
    private ServiceTracker logServiceTracker = null;
    private LogService logService = null;
    private ServiceTracker adapterManagerTracker = null;
    private BundleActivator ecfTrustManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public static synchronized ECFPlugin getDefault() {
        if (plugin == null) {
            plugin = new ECFPlugin();
        }
        return plugin;
    }

    public void start(BundleContext ctxt) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        plugin = this;
        this.context = ctxt;
        try {
            Class<?> ecfSocketFactoryClass = Class.forName("org.eclipse.ecf.internal.ssl.ECFTrustManager");
            this.ecfTrustManager = (BundleActivator)ecfSocketFactoryClass.newInstance();
            this.ecfTrustManager.start(ctxt);
        }
        catch (ClassNotFoundException ecfSocketFactoryClass) {
        }
        catch (Throwable t) {
            this.log((IStatus)new Status(4, ECFPlugin.getDefault().getBundle().getSymbolicName(), "Unexpected Error in ECFPlugin.start", t));
        }
        if ((clazz2 = class$0) == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.extensionRegistryTracker = new ServiceTracker(ctxt, clazz2.getName(), null);
        this.extensionRegistryTracker.open();
        IExtensionRegistry registry = this.getExtensionRegistry();
        if (registry != null) {
            this.registryManager = new ECFRegistryManager();
            registry.addRegistryChangeListener(this.registryManager);
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.core.IContainerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.containerFactoryServiceRegistration = ctxt.registerService(clazz.getName(), (Object)ContainerFactory.getDefault(), null);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.ecf.core.IContainerManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.containerManagerServiceRegistration = ctxt.registerService(clazz3.getName(), (Object)ContainerFactory.getDefault(), null);
        this.setupContainerFactoryExtensionPoint(ctxt);
        this.setupContainerExtensionPoint(ctxt);
        this.setupStartExtensionPoint(ctxt);
    }

    public void stop(BundleContext ctxt) throws Exception {
        this.fireDisposables();
        this.disposables = null;
        IExtensionRegistry reg = this.getExtensionRegistry();
        if (reg != null) {
            reg.removeRegistryChangeListener(this.registryManager);
        }
        this.registryManager = null;
        if (this.ecfTrustManager != null) {
            this.ecfTrustManager.stop(ctxt);
            this.ecfTrustManager = null;
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
            this.logService = null;
        }
        if (this.extensionRegistryTracker != null) {
            this.extensionRegistryTracker.close();
            this.extensionRegistryTracker = null;
        }
        if (this.containerFactoryServiceRegistration != null) {
            this.containerFactoryServiceRegistration.unregister();
            this.containerFactoryServiceRegistration = null;
        }
        if (this.containerManagerServiceRegistration != null) {
            this.containerManagerServiceRegistration.unregister();
            this.containerManagerServiceRegistration = null;
        }
        if (this.adapterManagerTracker != null) {
            this.adapterManagerTracker.close();
            this.adapterManagerTracker = null;
        }
        this.context = null;
    }

    public void addDisposable(IDisposable disposable) {
        this.disposables.put(disposable, null);
    }

    public void removeDisposable(IDisposable disposable) {
        this.disposables.remove(disposable);
    }

    protected void fireDisposables() {
        Iterator i = this.disposables.keySet().iterator();
        while (i.hasNext()) {
            IDisposable d = (IDisposable)i.next();
            if (d == null) continue;
            d.dispose();
        }
    }

    public Bundle getBundle() {
        if (this.context == null) {
            return null;
        }
        return this.context.getBundle();
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.logServiceTracker.open();
        }
        this.logService = (LogService)this.logServiceTracker.getService();
        if (this.logService == null) {
            this.logService = new SystemLogService("org.eclipse.ecf");
        }
        return this.logService;
    }

    public void log(IStatus status) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    protected void logException(IStatus status, String method, Throwable exception) {
        this.log(status);
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.ecf.internal.core.ECFPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.catching((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/exceptions/catching", (Class)clazz, (String)method, (Throwable)exception);
    }

    protected void removeContainerFactoryExtensions(IConfigurationElement[] members) {
        String method = "removeContainerFactoryExtensions";
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.ecf.internal.core.ECFPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.entering((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/methods/entering", (Class)clazz, (String)"removeContainerFactoryExtensions", (Object[])members);
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            IExtension extension = member.getDeclaringExtension();
            String name = null;
            try {
                IContainerFactory factory;
                ContainerTypeDescription cd;
                name = member.getAttribute("name");
                if (name == null) {
                    name = member.getAttribute(CLASS_ATTRIBUTE);
                }
                if ((cd = (factory = ContainerFactory.getDefault()).getDescriptionByName(name)) != null && factory.containsDescription(cd)) {
                    factory.removeDescription(cd);
                    Trace.trace((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug", (String)("removeContainerFactoryExtensions.removed " + cd + " from factory"));
                }
            }
            catch (Exception e) {
                this.logException((IStatus)new Status(4, ECFPlugin.getDefault().getBundle().getSymbolicName(), 4, NLS.bind((String)Messages.ECFPlugin_Container_Name_Collision_Prefix, (Object)name, (Object)extension.getExtensionPointUniqueIdentifier()), null), "removeContainerFactoryExtensions", e);
            }
            ++m;
        }
    }

    void removeContainerExtensions(IConfigurationElement[] members) {
        String method = "removeContainerExtensions";
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.ecf.internal.core.ECFPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.entering((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/methods/entering", (Class)clazz, (String)"removeContainerExtensions", (Object[])members);
        int m = 0;
        while (m < members.length) {
            IContainerManager manager;
            IContainer[] containers;
            IConfigurationElement member = members[m];
            String factoryName = member.getAttribute(FACTORY_ATTRIBUTE);
            if (factoryName != null && !"".equals(factoryName) && (containers = (manager = (IContainerManager)((Object)ContainerFactory.getDefault())).getAllContainers()) != null) {
                int i = 0;
                while (i < containers.length) {
                    IContainer removedContainer;
                    ContainerTypeDescription containerTypeDescription = manager.getContainerTypeDescription(containers[i].getID());
                    if (containerTypeDescription != null && containerTypeDescription.getName().equals(factoryName) && (removedContainer = manager.removeContainer(containers[i])) != null) {
                        try {
                            containers[i].dispose();
                        }
                        catch (Exception e) {
                            this.logException((IStatus)new Status(4, "org.eclipse.ecf", 4, "Unexpected exception disposing container with factoryName=" + factoryName + " and id=" + containers[i].getID(), null), "removeContainerExtensions", e);
                        }
                    }
                    ++i;
                }
            }
            ++m;
        }
    }

    protected void addContainerFactoryExtensions(IConfigurationElement[] members) {
        String method = "addContainerFactoryExtensions";
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.ecf.internal.core.ECFPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.entering((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/methods/entering", (Class)clazz, (String)"addContainerFactoryExtensions", (Object[])members);
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            IExtension extension = member.getDeclaringExtension();
            Object exten = null;
            String name = null;
            try {
                String s;
                String description;
                exten = member.createExecutableExtension(CLASS_ATTRIBUTE);
                String clazz2 = exten.getClass().getName();
                name = member.getAttribute("name");
                if (name == null) {
                    name = clazz2;
                }
                if ((description = member.getAttribute(DESCRIPTION_ATTRIBUTE)) == null) {
                    description = "";
                }
                boolean server = (s = member.getAttribute(SERVER_ATTRIBUTE)) == null ? false : Boolean.valueOf(s);
                s = member.getAttribute(HIDDEN_ATTRIBUTE);
                boolean hidden = s == null ? false : Boolean.valueOf(s);
                ContainerTypeDescription scd = new ContainerTypeDescription(name, (IContainerInstantiator)exten, description, server, hidden);
                IContainerFactory factory = ContainerFactory.getDefault();
                if (factory.containsDescription(scd)) {
                    throw new CoreException((IStatus)new Status(4, ECFPlugin.getDefault().getBundle().getSymbolicName(), 4, NLS.bind((String)Messages.ECFPlugin_Container_Name_Collision_Prefix, (Object)name, (Object)extension.getExtensionPointUniqueIdentifier()), null));
                }
                factory.addDescription(scd);
                Trace.trace((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug", (String)("addContainerFactoryExtensions.added " + scd + " to factory " + factory));
            }
            catch (CoreException e) {
                this.logException(e.getStatus(), "addContainerFactoryExtensions", e);
            }
            catch (Exception e) {
                this.logException((IStatus)new Status(4, ECFPlugin.getDefault().getBundle().getSymbolicName(), 4, NLS.bind((String)Messages.ECFPlugin_Container_Name_Collision_Prefix, (Object)name, (Object)extension.getExtensionPointUniqueIdentifier()), null), "addContainerFactoryExtensions", e);
            }
            ++m;
        }
    }

    void addContainerExtensions(IConfigurationElement[] members) {
        String method = "addContainerExtensions";
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.ecf.internal.core.ECFPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.entering((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/methods/entering", (Class)clazz, (String)"addContainerExtensions", (Object[])members);
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            String factory = null;
            String id = null;
            try {
                factory = member.getAttribute(FACTORY_ATTRIBUTE);
                if (factory != null && !"".equals(factory)) {
                    id = member.getAttribute(ID_ATTRIBUTE);
                    id = id == null || "".equals(id) ? null : id;
                    Map parameters = this.getParametersForContainer(member);
                    ContainerFactory.getDefault().createContainer(factory, id, parameters);
                    Trace.trace((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug", (String)("addContainerExtensions.added container with factoryName=" + factory + " and id=" + id));
                }
            }
            catch (CoreException e) {
                this.logException(e.getStatus(), "addContainerExtensions", e);
            }
            catch (Exception e) {
                this.logException((IStatus)new Status(4, "org.eclipse.ecf", 4, "Unexpected exception creating container with factoryName=" + factory + " and id=" + id, null), "addContainerExtensions", e);
            }
            ++m;
        }
    }

    Map getParametersForContainer(IConfigurationElement member) {
        IConfigurationElement[] elements = member.getChildren(PARAMETER_ELEMENT);
        if (elements == null) {
            return null;
        }
        Properties results = null;
        int i = 0;
        while (i < elements.length) {
            String name = elements[i].getAttribute("name");
            String value = elements[i].getAttribute("value");
            if (name != null && !"".equals(name) && value != null && !"".equals(value)) {
                if (results == null) {
                    results = new Properties();
                }
                results.put(name, value);
            }
            ++i;
        }
        return results;
    }

    protected void setupContainerFactoryExtensionPoint(BundleContext bc) {
        IExtensionRegistry reg = this.getExtensionRegistry();
        if (reg != null) {
            IExtensionPoint extensionPoint = reg.getExtensionPoint(CONTAINER_FACTORY_EPOINT);
            if (extensionPoint == null) {
                return;
            }
            this.addContainerFactoryExtensions(extensionPoint.getConfigurationElements());
        }
    }

    protected void setupContainerExtensionPoint(BundleContext bc) {
        IExtensionRegistry reg = this.getExtensionRegistry();
        if (reg != null) {
            IExtensionPoint extensionPoint = reg.getExtensionPoint(CONTAINER_EPOINT);
            if (extensionPoint == null) {
                return;
            }
            this.addContainerExtensions(extensionPoint.getConfigurationElements());
        }
    }

    public IExtensionRegistry getExtensionRegistry() {
        return (IExtensionRegistry)this.extensionRegistryTracker.getService();
    }

    protected void setupStartExtensionPoint(BundleContext bc) {
        IExtensionRegistry reg = this.getExtensionRegistry();
        if (reg != null) {
            IExtensionPoint extensionPoint = reg.getExtensionPoint(START_EPOINT);
            if (extensionPoint == null) {
                return;
            }
            this.runStartExtensions(extensionPoint.getConfigurationElements());
        }
    }

    protected void runStartExtensions(IConfigurationElement[] configurationElements) {
        String method = "runStartExtensions";
        int m = 0;
        while (m < configurationElements.length) {
            IConfigurationElement member = configurationElements[m];
            try {
                boolean sync = member.getAttribute(ASYNCH_ATTRIBUTE) == null;
                IECFStart clazz = (IECFStart)member.createExecutableExtension(CLASS_ATTRIBUTE);
                this.startExtension(clazz.getClass().getName(), clazz, sync);
            }
            catch (CoreException e) {
                this.logException(e.getStatus(), "runStartExtensions", e);
            }
            catch (Exception e) {
                this.logException((IStatus)new Status(4, ECFPlugin.getDefault().getBundle().getSymbolicName(), 4, "Unknown start exception", (Throwable)e), "runStartExtensions", e);
            }
            ++m;
        }
    }

    private void startExtension(String name, IECFStart exten, boolean synchronous) {
        if (synchronous) {
            IStatus result = null;
            try {
                result = exten.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Throwable e) {
                String message = "startup extension error";
                this.logException((IStatus)new Status(4, "org.eclipse.ecf", 4, "startup extension error", e), "startup extension error", e);
            }
            if (result != null && !result.isOK()) {
                this.logException(result, result.getMessage(), result.getException());
            }
        } else {
            ECFStartJob job = new ECFStartJob(name, exten);
            job.schedule();
        }
    }

    public IAdapterManager getAdapterManager() {
        IAdapterManager adapterManager;
        if (this.adapterManagerTracker == null) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.eclipse.core.runtime.IAdapterManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.adapterManagerTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.adapterManagerTracker.open();
        }
        if ((adapterManager = (IAdapterManager)this.adapterManagerTracker.getService()) == null) {
            adapterManager = PlatformHelper.getPlatformAdapterManager();
        }
        if (adapterManager == null) {
            ECFPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf", 4, "Cannot get adapter manager", null));
        }
        return adapterManager;
    }

    protected class ECFRegistryManager
    implements IRegistryChangeListener {
        protected ECFRegistryManager() {
        }

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] factoryDeltas = event.getExtensionDeltas("org.eclipse.ecf", ECFPlugin.CONTAINER_FACTORY_NAME);
            int i = 0;
            while (i < factoryDeltas.length) {
                switch (factoryDeltas[i].getKind()) {
                    case 1: {
                        ECFPlugin.this.addContainerFactoryExtensions(factoryDeltas[i].getExtension().getConfigurationElements());
                        break;
                    }
                    case 2: {
                        ECFPlugin.this.removeContainerFactoryExtensions(factoryDeltas[i].getExtension().getConfigurationElements());
                    }
                }
                ++i;
            }
            IExtensionDelta[] containerDeltas = event.getExtensionDeltas("org.eclipse.ecf", ECFPlugin.CONTAINER_NAME);
            int i2 = 0;
            while (i2 < containerDeltas.length) {
                switch (containerDeltas[i2].getKind()) {
                    case 1: {
                        ECFPlugin.this.addContainerExtensions(containerDeltas[i2].getExtension().getConfigurationElements());
                        break;
                    }
                    case 2: {
                        ECFPlugin.this.removeContainerExtensions(containerDeltas[i2].getExtension().getConfigurationElements());
                    }
                }
                ++i2;
            }
        }
    }
}

