/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;

public class SWTGraphics
extends Graphics {
    static final int AA_MASK;
    static final int AA_SHIFT;
    static final int AA_WHOLE_NUMBER = 1;
    static final int ADVANCED_GRAPHICS_MASK;
    static final int ADVANCED_HINTS_DEFAULTS;
    static final int ADVANCED_HINTS_MASK;
    static final int ADVANCED_SHIFT;
    static final int FILL_RULE_MASK;
    static final int FILL_RULE_SHIFT;
    static final int FILL_RULE_WHOLE_NUMBER = -1;
    static final int INTERPOLATION_MASK;
    static final int INTERPOLATION_SHIFT;
    static final int INTERPOLATION_WHOLE_NUMBER = 1;
    static final int TEXT_AA_MASK;
    static final int TEXT_AA_SHIFT;
    static final int XOR_MASK;
    static final int XOR_SHIFT;
    private final LazyState appliedState = new LazyState();
    private final State currentState = new State();
    private boolean elementsNeedUpdate;
    private GC gc;
    private boolean sharedClipping;
    private List stack = new ArrayList();
    private int stackPointer = 0;
    Transform transform;
    private int translateX = 0;
    private int translateY = 0;

    static {
        XOR_SHIFT = 3;
        AA_SHIFT = 8;
        TEXT_AA_SHIFT = 10;
        INTERPOLATION_SHIFT = 12;
        FILL_RULE_SHIFT = 14;
        ADVANCED_SHIFT = 15;
        AA_MASK = 3 << AA_SHIFT;
        FILL_RULE_MASK = 1 << FILL_RULE_SHIFT;
        INTERPOLATION_MASK = 3 << INTERPOLATION_SHIFT;
        TEXT_AA_MASK = 3 << TEXT_AA_SHIFT;
        XOR_MASK = 1 << XOR_SHIFT;
        ADVANCED_GRAPHICS_MASK = 1 << ADVANCED_SHIFT;
        ADVANCED_HINTS_MASK = TEXT_AA_MASK | AA_MASK | INTERPOLATION_MASK;
        ADVANCED_HINTS_DEFAULTS = 0 << TEXT_AA_SHIFT | 0 << AA_SHIFT | 0 << INTERPOLATION_SHIFT;
    }

    public SWTGraphics(GC gc) {
        this.gc = gc;
        this.init();
    }

    protected final void checkFill() {
        if (!this.currentState.bgColor.equals((Object)this.appliedState.bgColor) && this.currentState.bgPattern == null) {
            this.appliedState.bgColor = this.currentState.bgColor;
            this.gc.setBackground(this.appliedState.bgColor);
        }
        this.checkGC();
    }

    protected final void checkGC() {
        if (this.appliedState.relativeClip != this.currentState.relativeClip) {
            this.appliedState.relativeClip = this.currentState.relativeClip;
            this.currentState.relativeClip.setOn(this.gc, this.translateX, this.translateY);
        }
        if (this.appliedState.graphicHints != this.currentState.graphicHints) {
            SWTGraphics.reconcileHints(this.gc, this.appliedState.graphicHints, this.currentState.graphicHints);
            this.appliedState.graphicHints = this.currentState.graphicHints;
        }
    }

    protected final void checkPaint() {
        LineAttributes lineAttributes;
        this.checkGC();
        if (!this.currentState.fgColor.equals((Object)this.appliedState.fgColor) && this.currentState.fgPattern == null) {
            this.appliedState.fgColor = this.currentState.fgColor;
            this.gc.setForeground(this.appliedState.fgColor);
        }
        if (!this.appliedState.lineAttributes.equals(lineAttributes = this.currentState.lineAttributes)) {
            if (this.getAdvanced()) {
                this.gc.setLineAttributes(lineAttributes);
            } else {
                this.gc.setLineWidth((int)lineAttributes.width);
                this.gc.setLineCap(lineAttributes.cap);
                this.gc.setLineJoin(lineAttributes.join);
                this.gc.setLineStyle(lineAttributes.style);
                if (lineAttributes.dash != null) {
                    this.gc.setLineDash(SWTGraphics.convertFloatArrayToInt(lineAttributes.dash));
                }
            }
            this.appliedState.lineAttributes = SWTGraphics.clone(lineAttributes);
        }
        if (!this.currentState.bgColor.equals((Object)this.appliedState.bgColor) && this.currentState.bgPattern == null) {
            this.appliedState.bgColor = this.currentState.bgColor;
            this.gc.setBackground(this.appliedState.bgColor);
        }
    }

    private void checkSharedClipping() {
        if (this.sharedClipping) {
            this.sharedClipping = false;
            boolean previouslyApplied = this.appliedState == this.currentState.relativeClip;
            this.currentState.relativeClip = this.currentState.relativeClip.getCopy();
            if (previouslyApplied) {
                this.appliedState.relativeClip = this.currentState.relativeClip;
            }
        }
    }

    protected final void checkText() {
        this.checkPaint();
        if (!this.appliedState.font.equals((Object)this.currentState.font)) {
            this.appliedState.font = this.currentState.font;
            this.gc.setFont(this.appliedState.font);
        }
    }

    public void clipRect(Rectangle rect) {
        if (this.currentState.relativeClip == null) {
            throw new IllegalStateException("The current clipping area does not support intersection.");
        }
        this.checkSharedClipping();
        this.currentState.relativeClip.intersect(rect.x, rect.y, rect.right(), rect.bottom());
        this.appliedState.relativeClip = null;
    }

    public void dispose() {
        while (this.stackPointer > 0) {
            this.popState();
        }
        if (this.transform != null) {
            this.transform.dispose();
        }
    }

    public void drawArc(int x, int y, int width, int height, int offset, int length) {
        this.checkPaint();
        this.gc.drawArc(x + this.translateX, y + this.translateY, width, height, offset, length);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.checkPaint();
        this.gc.drawFocus(x + this.translateX, y + this.translateY, w + 1, h + 1);
    }

    public void drawImage(Image srcImage, int x, int y) {
        this.checkGC();
        this.gc.drawImage(srcImage, x + this.translateX, y + this.translateY);
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        this.checkGC();
        this.gc.drawImage(srcImage, x1, y1, w1, h1, x2 + this.translateX, y2 + this.translateY, w2, h2);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.checkPaint();
        this.gc.drawLine(x1 + this.translateX, y1 + this.translateY, x2 + this.translateX, y2 + this.translateY);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.checkPaint();
        this.gc.drawOval(x + this.translateX, y + this.translateY, width, height);
    }

    public void drawPath(Path path) {
        this.checkPaint();
        this.initTransform(false);
        this.gc.drawPath(path);
    }

    public void drawPoint(int x, int y) {
        this.checkPaint();
        this.gc.drawPoint(x + this.translateX, y + this.translateY);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawPolygon(int[] points) {
        this.checkPaint();
        try {
            this.translatePointArray(points, this.translateX, this.translateY);
            this.gc.drawPolygon(points);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            return;
        }
    }

    public void drawPolygon(PointList points) {
        this.drawPolygon(points.toIntArray());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawPolyline(int[] points) {
        this.checkPaint();
        try {
            this.translatePointArray(points, this.translateX, this.translateY);
            this.gc.drawPolyline(points);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            return;
        }
    }

    public void drawPolyline(PointList points) {
        this.drawPolyline(points.toIntArray());
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.checkPaint();
        this.gc.drawRectangle(x + this.translateX, y + this.translateY, width, height);
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.checkPaint();
        this.gc.drawRoundRectangle(r.x + this.translateX, r.y + this.translateY, r.width, r.height, arcWidth, arcHeight);
    }

    public void drawString(String s, int x, int y) {
        this.checkText();
        this.gc.drawString(s, x + this.translateX, y + this.translateY, true);
    }

    public void drawText(String s, int x, int y) {
        this.checkText();
        this.gc.drawText(s, x + this.translateX, y + this.translateY, true);
    }

    public void drawTextLayout(TextLayout layout, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.checkText();
        layout.draw(this.gc, x + this.translateX, y + this.translateY, selectionStart, selectionEnd, selectionForeground, selectionBackground);
    }

    public void fillArc(int x, int y, int width, int height, int offset, int length) {
        this.checkFill();
        this.gc.fillArc(x + this.translateX, y + this.translateY, width, height, offset, length);
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        this.checkPaint();
        this.gc.fillGradientRectangle(x + this.translateX, y + this.translateY, w, h, vertical);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.checkFill();
        this.gc.fillOval(x + this.translateX, y + this.translateY, width, height);
    }

    public void fillPath(Path path) {
        this.checkFill();
        this.initTransform(false);
        this.gc.fillPath(path);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fillPolygon(int[] points) {
        this.checkFill();
        try {
            this.translatePointArray(points, this.translateX, this.translateY);
            this.gc.fillPolygon(points);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            return;
        }
    }

    public void fillPolygon(PointList points) {
        this.fillPolygon(points.toIntArray());
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.checkFill();
        this.gc.fillRectangle(x + this.translateX, y + this.translateY, width, height);
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.checkFill();
        this.gc.fillRoundRectangle(r.x + this.translateX, r.y + this.translateY, r.width, r.height, arcWidth, arcHeight);
    }

    public void fillString(String s, int x, int y) {
        this.checkText();
        this.gc.drawString(s, x + this.translateX, y + this.translateY, false);
    }

    public void fillText(String s, int x, int y) {
        this.checkText();
        this.gc.drawText(s, x + this.translateX, y + this.translateY, false);
    }

    public int getAlpha() {
        return this.currentState.alpha;
    }

    public int getAntialias() {
        return ((this.currentState.graphicHints & AA_MASK) >> AA_SHIFT) - 1;
    }

    public boolean getAdvanced() {
        return (this.currentState.graphicHints & ADVANCED_GRAPHICS_MASK) != 0;
    }

    public Color getBackgroundColor() {
        return this.currentState.bgColor;
    }

    public Rectangle getClip(Rectangle rect) {
        if (this.currentState.relativeClip != null) {
            this.currentState.relativeClip.getBoundingBox(rect);
            return rect;
        }
        throw new IllegalStateException("Clipping can no longer be queried due to transformations");
    }

    public int getFillRule() {
        return ((this.currentState.graphicHints & FILL_RULE_MASK) >> FILL_RULE_SHIFT) - -1;
    }

    public Font getFont() {
        return this.currentState.font;
    }

    public FontMetrics getFontMetrics() {
        this.checkText();
        return this.gc.getFontMetrics();
    }

    public Color getForegroundColor() {
        return this.currentState.fgColor;
    }

    public int getInterpolation() {
        return ((this.currentState.graphicHints & INTERPOLATION_MASK) >> INTERPOLATION_SHIFT) - 1;
    }

    public void getLineAttributes(LineAttributes lineAttributes) {
        SWTGraphics.copyLineAttributes(lineAttributes, this.currentState.lineAttributes);
    }

    public int getLineCap() {
        return this.currentState.lineAttributes.cap;
    }

    public int getLineJoin() {
        return this.currentState.lineAttributes.join;
    }

    public int getLineStyle() {
        return this.currentState.lineAttributes.style;
    }

    public int getLineWidth() {
        return (int)this.currentState.lineAttributes.width;
    }

    public float getLineWidthFloat() {
        return this.currentState.lineAttributes.width;
    }

    public float getLineMiterLimit() {
        return this.currentState.lineAttributes.miterLimit;
    }

    public float[] getLineDash() {
        return (float[])this.currentState.lineAttributes.dash.clone();
    }

    public float getLineDashOffset() {
        return this.currentState.lineAttributes.dashOffset;
    }

    public int getTextAntialias() {
        return ((this.currentState.graphicHints & TEXT_AA_MASK) >> TEXT_AA_SHIFT) - 1;
    }

    public boolean getXORMode() {
        return (this.currentState.graphicHints & XOR_MASK) != 0;
    }

    protected void init() {
        this.currentState.bgColor = this.appliedState.bgColor = this.gc.getBackground();
        this.currentState.fgColor = this.appliedState.fgColor = this.gc.getForeground();
        this.currentState.font = this.appliedState.font = this.gc.getFont();
        this.currentState.lineAttributes = this.gc.getLineAttributes();
        this.appliedState.lineAttributes = SWTGraphics.clone(this.currentState.lineAttributes);
        this.currentState.graphicHints |= this.gc.getLineStyle();
        this.currentState.graphicHints = this.currentState.graphicHints | (this.gc.getAdvanced() ? ADVANCED_GRAPHICS_MASK : 0);
        this.appliedState.graphicHints = this.currentState.graphicHints = this.currentState.graphicHints | (this.gc.getXORMode() ? XOR_MASK : 0);
        this.currentState.relativeClip = new RectangleClipping(this.gc.getClipping());
        this.currentState.alpha = this.gc.getAlpha();
    }

    private void initTransform(boolean force) {
        if (!force && this.translateX == 0 && this.translateY == 0) {
            return;
        }
        if (this.transform == null) {
            this.transform = new Transform((Device)Display.getCurrent());
            this.elementsNeedUpdate = true;
            this.transform.translate((float)this.translateX, (float)this.translateY);
            this.translateX = 0;
            this.translateY = 0;
            this.gc.setTransform(this.transform);
            this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK;
        }
    }

    public void popState() {
        --this.stackPointer;
        this.restoreState((State)this.stack.get(this.stackPointer));
    }

    public void pushState() {
        if (this.currentState.relativeClip == null) {
            throw new IllegalStateException("The clipping has been modified ina way that cannot be saved and restored.");
        }
        try {
            this.currentState.dx = this.translateX;
            this.currentState.dy = this.translateY;
            if (this.elementsNeedUpdate) {
                this.elementsNeedUpdate = false;
                this.currentState.affineMatrix = new float[6];
                this.transform.getElements(this.currentState.affineMatrix);
            }
            if (this.stack.size() > this.stackPointer) {
                State s = (State)this.stack.get(this.stackPointer);
                s.copyFrom(this.currentState);
            } else {
                this.stack.add(this.currentState.clone());
            }
            this.sharedClipping = true;
            ++this.stackPointer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void reconcileHints(GC gc, int applied, int hints) {
        int changes = hints ^ applied;
        if ((changes & XOR_MASK) != 0) {
            gc.setXORMode((hints & XOR_MASK) != 0);
        }
        if ((changes &= ~XOR_MASK) != 0) {
            if ((changes & INTERPOLATION_MASK) != 0) {
                gc.setInterpolation(((hints & INTERPOLATION_MASK) >> INTERPOLATION_SHIFT) - 1);
            }
            if ((changes & FILL_RULE_MASK) != 0) {
                gc.setFillRule(((hints & FILL_RULE_MASK) >> FILL_RULE_SHIFT) - -1);
            }
            if ((changes & AA_MASK) != 0) {
                gc.setAntialias(((hints & AA_MASK) >> AA_SHIFT) - 1);
            }
            if ((changes & TEXT_AA_MASK) != 0) {
                gc.setTextAntialias(((hints & TEXT_AA_MASK) >> TEXT_AA_SHIFT) - 1);
            }
            if ((changes & ADVANCED_GRAPHICS_MASK) != 0 && (hints & ADVANCED_GRAPHICS_MASK) != 0 && !gc.getAdvanced()) {
                gc.setAdvanced(true);
            }
        }
    }

    public void restoreState() {
        this.restoreState((State)this.stack.get(this.stackPointer - 1));
    }

    protected void restoreState(State s) {
        this.setAffineMatrix(s.affineMatrix);
        this.currentState.relativeClip = s.relativeClip;
        this.sharedClipping = true;
        if (this.gc.getAdvanced() && (s.graphicHints & ADVANCED_GRAPHICS_MASK) == 0) {
            this.appliedState.relativeClip = null;
            this.gc.setAdvanced(false);
            this.appliedState.graphicHints &= ~ADVANCED_HINTS_MASK;
            this.appliedState.graphicHints |= ADVANCED_HINTS_DEFAULTS;
        }
        this.setBackgroundColor(s.bgColor);
        this.setBackgroundPattern(s.bgPattern);
        this.setForegroundColor(s.fgColor);
        this.setForegroundPattern(s.fgPattern);
        this.setAlpha(s.alpha);
        this.setLineAttributes(s.lineAttributes);
        this.setFont(s.font);
        this.setGraphicHints(s.graphicHints);
        this.translateX = this.currentState.dx = s.dx;
        this.translateY = this.currentState.dy = s.dy;
    }

    public void rotate(float degrees) {
        this.checkGC();
        this.initTransform(true);
        this.transform.rotate(degrees);
        this.gc.setTransform(this.transform);
        this.elementsNeedUpdate = true;
        this.currentState.relativeClip = null;
        this.appliedState.relativeClip = null;
    }

    public void scale(double factor) {
        this.scale((float)factor, (float)factor);
    }

    public void scale(float horizontal, float vertical) {
        this.checkGC();
        this.initTransform(true);
        this.transform.scale(horizontal, vertical);
        this.gc.setTransform(this.transform);
        this.elementsNeedUpdate = true;
        this.checkSharedClipping();
        if (this.currentState.relativeClip != null) {
            this.currentState.relativeClip.scale(horizontal, vertical);
        }
    }

    private void setAffineMatrix(float[] m) {
        if (!this.elementsNeedUpdate && this.currentState.affineMatrix == m) {
            return;
        }
        this.currentState.affineMatrix = m;
        if (m != null) {
            this.transform.setElements(m[0], m[1], m[2], m[3], m[4], m[5]);
        } else if (this.transform != null) {
            this.transform.dispose();
            this.transform = null;
            this.elementsNeedUpdate = false;
        }
        this.gc.setTransform(this.transform);
    }

    public void setAlpha(int alpha) {
        this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK;
        if (this.currentState.alpha != alpha) {
            this.currentState.alpha = alpha;
            this.gc.setAlpha(this.currentState.alpha);
        }
    }

    public void setAntialias(int value) {
        this.currentState.graphicHints &= ~AA_MASK;
        this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK | value + 1 << AA_SHIFT;
    }

    public void setAdvanced(boolean value) {
        this.currentState.graphicHints = value ? (this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK) : (this.currentState.graphicHints &= ~ADVANCED_GRAPHICS_MASK);
    }

    public void setBackgroundColor(Color color) {
        this.currentState.bgColor = color;
        if (this.currentState.bgPattern != null) {
            this.currentState.bgPattern = null;
            this.appliedState.bgColor = null;
        }
    }

    public void setBackgroundPattern(Pattern pattern) {
        this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK;
        if (this.currentState.bgPattern == pattern) {
            return;
        }
        this.currentState.bgPattern = pattern;
        if (pattern != null) {
            this.initTransform(true);
        }
        this.gc.setBackgroundPattern(pattern);
    }

    public void setClip(Path path) {
        this.initTransform(false);
        if (((this.appliedState.graphicHints ^ this.currentState.graphicHints) & FILL_RULE_MASK) != 0) {
            this.gc.setFillRule(((this.currentState.graphicHints & FILL_RULE_MASK) >> FILL_RULE_SHIFT) - -1);
            this.appliedState.graphicHints ^= FILL_RULE_MASK;
        }
        this.gc.setClipping(path);
        this.currentState.relativeClip = null;
        this.appliedState.relativeClip = null;
    }

    public void clipPath(Path path) {
        Rectangle clipping;
        this.initTransform(false);
        if (((this.appliedState.graphicHints ^ this.currentState.graphicHints) & FILL_RULE_MASK) != 0) {
            this.gc.setFillRule(((this.currentState.graphicHints & FILL_RULE_MASK) >> FILL_RULE_SHIFT) - -1);
            this.appliedState.graphicHints ^= FILL_RULE_MASK;
        }
        Rectangle rectangle = clipping = this.currentState.relativeClip != null ? this.getClip(new Rectangle()) : new Rectangle();
        if (!clipping.isEmpty()) {
            Path flatPath = new Path(path.getDevice(), path, 0.01f);
            PathData pathData = flatPath.getPathData();
            flatPath.dispose();
            Region region = new Region(path.getDevice());
            SWTGraphics.loadPath(region, pathData.points, pathData.types);
            region.intersect(new org.eclipse.swt.graphics.Rectangle(clipping.x, clipping.y, clipping.width, clipping.height));
            this.gc.setClipping(region);
            this.currentState.relativeClip = null;
            this.appliedState.relativeClip = null;
            region.dispose();
        }
    }

    public void setClip(Rectangle rect) {
        this.currentState.relativeClip = new RectangleClipping(rect);
    }

    public void setFillRule(int rule) {
        this.currentState.graphicHints &= ~FILL_RULE_MASK;
        this.currentState.graphicHints |= rule + -1 << FILL_RULE_SHIFT;
    }

    public void setFont(Font f) {
        this.currentState.font = f;
    }

    public void setForegroundColor(Color color) {
        this.currentState.fgColor = color;
        if (this.currentState.fgPattern != null) {
            this.currentState.fgPattern = null;
            this.appliedState.fgColor = null;
        }
    }

    public void setForegroundPattern(Pattern pattern) {
        this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK;
        if (this.currentState.fgPattern == pattern) {
            return;
        }
        this.currentState.fgPattern = pattern;
        if (pattern != null) {
            this.initTransform(true);
        }
        this.gc.setForegroundPattern(pattern);
    }

    private void setGraphicHints(int hints) {
        this.currentState.graphicHints = hints;
    }

    public void setInterpolation(int interpolation) {
        this.currentState.graphicHints &= ~INTERPOLATION_MASK;
        this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK | interpolation + 1 << INTERPOLATION_SHIFT;
    }

    public void setLineAttributes(LineAttributes lineAttributes) {
        SWTGraphics.copyLineAttributes(this.currentState.lineAttributes, lineAttributes);
    }

    public void setLineCap(int value) {
        this.currentState.lineAttributes.cap = value;
    }

    public void setLineDash(int[] dashes) {
        float[] fArray = null;
        if (dashes != null) {
            fArray = new float[dashes.length];
            int i = 0;
            while (i < dashes.length) {
                fArray[i] = dashes[i];
                ++i;
            }
        }
        this.setLineDash(fArray);
    }

    public void setLineDash(float[] value) {
        if (value != null) {
            int i = 0;
            while (i < value.length) {
                if (value[i] <= 0.0f) {
                    SWT.error((int)5);
                }
                ++i;
            }
            this.currentState.lineAttributes.dash = (float[])value.clone();
            this.currentState.lineAttributes.style = 6;
        } else {
            this.currentState.lineAttributes.dash = null;
            this.currentState.lineAttributes.style = 1;
        }
    }

    public void setLineDashOffset(float value) {
        this.currentState.lineAttributes.dashOffset = value;
    }

    public void setLineJoin(int value) {
        this.currentState.lineAttributes.join = value;
    }

    public void setLineStyle(int value) {
        this.currentState.lineAttributes.style = value;
    }

    public void setLineWidth(int width) {
        this.currentState.lineAttributes.width = width;
    }

    public void setLineWidthFloat(float value) {
        this.currentState.lineAttributes.width = value;
    }

    public void setLineMiterLimit(float value) {
        this.currentState.lineAttributes.miterLimit = value;
    }

    public void setTextAntialias(int value) {
        this.currentState.graphicHints &= ~TEXT_AA_MASK;
        this.currentState.graphicHints |= ADVANCED_GRAPHICS_MASK | value + 1 << TEXT_AA_SHIFT;
    }

    public void setXORMode(boolean xor) {
        this.currentState.graphicHints &= ~XOR_MASK;
        if (xor) {
            this.currentState.graphicHints |= XOR_MASK;
        }
    }

    public void shear(float horz, float vert) {
        this.checkGC();
        this.initTransform(true);
        float[] matrix = new float[6];
        this.transform.getElements(matrix);
        this.transform.setElements(matrix[0] + matrix[2] * vert, matrix[1] + matrix[3] * vert, matrix[0] * horz + matrix[2], matrix[1] * horz + matrix[3], matrix[4], matrix[5]);
        this.gc.setTransform(this.transform);
        this.elementsNeedUpdate = true;
        this.currentState.relativeClip = null;
        this.appliedState.relativeClip = null;
    }

    public void translate(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return;
        }
        if (this.transform != null) {
            this.checkGC();
            this.transform.translate((float)dx, (float)dy);
            this.elementsNeedUpdate = true;
            this.gc.setTransform(this.transform);
        } else {
            this.translateX += dx;
            this.translateY += dy;
        }
        this.checkSharedClipping();
        if (this.currentState.relativeClip != null) {
            this.currentState.relativeClip.translate(-dx, -dy);
        }
    }

    public void translate(float dx, float dy) {
        this.initTransform(true);
        this.checkGC();
        this.transform.translate(dx, dy);
        this.elementsNeedUpdate = true;
        this.gc.setTransform(this.transform);
        this.checkSharedClipping();
        if (this.currentState.relativeClip != null) {
            this.currentState.relativeClip.translate(-dx, -dy);
        }
    }

    private void translatePointArray(int[] points, int translateX, int translateY) {
        if (translateX == 0 && translateY == 0) {
            return;
        }
        int i = 0;
        while (i + 1 < points.length) {
            int n = i;
            points[n] = points[n] + translateX;
            int n2 = i + 1;
            points[n2] = points[n2] + translateY;
            i += 2;
        }
    }

    public static LineAttributes clone(LineAttributes src) {
        float[] dashClone = null;
        if (src.dash != null) {
            dashClone = new float[src.dash.length];
            System.arraycopy(src.dash, 0, dashClone, 0, dashClone.length);
        }
        return new LineAttributes(src.width, src.cap, src.join, src.style, dashClone, src.dashOffset, src.miterLimit);
    }

    public static void copyLineAttributes(LineAttributes dest, LineAttributes src) {
        if (dest != src) {
            dest.cap = src.cap;
            dest.join = src.join;
            dest.miterLimit = src.miterLimit;
            dest.style = src.style;
            dest.width = src.width;
            if (src.dash == null) {
                dest.dash = null;
            } else {
                if (dest.dash == null || dest.dash.length != src.dash.length) {
                    dest.dash = new float[src.dash.length];
                }
                System.arraycopy(src.dash, 0, dest.dash, 0, src.dash.length);
            }
        }
    }

    private static int[] convertFloatArrayToInt(float[] fArray) {
        int[] iArray = null;
        if (fArray != null) {
            int arrayLen = fArray.length;
            iArray = new int[arrayLen];
            int i = 0;
            while (i < arrayLen) {
                iArray[i] = (int)fArray[i];
                ++i;
            }
        }
        return iArray;
    }

    static void loadPath(Region region, float[] points, byte[] types) {
        int start = 0;
        int end = 0;
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: {
                    int k;
                    int[] temp;
                    int n;
                    if (start != end) {
                        n = 0;
                        temp = new int[end - start];
                        k = start;
                        while (k < end) {
                            temp[n++] = Math.round(points[k]);
                            ++k;
                        }
                        region.add(temp);
                    }
                    start = end;
                    end += 2;
                    break;
                }
                case 2: {
                    end += 2;
                    break;
                }
                case 5: {
                    int k;
                    int[] temp;
                    int n;
                    if (start != end) {
                        n = 0;
                        temp = new int[end - start];
                        k = start;
                        while (k < end) {
                            temp[n++] = Math.round(points[k]);
                            ++k;
                        }
                        region.add(temp);
                    }
                    start = end;
                }
            }
            ++i;
        }
        if (start != end) {
            int n = 0;
            int[] temp = new int[end - start];
            int k = start;
            while (k < end) {
                temp[n++] = Math.round(points[k]);
                ++k;
            }
            region.add(temp);
        }
    }

    static interface Clipping {
        public Rectangle getBoundingBox(Rectangle var1);

        public Clipping getCopy();

        public void intersect(int var1, int var2, int var3, int var4);

        public void scale(float var1, float var2);

        public void setOn(GC var1, int var2, int var3);

        public void translate(float var1, float var2);
    }

    static class LazyState {
        Color bgColor;
        Color fgColor;
        Font font;
        int graphicHints;
        LineAttributes lineAttributes;
        Clipping relativeClip;

        LazyState() {
        }
    }

    static class RectangleClipping
    implements Clipping {
        private float top;
        private float left;
        private float bottom;
        private float right;

        RectangleClipping(float left, float top, float right, float bottom) {
            this.left = left;
            this.right = right;
            this.bottom = bottom;
            this.top = top;
        }

        RectangleClipping(org.eclipse.swt.graphics.Rectangle rect) {
            this.left = rect.x;
            this.top = rect.y;
            this.right = rect.x + rect.width;
            this.bottom = rect.y + rect.height;
        }

        RectangleClipping(Rectangle rect) {
            this.left = rect.x;
            this.top = rect.y;
            this.right = rect.right();
            this.bottom = rect.bottom();
        }

        public Rectangle getBoundingBox(Rectangle rect) {
            rect.x = (int)this.left;
            rect.y = (int)this.top;
            rect.width = (int)Math.ceil(this.right) - rect.x;
            rect.height = (int)Math.ceil(this.bottom) - rect.y;
            return rect;
        }

        public Clipping getCopy() {
            return new RectangleClipping(this.left, this.top, this.right, this.bottom);
        }

        public void intersect(int left, int top, int right, int bottom) {
            this.left = Math.max(this.left, (float)left);
            this.right = Math.min(this.right, (float)right);
            this.top = Math.max(this.top, (float)top);
            this.bottom = Math.min(this.bottom, (float)bottom);
            if (right < left || bottom < top) {
                this.right = left - 1;
                this.bottom = top - 1;
            }
        }

        public void scale(float horz, float vert) {
            this.left /= horz;
            this.right /= horz;
            this.top /= vert;
            this.bottom /= vert;
        }

        public void setOn(GC gc, int translateX, int translateY) {
            int xInt = (int)Math.floor(this.left);
            int yInt = (int)Math.floor(this.top);
            gc.setClipping(xInt + translateX, yInt + translateY, (int)Math.ceil(this.right) - xInt, (int)Math.ceil(this.bottom) - yInt);
        }

        public void translate(float dx, float dy) {
            this.left += dx;
            this.right += dx;
            this.top += dy;
            this.bottom += dy;
        }
    }

    static class State
    extends LazyState
    implements Cloneable {
        float[] affineMatrix;
        int alpha;
        Pattern bgPattern;
        int dx;
        int dy;
        Pattern fgPattern;

        State() {
        }

        public Object clone() throws CloneNotSupportedException {
            State clone = (State)super.clone();
            clone.lineAttributes = SWTGraphics.clone(clone.lineAttributes);
            return clone;
        }

        public void copyFrom(State state) {
            this.bgColor = state.bgColor;
            this.fgColor = state.fgColor;
            this.lineAttributes = SWTGraphics.clone(state.lineAttributes);
            this.dx = state.dx;
            this.dy = state.dy;
            this.bgPattern = state.bgPattern;
            this.fgPattern = state.fgPattern;
            this.font = state.font;
            this.graphicHints = state.graphicHints;
            this.affineMatrix = state.affineMatrix;
            this.relativeClip = state.relativeClip;
            this.alpha = state.alpha;
        }
    }
}

