/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.action;

import java.util.List;
import jp.sourceforge.tmdmaker.action.AbstractEntitySelectionAction;
import jp.sourceforge.tmdmaker.dialog.SubsetCreateDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditSubsetEntity;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpart.LaputaEditPart;
import jp.sourceforge.tmdmaker.editpart.MultivalueAndAggregatorEditPart;
import jp.sourceforge.tmdmaker.editpart.SubsetTypeEditPart;
import jp.sourceforge.tmdmaker.editpart.VirtualSupersetEditPart;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.Entity2SubsetTypeRelationship;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.SubsetType2SubsetRelationship;
import jp.sourceforge.tmdmaker.model.command.ImplementDerivationModelsDeleteCommand;
import jp.sourceforge.tmdmaker.model.command.SubsetTypeDeleteCommand;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import jp.sourceforge.tmdmaker.model.rule.SubsetRule;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IWorkbenchPart;

public class SubsetCreateAction
extends AbstractEntitySelectionAction {
    public static final String ID = "_SUBSET";

    public SubsetCreateAction(IWorkbenchPart part) {
        super(part);
        this.setText("\u30b5\u30d6\u30bb\u30c3\u30c8");
        this.setId(ID);
    }

    @Override
    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() == 1) {
            Object selection = this.getSelectedObjects().get(0);
            return selection instanceof AbstractEntityEditPart && !(selection instanceof SubsetTypeEditPart) && !(selection instanceof MultivalueAndAggregatorEditPart) && !(selection instanceof VirtualSupersetEditPart) && !(selection instanceof LaputaEditPart);
        }
        return false;
    }

    public void run() {
        AbstractEntityEditPart part = this.getPart();
        AbstractEntityModel model = this.getModel();
        SubsetType subsetType = SubsetRule.setupSubsetType(model);
        SubsetCreateDialog dialog = new SubsetCreateDialog(part.getViewer().getControl().getShell(), subsetType.getSubsetType(), subsetType.isExceptNull(), model.getAttributes(), subsetType.findSubsetEntityList(), subsetType.getPartitionAttribute());
        if (dialog.open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            SubsetType.SubsetTypeValue newSubsetType = dialog.getEditedSubsetType();
            IAttribute selectedPartitionAttribute = dialog.getEditedPartitionAttribute();
            boolean newExceptNull = dialog.isEditedExceptNull();
            ccommand.add(this.createSuitableSubsetTypeCommand(model, subsetType, newSubsetType, selectedPartitionAttribute, newExceptNull));
            List<EditSubsetEntity> editSubsets = dialog.getEditedSubsetEntities();
            this.addSuitableSubsetEntityCommand(model, subsetType, ccommand, editSubsets);
            List<EditSubsetEntity> deleteSubsets = dialog.getDeletedSubsetEntities();
            this.addSubsetDeleteCommand(model, subsetType, ccommand, deleteSubsets);
            this.execute((Command)ccommand);
        }
    }

    private void addSubsetDeleteCommand(AbstractEntityModel model, SubsetType subsetType, CompoundCommand ccommand, List<EditSubsetEntity> deleteSubsets) {
        AbstractEntityModel original = null;
        for (EditSubsetEntity e : deleteSubsets) {
            SubsetEntity subset = e.getOriginal();
            if (original == null) {
                original = ImplementRule.findOriginalImplementModel(subset);
            }
            SubsetDeleteCommand command = new SubsetDeleteCommand(subset);
            ccommand.add((Command)command);
            if (!subset.isNotImplement()) continue;
            ccommand.add((Command)new ImplementDerivationModelsDeleteCommand(subset, original));
        }
        if (deleteSubsets.size() > 0) {
            SubsetTypeDeleteCommand command = new SubsetTypeDeleteCommand(model.getDiagram(), subsetType);
            ccommand.add((Command)command);
        }
    }

    private void addSuitableSubsetEntityCommand(AbstractEntityModel model, SubsetType subsetType, CompoundCommand ccommand, List<EditSubsetEntity> editSubsets) {
        for (EditSubsetEntity e : editSubsets) {
            if (e.isAdded()) {
                SubsetCreateCommand command = new SubsetCreateCommand(model, subsetType, SubsetRule.createSubsetEntity(model, e.getName()));
                ccommand.add((Command)command);
                continue;
            }
            if (!e.isNameChanged()) continue;
            SubsetEntity subsetEntity = e.getOriginal();
            SubsetNameChangeCommand command = new SubsetNameChangeCommand(subsetEntity, e.getName());
            ccommand.add((Command)command);
        }
    }

    private Command createSuitableSubsetTypeCommand(AbstractEntityModel model, SubsetType subsetType, SubsetType.SubsetTypeValue newSubsetType, IAttribute selectedPartitionAttribute, boolean newExceptNull) {
        if (subsetType.getConstraint() == null) {
            Rectangle constraint = model.getConstraint().getTranslated(0, 50);
            subsetType.setConstraint(constraint);
            subsetType.setExceptNull(newExceptNull);
            subsetType.setSubsetType(newSubsetType);
            return new Entity2SubsetTypeCreateCommand(model, subsetType, selectedPartitionAttribute);
        }
        return new SubsetTypeChangeCommand(subsetType, newSubsetType, selectedPartitionAttribute, newExceptNull);
    }

    private static class Entity2SubsetTypeCreateCommand
    extends Command {
        private Diagram diagram;
        private AbstractEntityModel model;
        private SubsetType subsetType;
        private Entity2SubsetTypeRelationship model2subsetRelationship;

        public Entity2SubsetTypeCreateCommand(AbstractEntityModel model, SubsetType subsetType, IAttribute partitionAttribute) {
            this.diagram = model.getDiagram();
            this.model = model;
            this.subsetType = subsetType;
            this.model2subsetRelationship = new Entity2SubsetTypeRelationship(this.model, this.subsetType);
            this.subsetType.setPartitionAttribute(partitionAttribute);
        }

        public void execute() {
            this.diagram.addChild(this.subsetType);
            this.model2subsetRelationship.connect();
        }

        public void undo() {
            this.model2subsetRelationship.disconnect();
            this.diagram.removeChild(this.subsetType);
        }
    }

    private static class SubsetCreateCommand
    extends Command {
        private Diagram diagram;
        private AbstractEntityModel model;
        private SubsetType subsetType;
        private Entity2SubsetTypeRelationship model2subsetTypeRelationship;
        private SubsetEntity subsetEntity;
        private SubsetType2SubsetRelationship subsetType2subsetEntityRelationship;

        public SubsetCreateCommand(AbstractEntityModel model, SubsetType subsetType, SubsetEntity subsetEntity) {
            this.model = model;
            this.subsetType = subsetType;
            this.diagram = model.getDiagram();
            this.subsetEntity = subsetEntity;
            this.subsetType2subsetEntityRelationship = new SubsetType2SubsetRelationship(this.subsetType, this.subsetEntity);
            Rectangle constraint = subsetType.getConstraint().getTranslated(0, 50);
            subsetEntity.setConstraint(constraint);
        }

        public void execute() {
            this.model2subsetTypeRelationship = this.subsetType.getModelTargetConnections().size() == 0 ? new Entity2SubsetTypeRelationship(this.model, this.subsetType) : (Entity2SubsetTypeRelationship)this.subsetType.getModelTargetConnections().get(0);
            this.model2subsetTypeRelationship.connect();
            this.diagram.addChild(this.subsetEntity);
            this.subsetType2subsetEntityRelationship.connect();
        }

        public void undo() {
            this.subsetType2subsetEntityRelationship.disconnect();
            this.diagram.removeChild(this.subsetEntity);
            this.model2subsetTypeRelationship.disconnect();
        }
    }

    private static class SubsetDeleteCommand
    extends Command {
        private SubsetEntity model;
        private Diagram diagram;
        private RelatedRelationship relationship;

        public SubsetDeleteCommand(SubsetEntity model) {
            this.model = model;
            this.diagram = model.getDiagram();
            this.relationship = (RelatedRelationship)model.getModelTargetConnections().get(0);
        }

        public void execute() {
            this.relationship.disconnect();
            this.diagram.removeChild(this.model);
        }

        public void undo() {
            this.diagram.addChild(this.model);
            this.relationship.connect();
        }
    }

    private static class SubsetNameChangeCommand
    extends Command {
        private SubsetEntity model;
        private String oldName;
        private String newName;

        public SubsetNameChangeCommand(SubsetEntity model, String name) {
            this.model = model;
            this.oldName = model.getName();
            this.newName = name;
        }

        public void execute() {
            this.model.setName(this.newName);
        }

        public void undo() {
            this.model.setName(this.oldName);
        }
    }

    private static class SubsetTypeChangeCommand
    extends Command {
        private SubsetType subsetType;
        private SubsetType.SubsetTypeValue newSubsetTypeValue;
        private SubsetType.SubsetTypeValue oldSubsetTypeValue;
        private IAttribute oldPartitionAttribute;
        private IAttribute newPartitionAttribute;
        private boolean oldExceptNull;
        private boolean newExceptNull;
        private Entity2SubsetTypeRelationship relationship;

        public SubsetTypeChangeCommand(SubsetType subsetType, SubsetType.SubsetTypeValue newSubsetTypeValue, IAttribute selectedPartitionAttribute, boolean newExceptNull) {
            this.subsetType = subsetType;
            this.oldSubsetTypeValue = subsetType.getSubsetType();
            this.newSubsetTypeValue = newSubsetTypeValue;
            this.newPartitionAttribute = selectedPartitionAttribute;
            this.newExceptNull = newExceptNull;
            this.oldExceptNull = subsetType.isExceptNull();
        }

        public void execute() {
            this.subsetType.setSubsetType(this.newSubsetTypeValue);
            if (this.subsetType.getModelTargetConnections() != null && this.subsetType.getModelTargetConnections().size() > 0) {
                this.relationship = (Entity2SubsetTypeRelationship)this.subsetType.getModelTargetConnections().get(0);
                this.oldPartitionAttribute = this.relationship.getPartitionAttribute();
                this.subsetType.setExceptNull(this.newExceptNull);
                this.subsetType.setPartitionAttribute(this.newPartitionAttribute);
            }
        }

        public void undo() {
            this.subsetType.setSubsetType(this.oldSubsetTypeValue);
            if (this.relationship != null) {
                this.subsetType.setExceptNull(this.oldExceptNull);
                this.subsetType.setPartitionAttribute(this.oldPartitionAttribute);
            }
        }
    }
}

