/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.dialog.component.AttributeSettingPanel;
import jp.sourceforge.tmdmaker.dialog.component.DetailIdentifierSettingPanel;
import jp.sourceforge.tmdmaker.dialog.component.ImplementInfoSettingPanel;
import jp.sourceforge.tmdmaker.dialog.component.TableNameSettingPanel;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.Identifier;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DetailEditDialog
extends Dialog {
    private Detail original;
    private Detail editedValue;
    private List<EditAttribute> editAttributeList = new ArrayList<EditAttribute>();
    private TableNameSettingPanel panel1;
    private AttributeSettingPanel panel2;
    private DetailIdentifierSettingPanel panel3;
    private ImplementInfoSettingPanel panel4;
    private List<IAttribute> newAttributeOrder = new ArrayList<IAttribute>();
    private List<IAttribute> addAttributes = new ArrayList<IAttribute>();
    private List<IAttribute> editAttributes = new ArrayList<IAttribute>();

    public DetailEditDialog(Shell parentShell, Detail original) {
        super(parentShell);
        this.original = original;
        for (IAttribute a : this.original.getAttributes()) {
            this.editAttributeList.add(new EditAttribute(a));
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("DTL\u8868\u7de8\u96c6");
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.panel1 = new TableNameSettingPanel(composite, 0);
        GridData gridData = new GridData(768);
        this.panel1.setLayoutData(gridData);
        gridData = new GridData(768);
        this.panel3 = new DetailIdentifierSettingPanel(composite, 0);
        this.panel3.setLayoutData(gridData);
        gridData = new GridData(768);
        this.panel4 = new ImplementInfoSettingPanel(composite, 0);
        this.panel4.setLayoutData(gridData);
        gridData = new GridData(768);
        this.panel2 = new AttributeSettingPanel(composite, 0);
        this.panel2.setLayoutData(gridData);
        composite.pack();
        this.initializeValue();
        return composite;
    }

    private void initializeValue() {
        this.panel1.setTableName(this.original.getName());
        this.panel2.setAttributeTableRow(this.editAttributeList);
        this.panel3.setEditIdentifier(new EditAttribute(this.original.getDetailIdentifier()));
        this.panel3.setIdentifierName(this.original.getDetailIdentifier().getName());
        this.panel4.initializeValue(this.original.isNotImplement(), this.original.getImplementName());
    }

    protected void okPressed() {
        this.editedValue = new Detail();
        this.editedValue.setName(this.panel1.getTableName());
        Identifier newIdentifier = new Identifier(this.panel3.getIdentifierName());
        EditAttribute editIdentifier = this.panel3.getEditIdentifier();
        editIdentifier.copyTo(newIdentifier);
        this.editedValue.setDetailIdentifier(newIdentifier);
        this.editedValue.setNotImplement(this.panel4.isNotImplement());
        this.editedValue.setImplementName(this.panel4.getImplementName());
        this.createEditAttributeResult();
        super.okPressed();
    }

    private void createEditAttributeResult() {
        for (EditAttribute ea : this.editAttributeList) {
            IAttribute originalAttribute = ea.getOriginalAttribute();
            if (ea.isAdded()) {
                ea.copyToOriginal();
                this.addAttributes.add(ea.getOriginalAttribute());
            } else if (ea.isNameChanged()) {
                this.editAttributes.add(originalAttribute);
            }
            this.newAttributeOrder.add(originalAttribute);
        }
        this.editedValue.setAttributes(this.newAttributeOrder);
    }

    public List<EditAttribute> getEditAttributeList() {
        return this.editAttributeList;
    }

    public Detail getEditedValue() {
        return this.editedValue;
    }
}

