/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __PRINT_H__
#define __PRINT_H__


#include "tmaid.h"
#ifdef G_OS_WIN32
# include <windows.h>
#endif /* not G_OS_WIN32 */


typedef struct PrintConfig_Tag {
	gboolean select;
	gint column, font_width, font_height;
	gint width, height;
#if defined G_OS_UNIX || defined G_OS_WIN32
	gint copies;
#endif /* G_OS_UNIX or G_OS_WIN32 */
#ifdef G_OS_WIN32
	PRINTDLG pd;
#else /* not G_OS_WIN32 */
# ifdef G_OS_UNIX
	gboolean mode;
	gchar *printer;
# endif /* G_OS_UNIX */
	gchar *file;
	gint left, top, right, bottom;
#endif /* not G_OS_WIN32 */
} PrintConfig;


extern PrintConfig printer;				/* ????? */


gboolean print_out(TmaidWindow *tmaid,PrintConfig *prncfg);
gboolean print_dialog(PrintConfig *prncfg);


#endif
