/*
    Text maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "conf.h"


/******************************************************************************
*                                                                             *
* 設定関数群                                                                  *
*                                                                             *
******************************************************************************/
static gint width,height;
static GtkWidget *button0,*check0,*check1,*spin0,*spin1,*spin2;
static GtkWidget *radio0,*radio1,*radio2,*radio3;


/* OKボタンを表示 */
#define conf_dialog_toggled conf_dialog_changed
static void conf_dialog_changed(GtkWidget *widget,gpointer user_data)
{
    gint value0,value1,value2;

    value0=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0));
    value1=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
    value2=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
    gtk_widget_set_sensitive(button0,0<=value0 && value0<=10
                && 0<value1 && value1<=width && 0<value2 && value2<=height);
}


/* OKボタンが押された */
static void conf_dialog_clicked(GtkWidget *widget,GtkWidget *dialog)
{
    gint i;
    GList *glist;
    GtkWidget *menu_shell;

    history=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0));
    newfile=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check0));
    second=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check1));
    def_width=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
    def_height=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio0)))
        n_pos=GTK_POS_TOP;
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio1)))
        n_pos=GTK_POS_LEFT;
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio2)))
        n_pos=GTK_POS_RIGHT;
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio3)))
        n_pos=GTK_POS_BOTTOM;
    gtk_widget_destroy(dialog);
    /* 履歴の整理 */
    menu_shell = gtk_item_factory_get_widget (ifactory_menu, "<main>/File");
    glist = gtk_container_children (GTK_CONTAINER (menu_shell));
    for (i=g_list_length(glist)-3;i>history-(history==0)+MENUFILE-2;i--)
        gtk_container_remove (GTK_CONTAINER (menu_shell),
                                                g_list_nth_data (glist, i));
    g_list_free(glist);
    /* ノートの位置 */
    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook),n_pos);
}


/* スピンボタンでリターンが押された */
static void conf_dialog_activate(GtkWidget *widget,GtkWidget *dialog)
{
    gint value0,value1,value2;

    value0=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0));
    value1=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
    value2=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
    if (0<=value0 && value0<=10
                    && 0<value1 && value1<=width && 0<value2 && value2<=height)
        conf_dialog_clicked(widget,dialog);
}


/* ESCが押された */
static gboolean conf_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
                                                            gpointer user_data)
{
    if (event->keyval==GDK_Escape)
        gtk_widget_destroy(widget);
    return FALSE;
}


void conf_dialog(void)
{
    GtkWidget *dialog,*button1,*label0,*label1,*label2;
    GtkWidget *frame0,*frame1,*hbox0,*hbox1,*vbox;

    width=gdk_screen_width();
    height=gdk_screen_height();

    /* メインウインドウ */
    dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(dialog),_("Configuration"));
    g_signal_connect_after (G_OBJECT(dialog), "key-press-event",
                                    G_CALLBACK (conf_dialog_key_press), NULL);
    g_signal_connect (G_OBJECT (dialog), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
    /* ボタン */
    button0=gtk_button_new_with_label(_("OK"));
    button1=gtk_button_new_with_label(_("Cancel"));
    g_signal_connect (G_OBJECT (button0), "clicked",
                                    G_CALLBACK (conf_dialog_clicked), dialog);
    g_signal_connect_swapped (G_OBJECT (button1), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
    GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
    GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
    /* チェックボタン */
    check0 = gtk_check_button_new_with_mnemonic (_("_New File"));
    check1 = gtk_check_button_new_with_mnemonic (_("_Open Window"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check0),newfile);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check1),second);
    g_signal_connect (G_OBJECT (check0), "toggled",
                                    G_CALLBACK (conf_dialog_toggled), NULL);
    g_signal_connect (G_OBJECT (check1), "toggled",
                                    G_CALLBACK (conf_dialog_toggled), NULL);
    /* スピンボタン */
    spin0=gtk_spin_button_new(
            GTK_ADJUSTMENT(gtk_adjustment_new(history,0,10,1,5,0)),0,0);
    spin1=gtk_spin_button_new(
            GTK_ADJUSTMENT(gtk_adjustment_new(def_width,0,width,1,5,0)),0,0);
    spin2=gtk_spin_button_new(
            GTK_ADJUSTMENT(gtk_adjustment_new(def_height,0,height,1,5,0)),0,0);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin0),TRUE);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1),TRUE);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin2),TRUE);
    g_signal_connect (G_OBJECT (spin0), "activate",
                                    G_CALLBACK (conf_dialog_activate), dialog);
    g_signal_connect (G_OBJECT (spin1), "activate",
                                    G_CALLBACK (conf_dialog_activate), dialog);
    g_signal_connect (G_OBJECT (spin2), "activate",
                                    G_CALLBACK (conf_dialog_activate), dialog);
    g_signal_connect (G_OBJECT (spin0), "changed",
                                    G_CALLBACK (conf_dialog_changed), NULL);
    g_signal_connect (G_OBJECT (spin1), "changed",
                                    G_CALLBACK (conf_dialog_changed), NULL);
    g_signal_connect (G_OBJECT (spin2), "changed",
                                    G_CALLBACK (conf_dialog_changed), NULL);
    /* ラベル */
    label0 = gtk_label_new_with_mnemonic (_("H_istory"));
    label1 = gtk_label_new_with_mnemonic (_("_Width"));
    label2 = gtk_label_new_with_mnemonic (_("_Height"));
    gtk_label_set_mnemonic_widget (GTK_LABEL(label0), spin0);
    gtk_label_set_mnemonic_widget (GTK_LABEL(label1), spin1);
    gtk_label_set_mnemonic_widget (GTK_LABEL(label2), spin2);
    /* ラジオボタン */
    radio0 = gtk_radio_button_new_with_mnemonic (NULL, _("_Top"));
    radio1 = gtk_radio_button_new_with_mnemonic_from_widget
                                    (GTK_RADIO_BUTTON (radio0), _("_Left"));
    radio2 = gtk_radio_button_new_with_mnemonic_from_widget
                                    (GTK_RADIO_BUTTON (radio1), _("_Right"));
    radio3 = gtk_radio_button_new_with_mnemonic_from_widget
                                    (GTK_RADIO_BUTTON (radio2), _("_Bottom"));
    switch (n_pos) {
        case GTK_POS_TOP:   gtk_toggle_button_set_active(
                                        GTK_TOGGLE_BUTTON(radio0),TRUE);break;
        case GTK_POS_LEFT:  gtk_toggle_button_set_active(
                                        GTK_TOGGLE_BUTTON(radio1),TRUE);break;
        case GTK_POS_RIGHT: gtk_toggle_button_set_active(
                                        GTK_TOGGLE_BUTTON(radio2),TRUE);break;
        case GTK_POS_BOTTOM:gtk_toggle_button_set_active(
                                        GTK_TOGGLE_BUTTON(radio3),TRUE);
    }
    g_signal_connect (G_OBJECT (radio0), "toggled",
                                    G_CALLBACK (conf_dialog_toggled), NULL);
    g_signal_connect (G_OBJECT (radio1), "toggled",
                                    G_CALLBACK (conf_dialog_toggled), NULL);
    g_signal_connect (G_OBJECT (radio2), "toggled",
                                    G_CALLBACK (conf_dialog_toggled), NULL);
    g_signal_connect (G_OBJECT (radio3), "toggled",
                                    G_CALLBACK (conf_dialog_toggled), NULL);
    /* フレームとボックス */
    frame0=gtk_frame_new(_("Window Size"));
    hbox0 = gtk_hbox_new (FALSE, SPACING);
    gtk_container_set_border_width (GTK_CONTAINER (hbox0), SPACING);
    hbox1=gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox1),label1,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox1),spin1,TRUE,TRUE,0);
    gtk_box_pack_start(GTK_BOX(hbox0),hbox1,TRUE,TRUE,0);
    hbox1=gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox1),label2,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox1),spin2,TRUE,TRUE,0);
    gtk_box_pack_start(GTK_BOX(hbox0),hbox1,TRUE,TRUE,0);
    gtk_container_add(GTK_CONTAINER(frame0),hbox0);

    frame1=gtk_frame_new(_("Tab Position"));
    vbox = gtk_vbox_new (FALSE, SPACING);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
    hbox0 = gtk_hbox_new (FALSE, SPACING);
    gtk_box_pack_start(GTK_BOX(hbox0),radio0,TRUE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,0);
    hbox0 = gtk_hbox_new (FALSE, SPACING);
    gtk_box_pack_start(GTK_BOX(hbox0),radio1,FALSE,FALSE,0);
    gtk_box_pack_end(GTK_BOX(hbox0),radio2,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,0);
    hbox0=gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox0),radio3,TRUE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,0);
    gtk_container_add(GTK_CONTAINER(frame1),vbox);

    vbox = gtk_vbox_new (FALSE, SPACING);
    hbox0=gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox0),label0,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox0),spin0,TRUE,TRUE,0);
    gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),check0,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),check1,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),frame0,FALSE,FALSE,0);

    hbox0 = gtk_hbox_new (FALSE, SPACING);
    gtk_box_pack_start(GTK_BOX(hbox0),vbox,TRUE,TRUE,0);
    gtk_box_pack_start(GTK_BOX(hbox0),frame1,TRUE,TRUE,0);

    vbox = gtk_vbox_new (FALSE, SPACING);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
    gtk_box_pack_start(GTK_BOX(vbox),hbox0,TRUE,TRUE,0);
    hbox0 = gtk_hbox_new (FALSE, SPACING);
    gtk_box_pack_end(GTK_BOX(hbox0),button1,FALSE,FALSE,0);
    gtk_box_pack_end(GTK_BOX(hbox0),button0,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,0);
    gtk_container_add(GTK_CONTAINER(dialog),vbox);

    /* 表示 */
    gtk_widget_set_sensitive(button0,FALSE);
    gtk_widget_grab_focus(button1);

    gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
    gtk_grab_add(dialog);
    gtk_widget_show_all(dialog);
    gtk_main();
}
