/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WDIALOG_H__
#define __WDIALOG_H__


#include <windows.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:ダイアログボックスのコントロールを有効化または無効化する
       hDlg,ダイアログボックス
        nID,コントロールID
    fEnable,TRUE:有効,FALSE:無効
        RET,TRUE:無効だった,FALSE:有効だった                                */
BOOL WINAPI
EnableDlgItem (HWND hDlg,
               int  nID,
               BOOL fEnable);


/*  ja:ダイアログボックスのコントロールの文字数を取得する
    hDlg,ダイアログボックス
     nID,コントロールID
     RET,文字数,0:エラー                                                    */
int WINAPI
GetDlgItemTextLengthW (HWND hDlg,
                       int  nID);


/*  ja:ダイアログボックスのコントロールの文字数を取得する
    hDlg,ダイアログボックス
     nID,コントロールID
     RET,文字数,0:エラー                                                    */
int WINAPI
GetDlgItemTextLengthA (HWND hDlg,
                       int  nID);


/*  ja:ダイアログボックスのコントロールの文字を取得する
    hDlg,ダイアログボックス
     nID,コントロールID
     RET,文字数,0:エラー                                                    */
LPWSTR WINAPI
GetDlgItemTextNewW (HWND hDlg,
                    int  nID);


/*  ja:ダイアログボックスのコントロールの文字を取得する
    hDlg,ダイアログボックス
     nID,コントロールID
     RET,文字数,0:エラー                                                    */
LPSTR WINAPI
GetDlgItemTextNewA (HWND hDlg,
                    int  nID);


/*  ja:ダイアログボックスのコントロールの表示状態を設定する
        hDlg,ダイアログボックス
         nID,コントロールID
    nCmdShow,表示方法
         RET,TRUE:表示されていた,FALSE:表示されていなかった                 */
BOOL WINAPI
ShowDlgItem (HWND hDlg,
             int  nID,
             int  nCmdShow);


#ifdef UNICODE
# define GetDlgItemTextLength GetDlgItemTextLengthW
# define GetDlgItemTextNew GetDlgItemTextNewW
#else /* not UNICODE */
# define GetDlgItemTextLength GetDlgItemTextLengthA
# define GetDlgItemTextNew GetDlgItemTextNewA
#endif /* not UNICODE */


/******************************************************************************
*                                                                             *
******************************************************************************/
typedef struct _DLGITEMPOSITION
{
  int nID;
  BOOL fLeft, fTop, fRight, fBottom; /* ja:TRUE:距離は固定,FALSE:距離は可変 */
  int nLeft, nTop, nRight, nBottom;  /* ja:ウインドウの縁との距離 */
  int nWidth, nHeight;               /* ja:コントロールのサイズ */
} DLGITEMPOSITION, *LPDLGITEMPOSITION;


/*  ja:ダイアログボックスのコントロールの位置情報を初期化する
            hDlg,ダイアログボックス
    lpDlgItemPos,ダイアログ情報
          nCount,コントロールの数
             RET,TRUE:正常終了,FALSE:エラー                                 */
BOOL WINAPI
InitDlgItemPosition (HWND              hDlg,
                     LPDLGITEMPOSITION lpDlgItemPos,
                     int               nCount);


/*  ja:ダイアログボックスのコントロールの位置を設定する
            hDlg,ダイアログボックス
    lpDlgItemPos,ダイアログ情報
          nCount,コントロールの数
             RET,TRUE:正常終了,FALSE:エラー                                 */
BOOL WINAPI
SetDlgItemPosition (HWND              hDlg,
                    LPDLGITEMPOSITION lpDlgItemPos,
                    int               nCount);


/*  ja:モードレスダイアログボックスを作成する
       hInstance,モジュールのハンドル
      lpTemplate,ダイアログボックステンプレートの名前
      hWndParent,オーナーウィンドウのハンドル
    lpDialogFunc,ダイアログボックスプロシージャ
          lParam,初期化値
             RET,ダイアログボックスのハンドル                               */
HWND WINAPI
CreateDialogParamGUIW (HINSTANCE hInstance,
                       LPCWSTR   lpTemplate,
                       HWND      hWndParent,
                       DLGPROC   lpDialogFunc,
                       LPARAM    lParam);


/*  ja:モードレスダイアログボックスを作成する
       hInstance,モジュールのハンドル
      lpTemplate,ダイアログボックステンプレートの名前
      hWndParent,オーナーウィンドウのハンドル
    lpDialogFunc,ダイアログボックスプロシージャ
          lParam,初期化値
             RET,ダイアログボックスのハンドル                               */
HWND WINAPI
CreateDialogParamGUIA (HINSTANCE hInstance,
                       LPCSTR    lpTemplate,
                       HWND      hWndParent,
                       DLGPROC   lpDialogFunc,
                       LPARAM    lParam);


/*  ja:モードレスダイアログボックスを作成する
       hInstance,モジュールのハンドル
      lpTemplate,ダイアログボックステンプレートの名前
      hWndParent,オーナーウィンドウのハンドル
    lpDialogFunc,ダイアログボックスプロシージャ
             RET,ダイアログボックスのハンドル                               */
HWND WINAPI
CreateDialogGUIW (HINSTANCE hInstance,
                  LPCWSTR   lpTemplate,
                  HWND      hWndParent,
                  DLGPROC   lpDialogFunc);


/*  ja:モードレスダイアログボックスを作成する
       hInstance,モジュールのハンドル
      lpTemplate,ダイアログボックステンプレートの名前
      hWndParent,オーナーウィンドウのハンドル
    lpDialogFunc,ダイアログボックスプロシージャ
             RET,ダイアログボックスのハンドル                               */
HWND WINAPI
CreateDialogGUIA (HINSTANCE hInstance,
                  LPCSTR    lpTemplate,
                  HWND      hWndParent,
                  DLGPROC   lpDialogFunc);


/*  ja:モーダルダイアログボックスを作成する
       hInstance,モジュールのハンドル
      lpTemplate,ダイアログボックステンプレートの名前
      hWndParent,オーナーウィンドウのハンドル
    lpDialogFunc,ダイアログボックスプロシージャ
          lParam,初期化値
             RET,ダイアログボックスのハンドル                               */
INT_PTR WINAPI
DialogBoxParamGUIW (HINSTANCE hInstance,
                    LPCWSTR   lpTemplate,
                    HWND      hWndParent,
                    DLGPROC   lpDialogFunc,
                    LPARAM    lParam);


/*  ja:モーダルダイアログボックスを作成する
       hInstance,モジュールのハンドル
      lpTemplate,ダイアログボックステンプレートの名前
      hWndParent,オーナーウィンドウのハンドル
    lpDialogFunc,ダイアログボックスプロシージャ
          lParam,初期化値
             RET,ダイアログボックスのハンドル                               */
INT_PTR WINAPI
DialogBoxParamGUIA (HINSTANCE hInstance,
                    LPCSTR    lpTemplate,
                    HWND      hWndParent,
                    DLGPROC   lpDialogFunc,
                    LPARAM    lParam);


/*  ja:モーダルダイアログボックスを作成する
       hInstance,モジュールのハンドル
      lpTemplate,ダイアログボックステンプレートの名前
      hWndParent,オーナーウィンドウのハンドル
    lpDialogFunc,ダイアログボックスプロシージャ
             RET,ダイアログボックスのハンドル                               */
INT_PTR WINAPI
DialogBoxGUIW (HINSTANCE hInstance,
               LPCWSTR   lpTemplate,
               HWND      hWndParent,
               DLGPROC   lpDialogFunc);


/*  ja:モーダルダイアログボックスを作成する
       hInstance,モジュールのハンドル
      lpTemplate,ダイアログボックステンプレートの名前
      hWndParent,オーナーウィンドウのハンドル
    lpDialogFunc,ダイアログボックスプロシージャ
             RET,ダイアログボックスのハンドル                               */
INT_PTR WINAPI
DialogBoxGUIA (HINSTANCE hInstance,
               LPCSTR    lpTemplate,
               HWND      hWndParent,
               DLGPROC   lpDialogFunc);


#ifdef UNICODE
# define CreateDialogParamGUI CreateDialogParamGUIW
# define CreateDialogGUI CreateDialogGUIW
# define DialogBoxParamGUI DialogBoxParamGUIW
# define DialogBoxGUI DialogBoxGUIW
#else /* not UNICODE */
# define CreateDialogParamGUI CreateDialogParamGUIA
# define CreateDialogGUI CreateDialogGUIA
# define DialogBoxParamGUI DialogBoxParamGUIA
# define DialogBoxGUI DialogBoxGUIA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WDIALOG_H__ */
