/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "valchr.h"
#include <commctrl.h>
#include "resource.h"
#include "wcommon.h"


int nCodeDef = ' ';             /* ja:コード入力 */


/******************************************************************************
*                                                                             *
* ja:コード文字入力関数群                                                     *
*                                                                             *
******************************************************************************/
typedef struct _VALCHRDLG
{
  int nCode, *lpnCode;
} VALCHRDLG, *PVALCHRDLG, *LPVALCHRDLG;


static LPTSTR
ValChrDlgString (int nCode)
{
  LPTSTR lpszText;

  switch (nCode >> 8)
    {
      case 0:  lpszText = StringFromUnsigned (nCode & 255, 16, 2); break;
      case 1:  lpszText = StringFromUnsigned (nCode & 255, 10, 0); break;
      default: lpszText = StringFromUnsigned (nCode & 255,  8, 3);
    }
  return lpszText;
}


BOOL CALLBACK
ValChrDlgProc (HWND   hDlg,
               UINT   uMsg,
               WPARAM wParam,
               LPARAM lParam)
{
  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          LPTSTR lpszText;
          LPVALCHRDLG lpDlg;

          lpDlg = MemoryAlloc (sizeof (VALCHRDLG));
          SetWindowLongPtr (hDlg, DWLP_USER, (LONG_PTR)lpDlg);
          lpDlg->lpnCode = (int *)lParam;
          lpDlg->nCode = *lpDlg->lpnCode;
          /* ja:エディトコントロールの設定 */
          lpszText = ValChrDlgString (lpDlg->nCode);
          SetDlgItemText (hDlg, IDC_EDIT61, lpszText);
          MemoryFree (lpszText);
          /* ja:ラジオボタンの設定 */
          CheckRadioButton (hDlg, IDC_RADIOBUTTON61, IDC_RADIOBUTTON63,
                                    IDC_RADIOBUTTON61 + (lpDlg->nCode >> 8));
          /* ja:アップダウンコントロールの設定 */
          UpDownItem_SetRange (hDlg, IDC_UPDOWN61, 0, 255);
          UpDownItem_SetPos (hDlg, IDC_UPDOWN61, lpDlg->nCode & 255);
        }
        return TRUE;
      case WM_VSCROLL:
        {
          LPTSTR lpszText;
          LPVALCHRDLG lpDlg;

          lpDlg = (LPVALCHRDLG)GetWindowLongPtr (hDlg, DWLP_USER);
          lpszText = ValChrDlgString (HIWORD (wParam));
          SetDlgItemText (hDlg, IDC_EDIT61, lpszText);
          MemoryFree (lpszText);
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              {
                LPVALCHRDLG lpDlg;

                lpDlg = (LPVALCHRDLG)GetWindowLongPtr (hDlg, DWLP_USER);
                *lpDlg->lpnCode = lpDlg->nCode;
              }
            case IDCANCEL:
              EndDialog (hDlg, LOWORD (wParam));
              break;
            case IDC_EDIT61:
              if (HIWORD (wParam) == EN_CHANGE)
                {
                  int nValue;
                  LPTSTR lpszText;
                  LPVALCHRDLG lpDlg;

                  lpDlg = (LPVALCHRDLG)GetWindowLongPtr (hDlg, DWLP_USER);
                  lpszText = GetDlgItemTextNew (hDlg, IDC_EDIT61);
                  switch (lpDlg->nCode >> 8)
                    {
                      case 0:
                        nValue = StringToInteger (lpszText, NULL, 16);
                        break;
                      case 1:
                        nValue = StringToInteger (lpszText, NULL, 10);
                        break;
                      default:
                        nValue = StringToInteger (lpszText, NULL, 8);
                    }
                  MemoryFree (lpszText);
                  lpDlg->nCode = lpDlg->nCode & 0x300 | nValue & 0xff;
                  if (0 <= nValue && nValue <= 255)
                    {
                      SetDlgItemTextA (hDlg, IDC_STATIC61, ppszCode[nValue]);
                    }
                  else
                    {
                      lpszText = LoadText (GetModuleHandle (NULL),
                                                            IDS_OTHER_NOINPUT);
                      SetDlgItemText (hDlg, IDC_STATIC61, lpszText);
                      MemoryFree (lpszText);
                    }
                  /* ja:コントロールの表示状態 */
                  EnableDlgItem (hDlg, IDOK, 0 <= nValue && nValue <= 255
                                && !IsDBCSLeadByteEx (CP_ACP, (BYTE)nValue));
                }
              break;
            case IDC_RADIOBUTTON61:
            case IDC_RADIOBUTTON62:
            case IDC_RADIOBUTTON63:
              {
                LPTSTR lpszText;
                LPVALCHRDLG lpDlg;

                lpDlg = (LPVALCHRDLG)GetWindowLongPtr (hDlg, DWLP_USER);
                lpDlg->nCode = LOWORD (wParam) - IDC_RADIOBUTTON61 << 8
                                                        | lpDlg->nCode & 0xff;
                lpszText = ValChrDlgString (lpDlg->nCode);
                SetDlgItemText (hDlg, IDC_EDIT61, lpszText);
                MemoryFree (lpszText);
              }
          }
        return TRUE;
    }
  return FALSE;
}
