/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "tmaid.h"
#include <limits.h>
#include <commctrl.h>
#include <shlobj.h>
#include <shlwapi.h>
#include "file.h"
#include "find.h"
#include "jump.h"
#include "license.h"
#include "replace.h"
#include "resource.h"
#include "valchr.h"
#include "wcommon.h"
#include "wndmain.h"
#include "wndtext.h"


/* ja:システム変数 */
int nFileCount = 0;             /* ja:新規作成されたファイルの数 */
int nTypeCount = 0;             /* ja:新規作成されたファイルタイプの数 */
BOOL fClipBoard = FALSE;        /* ja:TRUE:クリップボードにあり,FALSE:なし */
BOOL fZoomed = FALSE;           /* ja:TRUE:最大化,FALSE:通常 */
UINT uDlMsg;                    /* ドラッグリストのメッセージ */
UINT uIns = 0;                  /* キャレットの状態(0:挿入,1:上書き) */


/* ja:ファイルタイプ */
int nFileType = 0;              /* ja:登録されているファイルタイプ */
LPFILETYPE lpFileType = NULL;   /* ja:ファイルタイプ */


/* ja:全体に対する設定(環境ダイアログで変更可能) */
int nHistory = 4;               /* ja:ファイルの履歴の最大数(0...9) */
int nRegStat = REG_STAT_READ | REG_STAT_WRITE;/* ja:レジストリのread/write */
DWORD dwFilter = 0;             /* ja:フィルタ */
LPTSTR lpszOpenPath;            /* ja:最後に読み込んだファイルのパス */
LPTSTR lpszSavePath;            /* ja:最後に書き込んだファイルのパス */
LPTSTR lpszHelpFile;            /* ja:ヘルプのファイル名 */


/* ja:色 */
COLORREF crWindowText;          /* ja:ウインドウの文字(標準:黒) */
COLORREF crGrayText;            /* ja:灰色の文字(標準:灰色) */
COLORREF crHighLightText;       /* ja:選択された文字(標準:白) */
HBRUSH hBrushWindow = NULL;     /* ja:背景 */
HBRUSH hBrushGray = NULL;       /* ja:全角スペース,改行 */
HBRUSH hBrushHighLight = NULL;  /* ja:選択された背景 */
HPEN hPenGray = NULL;           /* ja:タブ下線,右マージン */
HPEN hPenGrid = NULL;           /* ja:グリット */
HPEN hPenNull;                  /* ja:空のペン */


HACCEL hAccel;                  /* ja:アクセラレータキー */
HMENU hMenuPopup = NULL;
HWND hDlgCancel;                /* ja:中断ダイアログボックス */
HWND hWndMain;                  /* ja:メインウインドウ */
HWND hWndClient;                /* ja:MDIクライアントウインドウ */
HWND hWndTool;                  /* ja:メインウインドウのツールバー */
HWND hWndStat;                  /* ja:メインウインドウのステータスバー */


const CHAR cCRLF[2] = {0x0d, 0x0a};
LPSTR ppszCode[256];


/******************************************************************************
*                                                                             *
* ja:メイン関数群                                                             *
*                                                                             *
******************************************************************************/
int WINAPI
_tWinMain  (HINSTANCE hInstance,
            HINSTANCE hPrevInstance,
            LPTSTR    lpszCmdLine,
            int       nCmdShow)
{
  int i, nInitLine = 0;
  int nLeft = CW_USEDEFAULT, nTop = CW_USEDEFAULT;
  int nRight = CW_USEDEFAULT, nBottom = CW_USEDEFAULT;
  BOOL fLicense = FALSE, fNewFile = FALSE, fSecondWindow = FALSE;
  COLORREF crBtnFace, crHighLight, crWindow;
  HMENU hMenu;
  LPITEMIDLIST pid;
  LPTSTR lpszModule, ppszHistory[10];
  MSG msg;
  TCHAR **ppszArgv;
  WNDCLASS wc;

  InitCommonControls ();
  /* ja:変数の初期化 */
  lpszOpenPath = GetSpecificFolderPath (&FOLDERID_Documents);
  lpszSavePath = StringDuplicate (lpszOpenPath);
  lpszModule = GetModuleFileNameNew (hInstance);
  lpszHelpFile = PathRenameExtensionNew (lpszModule, _T(".chm"));
  MemoryFree (lpszModule);
  crBtnFace = GetSysColor (COLOR_BTNFACE);
  crGrayText = GetSysColor (COLOR_GRAYTEXT);
  crHighLight = GetSysColor (COLOR_HIGHLIGHT);
  crHighLightText = GetSysColor (COLOR_HIGHLIGHTTEXT);
  crWindow = GetSysColor (COLOR_WINDOW);
  crWindowText = GetSysColor (COLOR_WINDOWTEXT);
  for (i = 0; i < 256; i++)
    ppszCode[i] = LoadTextA (hInstance, IDS_CODE00 + i);
  MemorySet (ppszHistory, 0, sizeof (ppszHistory));

  /* ja:コマンドラインの解析 */
  ppszArgv = MakeArgument (GetCommandLine ());
  if (!ppszArgv || !ppszArgv[0])
    {
      MessageBox (NULL, _T("MakeArgument"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }

  /* ja:レジストリの扱いをコマンドラインから取得する */
  for (i = 1; ppszArgv[i]; i++)
    if (((ppszArgv[i])[0] == '-' || (ppszArgv[i])[0] == '/')
                        && (int)CharUpper ((LPTSTR)(ppszArgv[i])[1]) == 'Q')
      nRegStat = IsCharNumeric ((ppszArgv[i])[2]) && (ppszArgv[i])[3] == '\0'
                                                ? (ppszArgv[i])[2] - '0' : 3;

  if (nRegStat & REG_STAT_READ)
    {
      HKEY hKey;
      RECT rc0;

      rc0.left = LONG_MIN;
      if (RegOpenKeyEx (HKEY_CURRENT_USER,
                                    _T("Software\\maid.org\\Text maid"),
                                    0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS)
        {
          /* ja:レジストリから読み出す */
          HKEY hKeySub;

          RegGetValueEx (hKey, _T("CodeDef"), &nCodeDef, sizeof (int));
          RegGetValueEx (hKey, _T("Filter"), &dwFilter, sizeof (DWORD));
          RegGetValueEx (hKey, _T("History"), &nHistory, sizeof (int));
          RegGetValueEx (hKey, _T("NewFile"), &fNewFile, sizeof (BOOL));
          RegGetValueEx (hKey, _T("Second"), &fSecondWindow, sizeof (BOOL));
          RegGetValueEx (hKey, _T("Zoomed"), &fZoomed, sizeof (BOOL));
          MemoryFree (lpszOpenPath);
          lpszOpenPath = RegGetString (hKey, _T("OpenPath"));
          MemoryFree (lpszSavePath);
          lpszSavePath = RegGetString (hKey, _T("SavePath"));
          RegGetValueEx (hKey, _T("Rect"), &rc0, sizeof (RECT));
          /* ja:ファイルタイプ */
          RegGetValueEx (hKey, _T("FileType"), &nFileType, sizeof (int));
          lpFileType = MemoryAlloc (nFileType * sizeof (FILETYPE));
          for (i = 0; i < nFileType; i++)
            {
              DWORD dwData;
              LONG lResult;
              LPTSTR lpszName;

              wasprintf (&lpszName, _T("FileType%04d"), i);
              lResult = RegOpenKeyEx (hKey, lpszName, 0, KEY_ALL_ACCESS,
                                                                    &hKeySub);
              MemoryFree (lpszName);
              if (lResult != ERROR_SUCCESS)
                break;
              lpFileType[i].nID = nTypeCount++;
              lpFileType[i].lpszText = RegGetString (hKeySub, _T("Text"));
              lpFileType[i].lpszExt = RegGetString (hKeySub, _T("Ext"));
              RegGetValueEx (hKeySub, _T("Margin"),
                            &lpFileType[i].nMargin, sizeof (int));
              RegGetValueEx (hKeySub, _T("Tab"),
                            &lpFileType[i].nTab, sizeof (int));
              if (RegQueryValueEx (hKeySub, _T("LogFont"), NULL, NULL,
                                            NULL, &dwData) == ERROR_SUCCESS)
                if (dwData == sizeof (LOGFONT))
                  {
                    RegGetValueEx (hKeySub, _T("LogFont"),
                                    &lpFileType[i].LogFont, sizeof (LOGFONT));
                  }
#ifdef UNICODE
                else if (dwData == sizeof (LOGFONTA))
                  {
                    LOGFONTA lfa;

                    RegGetValueEx (hKeySub, _T("LogFont"),
                                                    &lfa, sizeof (LOGFONTA));
                    MemoryCopy (&lpFileType[i].LogFont, &lfa,
                            sizeof (LOGFONTA) - LF_FACESIZE * sizeof (CHAR));
                    MultiByteToWideChar (CP_ACP, 0, lfa.lfFaceName, -1,
                                lpFileType[i].LogFont.lfFaceName, LF_FACESIZE);
                  }
#else /* not UNICODE */
                else if (dwData == sizeof (LOGFONTW))
                  {
                    LOGFONTA lfw;

                    RegGetValueEx (hKeySub, _T("LogFont"),
                                                    &lfw, sizeof (LOGFONTW));
                    MemoryCopy (&lpFileType[i].LogFont, &lfw,
                            sizeof (LOGFONTA) - LF_FACESIZE * sizeof (WCHAR));
                    WideCharToMultiByte (CP_ACP, 0, lfw.lfFaceName, -1,
                                lpFileType[i].LogFont.lfFaceName, LF_FACESIZE,
                                                                NULL, NULL);
                  }
#endif /* not UNICODE */
              RegGetValueEx (hKeySub, _T("Color"),
                                lpFileType[i].crColor, sizeof (COLORREF) * 12);
              RegGetValueEx (hKeySub, _T("Associate"),
                                &lpFileType[i].fAssociate, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("AutoIndent"),
                                &lpFileType[i].fAutoIndent, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Code"),
                                &lpFileType[i].fCode, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("CRLF"), 
                                &lpFileType[i].fCRLF, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("EOF"),
                                &lpFileType[i].fEOF, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Limit"),
                                &lpFileType[i].fLimit, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("OverWrite"),
                                &lpFileType[i].fOverWrite, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Recycle"),
                                &lpFileType[i].fRecycle, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Space"),
                                &lpFileType[i].fSpace, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("SysColor"),
                                &lpFileType[i].fSysColor, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("TabConv"),
                                &lpFileType[i].fTabConv, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Gline"),
                                &lpFileType[i].fGline, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Mline"),
                                &lpFileType[i].fMline, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Uline"),
                                &lpFileType[i].fUline, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("Vline"),
                                &lpFileType[i].fVline, sizeof (BOOL));
              RegGetValueEx (hKeySub, _T("RetCode"),
                                &lpFileType[i].uRetCode, sizeof (UINT));
              if (RegQueryValueEx (hKeySub, _T("Negotiate"), NULL, NULL,
                                                NULL, &dwData) == ERROR_SUCCESS
                                                    && dwData == sizeof (BOOL))
                {
                  RegGetValueEx (hKeySub, _T("Negotiate"),
                                &lpFileType[i].fNegotiate, sizeof (BOOL));
                  RegGetValueEx (hKeySub, _T("CharSet"),
                                &lpFileType[i].dwCharSet, sizeof (DWORD));
                }
              else
                {
                  UINT uCharSet;

                  lpFileType[i].fNegotiate = lpFileType[i].uRetCode == 0;
                  if (!lpFileType[i].fNegotiate)
                    lpFileType[i].uRetCode--;
                  RegGetValueEx (hKeySub, _T("Auto"),
                                    &lpFileType[i].dwCharSet, sizeof (DWORD));
                  RegGetValueEx (hKeySub, _T("CharSet"),
                                    &uCharSet, sizeof (UINT));
                  if (lpFileType[i].dwCharSet == 0)
                    lpFileType[i].dwCharSet = uCharSet;
                }
              if (lpFileType[i].dwCharSet == 0)
                lpFileType[i].dwCharSet = 0x2135467;
              RegCloseKey (hKeySub);
            }
          nFileType = i;
          /* ja:検索 */
          RegGetValueEx (hKey, _T("FindNum"), &nFind, sizeof (int));
          RegGetValueEx (hKey, _T("FindArrow"), &bFindArrow, sizeof (BOOL));
          RegGetValueEx (hKey, _T("FindCase"), &bFindCase, sizeof (BOOL));
          RegGetValueEx (hKey, _T("FindWidth"), &bFindWidth, sizeof (BOOL));
          if (nFind > 0 && RegOpenKeyEx (hKey, _T("Find"),
                                0, KEY_ALL_ACCESS, &hKeySub) == ERROR_SUCCESS)
            {
              for (i = 0; i < nFind; i++)
                {
                  LPTSTR lpszName;

                  wasprintf (&lpszName, _T("Find%02d"), i);
                  ppszFind[i] = RegGetString (hKeySub, lpszName);
                  MemoryFree (lpszName);
                  if (!ppszFind[i] || *ppszFind[i] == '\0')
                    {
                      MemoryFree (ppszFind[i]);
                      break;
                    }
                }
              nFind = i;
              RegCloseKey (hKeySub);
            }
          /* ja:置換 */
          RegGetValueEx (hKey, _T("ReplaceNum"),  &nReplace, sizeof (int));
          RegGetValueEx (hKey, _T("ReplaceArrow"),
                                                &bReplaceArrow, sizeof (BOOL));
          RegGetValueEx (hKey, _T("ReplaceCase"),
                                                &bReplaceCase, sizeof (BOOL));
          RegGetValueEx (hKey, _T("ReplaceWidth"),
                                                &bReplaceWidth, sizeof (BOOL));
          if (nReplace > 0 && RegOpenKeyEx (hKey, _T("Replace"),
                                0, KEY_ALL_ACCESS, &hKeySub) == ERROR_SUCCESS)
            {
              for (i = 0; i < nReplace; i++)
                {
                  LPTSTR lpszName;

                  wasprintf (&lpszName, _T("Replace%02d"), i);
                  ppszReplace[i] = RegGetString (hKeySub, lpszName);
                  MemoryFree (lpszName);
                  if (!ppszReplace[i] || *ppszReplace[i] == '\0')
                    {
                      MemoryFree (ppszReplace[i]);
                      break;
                    }
                }
              nReplace = i;
              RegCloseKey (hKeySub);
            }
          for (i = 0; i < nHistory; i++)
            {
              LPTSTR lpszName;

              wasprintf (&lpszName, _T("History%d"), i);
              ppszHistory[i] = RegGetString (hKey, lpszName);
              MemoryFree (lpszName);
              if (!ppszHistory[i] || *ppszHistory[i] == '\0')
                {
                  MemoryFree (ppszHistory[i]);
                  ppszHistory[i] = NULL;
                  break;
                }
            }
          RegCloseKey (hKey);
          fLicense = TRUE;
        }
      else if (RegOpenKeyEx (HKEY_CURRENT_USER,
                                    _T("Software\\IwamotoKazuki\\Text maid"),
                                    0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS)
        {
          /* ja:レジストリから読み出す */
          DWORD dwStat;
          HKEY hKeySub;

          RegGetValueEx (hKey, _T("code"), &nCodeDef, sizeof (int));
          RegGetValueEx (hKey, _T("filter"), &dwFilter, sizeof (DWORD));
          RegGetValueEx (hKey, _T("findstat"), &dwStat, sizeof (DWORD));
          RegGetValueEx (hKey, _T("history"), &nHistory, sizeof (int));
          RegGetValueEx (hKey, _T("newfile"), &fNewFile, sizeof (BOOL));
          RegGetValueEx (hKey, _T("prev"), &fSecondWindow, sizeof (BOOL));
          RegGetValueEx (hKey, _T("zoomed"), &fZoomed, sizeof (BOOL));
          MemoryFree (lpszOpenPath);
          lpszOpenPath = RegGetString (hKey, _T("openpath"));
          MemoryFree (lpszSavePath);
          lpszSavePath = RegGetString (hKey, _T("savepath"));
          RegGetValueEx (hKey, _T("rect"), &rc0, sizeof (RECT));
          bFindArrow = !(dwStat & 4);
          bFindCase = dwStat & 1;
          bFindWidth = dwStat & 2;
          bReplaceArrow = !(dwStat & 32);
          bReplaceCase = dwStat & 8;
          bReplaceWidth = dwStat & 16;
          /* ja:ファイルタイプ */
          RegGetValueEx (hKey, _T("ftnum"), &nFileType, sizeof (int));
          lpFileType = MemoryAlloc (nFileType * sizeof (FILETYPE));
          for (i = 0; i < nFileType; i++)
            {
              DWORD dwData;
              LONG lResult;
              LPTSTR lpszName;

              wasprintf (&lpszName, _T("FILETYPE%d"), i);
              lResult = RegOpenKeyEx (hKey, lpszName, 0, KEY_ALL_ACCESS,
                                                                    &hKeySub);
              MemoryFree (lpszName);
              if (lResult != ERROR_SUCCESS)
                break;
              lpFileType[i].nID = nTypeCount++;
              lpFileType[i].lpszText = RegGetString (hKeySub, _T("text"));
              lpFileType[i].lpszExt = RegGetString (hKeySub, _T("ext"));
              RegGetValueEx (hKeySub, _T("margin"),
                                &lpFileType[i].nMargin, sizeof (int));
              RegGetValueEx (hKeySub, _T("tab"),
                                &lpFileType[i].nTab, sizeof (int));
              RegGetValueEx (hKeySub, _T("auto"),
                                &lpFileType[i].dwCharSet, sizeof (DWORD));
              RegGetValueEx (hKeySub, _T("view"),
                                &dwStat, sizeof (DWORD));
              if (RegQueryValueEx (hKeySub, _T("logfont"), NULL, NULL,
                                            NULL, &dwData) == ERROR_SUCCESS)
                if (dwData == sizeof (LOGFONT))
                  {
                    RegGetValueEx (hKeySub, _T("logfont"),
                                    &lpFileType[i].LogFont, sizeof (LOGFONT));
                  }
#ifdef UNICODE
                else if (dwData == sizeof (LOGFONTA))
                  {
                    LOGFONTA lfa;

                    RegGetValueEx (hKeySub, _T("logfont"),
                                                    &lfa, sizeof (LOGFONTA));
                    MemoryCopy (&lpFileType[i].LogFont, &lfa,
                            sizeof (LOGFONTA) - LF_FACESIZE * sizeof (CHAR));
                    MultiByteToWideChar (CP_ACP, 0, lfa.lfFaceName, -1,
                                lpFileType[i].LogFont.lfFaceName, LF_FACESIZE);
                  }
#else /* not UNICODE */
                else if (dwData == sizeof (LOGFONTW))
                  {
                    LOGFONTA lfw;

                    RegGetValueEx (hKeySub, _T("logfont"),
                                                    &lfw, sizeof (LOGFONTW));
                    MemoryCopy (&lpFileType[i].LogFont, &lfw,
                            sizeof (LOGFONTA) - LF_FACESIZE * sizeof (WCHAR));
                    WideCharToMultiByte (CP_ACP, 0, lfw.lfFaceName, -1,
                    lpFileType[i].LogFont.lfFaceName, LF_FACESIZE, NULL, NULL);
                  }
#endif /* not UNICODE */
              RegGetValueEx (hKeySub, _T("color"),
                                lpFileType[i].crColor, sizeof (COLORREF) * 12);
              RegCloseKey (hKeySub);
              lpFileType[i].fAssociate = dwStat & 64;
              lpFileType[i].fAutoIndent = dwStat & 2048;
              lpFileType[i].fCode = dwStat & 16;
              lpFileType[i].fCRLF = dwStat & 4;
              lpFileType[i].fEOF = dwStat & 128;
              lpFileType[i].fLimit = dwStat & 1024;
              lpFileType[i].fOverWrite = dwStat & 4096;
              lpFileType[i].fRecycle = dwStat & 256;
              lpFileType[i].fSpace = dwStat & 2;
              lpFileType[i].fSysColor = dwStat & 512;
              lpFileType[i].fTabConv = dwStat & 524288;
              lpFileType[i].fGline = dwStat & 1;
              lpFileType[i].fMline = dwStat & 8;
              lpFileType[i].fUline = dwStat & 32;
              lpFileType[i].fVline = dwStat & 8192;
              lpFileType[i].uRetCode = dwStat >> 14 & 3;
              lpFileType[i].fNegotiate = lpFileType[i].uRetCode == 0;
              if (!lpFileType[i].fNegotiate)
                lpFileType[i].uRetCode--;
              if (lpFileType[i].dwCharSet == 0)
                {
                  UINT uCharSet;

                  uCharSet = dwStat >> 16 & 7;
                  lpFileType[i].dwCharSet = uCharSet != 0
                                                        ? uCharSet : 0x2135467;
                }
            }
          nFileType = i;
          /* ja:検索 */
          RegGetValueEx (hKey, _T("findnum"), &nFind, sizeof (int));
          if (nFind > 0 && RegOpenKeyEx (hKey, _T("find"), 0, KEY_ALL_ACCESS,
                                                    &hKeySub) == ERROR_SUCCESS)
            {
              for (i = 0; i < nFind; i++)
                {
                  LPTSTR lpszName;

                  wasprintf (&lpszName, _T("findstr%02d"), i);
                  ppszFind[i] = RegGetString (hKeySub, lpszName);
                  MemoryFree (lpszName);
                  if (!ppszFind[i] || *ppszFind[i] == '\0')
                    {
                      MemoryFree (ppszFind[i]);
                      break;
                    }
                }
              nFind = i;
              RegCloseKey (hKeySub);
            }
          /* ja:置換 */
          RegGetValueEx (hKey, _T("repnum"), &nReplace, sizeof (int));
          if (nReplace > 0 && RegOpenKeyEx (hKey, _T("replace"),
                                0, KEY_ALL_ACCESS, &hKeySub) == ERROR_SUCCESS)
            {
              for (i = 0; i < nReplace; i++)
                {
                  LPTSTR lpszName;

                  wasprintf (&lpszName, _T("repstr%02d"), i);
                  ppszReplace[i] = RegGetString (hKeySub, lpszName);
                  MemoryFree (lpszName);
                  if (!ppszReplace[i] || *ppszReplace[i] == '\0')
                    {
                      MemoryFree (ppszReplace[i]);
                      break;
                    }
                }
              nReplace = i;
              RegCloseKey (hKeySub);
            }
          for (i = 0; i < nHistory; i++)
            {
              LONG lResult;
              LPTSTR lpszName;

              wasprintf (&lpszName, _T("history%d"), i);
              ppszHistory[i] = RegGetString (hKey, lpszName);
              MemoryFree (lpszName);
              if (!ppszHistory[i] || *ppszHistory[i] == '\0')
                {
                  MemoryFree (ppszHistory[i]);
                  ppszHistory[i] = NULL;
                  break;
                }
            }
          RegCloseKey (hKey);
        }
      if (rc0.left != LONG_MIN)
        {
          RECT rc1, rc2;

          rc1.left = rc1.top = 0;
          rc1.right = GetSystemMetrics (SM_CXSCREEN);
          rc1.bottom = GetSystemMetrics (SM_CYSCREEN);
          if (IntersectRect (&rc2, &rc0, &rc1)
                            && rc2.left < rc2.right && rc2.top < rc2.bottom)
            {
              nLeft = rc2.left;
              nTop = rc2.top;
              nRight = rc2.right - nLeft;
              nBottom = rc2.bottom - nTop;
            }
          else
            {
              nLeft = nTop = nRight = nBottom = CW_USEDEFAULT;
            }
        }
    }
  if (!fLicense && DialogBoxGUI (hInstance, MAKEINTRESOURCE (DIALOG_1),
                                                NULL, LicenseDlgProc) != IDOK)
    {
      /* ja:ライセンスへの同意が得られなかった時、終了 */
      return 0;
    }

  /* ja:コマンドライン */
  for (i = 1; ppszArgv[i]; i++)
    if ((ppszArgv[i])[0] == '-' || (ppszArgv[i])[0] == '/')
      switch ((int)CharUpper ((LPTSTR)(ppszArgv[i])[1]))
        {
          case 'C':
            if ((ppszArgv[i])[2] == '\0')
              nCodeDef = ' ';
            else
              nCodeDef = StringToInteger (ppszArgv[i] + 2, NULL, 10);
            break;
          case 'F':
            if ((ppszArgv[i])[2] == '\0')
              dwFilter = 0;
            else
              dwFilter = StringToInteger (ppszArgv[i] + 2, NULL, 10);
            break;
          case 'H':
            nHistory = IsCharNumeric ((ppszArgv[i])[2])
                    && (ppszArgv[i])[3] == '\0' ? (ppszArgv[i])[2] - '0' : 4;
            break;
          case 'L':
            nInitLine = StringToInteger (ppszArgv[i] + 2, NULL, 10);
            break;
          case 'N':
            fNewFile = (ppszArgv[i])[2] - '0';
            break;
          case 'Q':
            break;
          case 'S':
            if ((ppszArgv[i])[2] == '\0')
              {
                bFindArrow = TRUE;
                bFindCase = FALSE;
                bFindWidth=FALSE;
                bReplaceArrow = TRUE;
                bReplaceCase = FALSE;
                bReplaceWidth = FALSE;
              }
            else
              {
                DWORD dwStat;

                dwStat = StringToInteger (ppszArgv[i] + 2, NULL, 10);
                bFindArrow = !(dwStat & 4);
                bFindCase = dwStat & 1;
                bFindWidth = dwStat & 2;
                bReplaceArrow = !(dwStat & 32);
                bReplaceCase = dwStat & 8;
                bReplaceWidth = dwStat & 16;
              }
            break;
          case 'W':
            if ((ppszArgv[i])[2] == '\0')
              {
                nLeft = nTop = nRight = nBottom = CW_USEDEFAULT;
              }
            else
              {
                LPTSTR *ppszArray;

                ppszArray = StringSplitDelimiter (ppszArgv[i] + 2, _T(","));
                if (ppszArray)
                  {
                    int j;

                    for (j = 0; ppszArray[j]; j++);
                    if (j == 4)
                      {
                        nLeft = StringToInteger (ppszArray[0], NULL, 10);
                        nTop = StringToInteger (ppszArray[1], NULL, 10);
                        nRight = StringToInteger (ppszArray[2], NULL, 10);
                        nBottom = StringToInteger (ppszArray[3], NULL, 10);
                      }
                    MemoryFree (ppszArray);
                  }
              }
            break;
          case 'X':
            fSecondWindow = (ppszArgv[i])[2] - '0';
            break;
          case 'Z':
            fZoomed = (ppszArgv[i])[2] - '0';
            break;
          default:
            {
              LPTSTR lpszText;

              lpszText = LoadText (hInstance, IDS_OTHER_COMMAND);
              MessageBox (NULL, lpszText,
                                APPLICATION, MB_OK | MB_ICONSTOP);
              MemoryFree (lpszText);
            }
            return 0;
        }

  if (!fSecondWindow && (hWndMain = FindWindow (MAINCLASS, NULL)))
    {
      ATOM atom;

      if (IsIconic (hWndMain))
        ShowWindow (hWndMain, SW_RESTORE);
      else
        SetForegroundWindow (hWndMain);
      atom = GlobalAddAtom (_T("-L0"));
      if (atom != 0)
        {
          SendMessage (hWndMain, WM_USER, atom, 0);
          GlobalDeleteAtom (atom);
        }
      for (i = 1; ppszArgv[i]; i++)
        if ((ppszArgv[i])[0] == '-' || (ppszArgv[i])[0] == '/')
          {
            atom = GlobalAddAtom (ppszArgv[i]);
            if (atom != 0)
              {
                SendMessage (hWndMain, WM_USER, atom, 0);
                GlobalDeleteAtom (atom);
              }
          }
      for (i = 1; ppszArgv[i]; i++)
        if ((ppszArgv[i])[0] != '-' && (ppszArgv[i])[0] != '/')
          {
            LPTSTR lpszFile;

            lpszFile = GetLongFileNew (ppszArgv[i]);
            atom = GlobalAddAtom (lpszFile);
            MemoryFree (lpszFile);
            if (atom != 0)
              {
                SendMessage (hWndMain, WM_USER, atom, 0);
                GlobalDeleteAtom (atom);
              }
          }
      return 0;
    }

  if (nFileType <= 0)
    {
      HDC hDC;
      LPTSTR lpszText;
      const static int nObject[] = {DEFAULT_GUI_FONT, ANSI_VAR_FONT,
            SYSTEM_FONT, ANSI_FIXED_FONT, SYSTEM_FIXED_FONT, OEM_FIXED_FONT};

      nFileType = 1;
      lpFileType = MemoryAlloc (nFileType * sizeof (FILETYPE));
      lpFileType[0].nID = nTypeCount++;
      lpFileType[0].lpszText = LoadText (hInstance, IDS_OTHER_FILTER);
      lpFileType[0].lpszExt = StringDuplicate (_T("*"));
      lpFileType[0].nMargin = 80;
      lpFileType[0].nTab = 8;
      lpFileType[0].fAssociate = TRUE;
      lpFileType[0].fSysColor = TRUE;
      lpFileType[0].fNegotiate = TRUE;
      lpFileType[0].dwCharSet = 0x2135467;
      /* ja:フォント */
      hDC = CreateCompatibleDC (NULL);
      for (i = 0; i < n_elements (nObject); i++)
        {
          HFONT hFont;

          hFont = GetStockObject (nObject[i]);
          if (hFont)
            {
              BOOL fFont;
              TEXTMETRIC TextMetric;

              hFont = SelectObject (hDC, hFont);
              fFont = GetTextMetrics (hDC, &TextMetric) && GetTextFace (hDC,
                            LF_FACESIZE, lpFileType[0].LogFont.lfFaceName) > 0;
              hFont = SelectObject (hDC,hFont);
              if (fFont)
                {
                  lpFileType[0].LogFont.lfHeight = TextMetric.tmHeight;
                  lpFileType[0].LogFont.lfWidth = TextMetric.tmAveCharWidth;
                  lpFileType[0].LogFont.lfEscapement =
                  lpFileType[0].LogFont.lfOrientation = 0;
                  lpFileType[0].LogFont.lfWeight = TextMetric.tmWeight;
                  lpFileType[0].LogFont.lfItalic = TextMetric.tmItalic;
                  lpFileType[0].LogFont.lfUnderline = TextMetric.tmUnderlined;
                  lpFileType[0].LogFont.lfStrikeOut = TextMetric.tmStruckOut;
                  lpFileType[0].LogFont.lfCharSet = TextMetric.tmCharSet;
                  lpFileType[0].LogFont.lfOutPrecision = OUT_DEFAULT_PRECIS;
                  lpFileType[0].LogFont.lfClipPrecision = CLIP_DEFAULT_PRECIS;
                  lpFileType[0].LogFont.lfQuality = DEFAULT_QUALITY;
                  lpFileType[0].LogFont.lfPitchAndFamily
                                                = TextMetric.tmPitchAndFamily;
                  break;
                }
            }
        }
      DeleteDC (hDC);
      if (i >= n_elements (nObject))
        SystemParametersInfo (SPI_GETICONTITLELOGFONT,
                sizeof (LOGFONT), &lpFileType[0].LogFont, SPIF_UPDATEINIFILE);
      lpFileType[0].LogFont.lfPitchAndFamily
                = lpFileType[0].LogFont.lfPitchAndFamily & ~15 | FIXED_PITCH;
      lpFileType[0].crColor[ 0] = crWindowText;
      lpFileType[0].crColor[ 1] = crWindow;
      lpFileType[0].crColor[ 2] =
      lpFileType[0].crColor[ 3] =
      lpFileType[0].crColor[ 4] =
      lpFileType[0].crColor[ 5] =
      lpFileType[0].crColor[ 6] = crGrayText;
      lpFileType[0].crColor[ 7] = crBtnFace;
      lpFileType[0].crColor[ 8] = crHighLightText;
      lpFileType[0].crColor[ 9] = crHighLight;
      lpFileType[0].crColor[10] = RGB (  0,   0,   0);
      lpFileType[0].crColor[11] = RGB (128, 128, 128);
    }

  wc.style         = 0;
  wc.lpfnWndProc   = WndProc;
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = LoadIcon (hInstance, MAKEINTRESOURCE (ICON_1));
  wc.hCursor       = LoadCursor (NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)(COLOR_APPWORKSPACE + 1);
  wc.lpszMenuName  = NULL;
  wc.lpszClassName = MAINCLASS;
  RegisterClass (&wc);

  wc.style         = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
  wc.cbClsExtra    = 0;
  wc.lpfnWndProc   = TextWndProc;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = LoadIcon (hInstance, MAKEINTRESOURCE (ICON_1));
  wc.hCursor       = LoadCursor (NULL, IDC_IBEAM);
  wc.hbrBackground = NULL;
  wc.lpszMenuName  = NULL;
  wc.lpszClassName = TEXTCLASS;
  RegisterClass (&wc);

  hWndMain = CreateWindowEx (WS_EX_ACCEPTFILES, MAINCLASS,
                            APPLICATION, WS_CLIPCHILDREN |WS_OVERLAPPEDWINDOW,
                            nLeft, nTop, nRight, nBottom, NULL,
                            LoadMenu (hInstance, MAKEINTRESOURCE (MENU_1)),
                                                            hInstance, NULL);
  if (!hWndMain)
    {
      MessageBox (NULL, _T("CreateWindowEx"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }
  hAccel = LoadAccelerators (hInstance, MAKEINTRESOURCE (MENU_1));
  ShowWindow (hWndMain, nCmdShow);
  UpdateWindow (hWndMain);

  hMenu = GetSubMenu (GetMenu (hWndMain), 0);
  for (i = 0; ppszHistory[i]; i++)
    {
      LPTSTR lpszText;

      wasprintf (&lpszText, _T("&%d %s"), i, ppszHistory[i]);
      InsertMenu (hMenu, i + MENUFILE - 1, MF_BYPOSITION, i + 200, lpszText);
      MemoryFree (lpszText);
    }
  if (i != 0)
    {
      InsertMenu (hMenu, i + MENUFILE - 1,
                                        MF_BYPOSITION | MF_SEPARATOR, 0, NULL);
      DrawMenuBar (hWndMain);
    }
  for (i = 0; ppszHistory[i]; i++)
    MemoryFree (ppszHistory[i]);

  for (i = 1; ppszArgv[i]; i++)
    if ((ppszArgv[i])[0] != '-' && (ppszArgv[i])[0] != '/')
      {
        HWND hWnd;

        fNewFile = FALSE;
        hWnd = OpenEditFile (ppszArgv[i]);
        if (!hWnd)
          {
            MessageBox (hWndMain, ppszArgv[i],
                                    APPLICATION, MB_OK | MB_ICONSTOP);
            break;
          }
        if (nInitLine != 0)
          JumpOperation (hWnd, nInitLine);
      }
  if (fNewFile)
    OpenEditFile (NULL);

  MemoryFree (ppszArgv);

  while (GetMessage (&msg, NULL, 0, 0))
    if (!TranslateMDISysAccel (hWndClient, &msg)
                            && !TranslateAccelerator (hWndMain, hAccel, &msg))
      {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
      }
  return 0;
}
