/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "replace.h"
#include <windowsx.h>
#include "find.h"
#include "resource.h"
#include "wcommon.h"


int nReplace = 0;               /* ja:登録されている置換文字列 */
BOOL bReplaceArrow = TRUE;      /* ja:TRUE:下へ検索 */
BOOL bReplaceCase = FALSE;      /* ja:TRUE:大文字小文字を区別する */
BOOL bReplaceWidth = FALSE;     /* ja:TRUE:全角半角を区別する */
LPTSTR ppszReplace[FINDNUM];    /* ja:置換する文字列 */


/******************************************************************************
*                                                                             *
* ja:置換ダイアログ群                                                         *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
ReplaceDlgProc (HWND   hDlg,
                UINT   uMsg,
                WPARAM wParam,
                LPARAM lParam)
{
  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i;
          LPREPLACEDLG lpDlg;

          SetWindowLongPtr (hDlg, DWLP_USER, lParam);
          lpDlg = (LPREPLACEDLG)lParam;
          /* ja:チェックボックスの設定 */
          CheckDlgButton (hDlg, IDC_CHECKBOX91,
                                lpDlg->bCase ? BST_CHECKED : BST_UNCHECKED);
          CheckDlgButton (hDlg, IDC_CHECKBOX92,
                                lpDlg->bWidth ? BST_CHECKED : BST_UNCHECKED);
          /* ja:コンボボックスの設定 */
          for (i = 0; i < nFind; i++)
            ComboBoxItem_AddString (hDlg, IDC_COMBOBOX91, ppszFind[i]);
          if (nFind > 0)
            {
              ComboBoxItem_SetCurSel (hDlg, IDC_COMBOBOX91, 0);
              /* ja:コントロールの表示状態 */
              EnableDlgItem (hDlg, IDC_PUSHBUTTON91, TRUE);
              EnableDlgItem (hDlg, IDOK, TRUE);
            }
          for (i = 0; i < nReplace; i++)
            ComboBoxItem_AddString (hDlg, IDC_COMBOBOX92, ppszReplace[i]);
          if (nReplace > 0)
            ComboBoxItem_SetCurSel (hDlg, IDC_COMBOBOX92, 0);
          CheckRadioButton (hDlg, IDC_RADIOBUTTON91, IDC_RADIOBUTTON92,
                        lpDlg->bArrow ? IDC_RADIOBUTTON92 : IDC_RADIOBUTTON91);
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
            case IDC_PUSHBUTTON91:
              {
                LPREPLACEDLG lpDlg;

                lpDlg = (LPREPLACEDLG)GetWindowLongPtr (hDlg, DWLP_USER);
                lpDlg->bCase = IsDlgButtonChecked (hDlg, IDC_CHECKBOX91)
                                                                == BST_CHECKED;
                lpDlg->bWidth = IsDlgButtonChecked (hDlg, IDC_CHECKBOX92)
                                                                == BST_CHECKED;
                lpDlg->bArrow = IsDlgButtonChecked (hDlg, IDC_RADIOBUTTON92)
                                                                == BST_CHECKED;
                lpDlg->lpszSrc
                            = ComboBoxItem_GetTextNew (hDlg, IDC_COMBOBOX91);
                lpDlg->lpszDst
                            = ComboBoxItem_GetTextNew (hDlg, IDC_COMBOBOX92);
              }
            case IDCANCEL:
              EndDialog (hDlg, LOWORD (wParam));
              break;
            case IDC_COMBOBOX91:
              {
                int nLength;

                switch (HIWORD (wParam))
                  {
                    case CBN_EDITCHANGE:
                      nLength = ComboBox_GetTextLength ((HWND)lParam);
                      break;
                    case CBN_SELCHANGE:
                      nLength = 1;
                      break;
                    default: return TRUE;
                  }
                /* ja:コントロールの表示状態 */
                EnableDlgItem (hDlg, IDC_PUSHBUTTON91, nLength > 0);
                EnableDlgItem (hDlg, IDOK, nLength > 0);
              }
          }
        return TRUE;
    }
  return FALSE;
}
