/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __REPINFO_H__
#define __REPINFO_H__


#include "tmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:置換情報ダイアログ群                                                     *
*                                                                             *
******************************************************************************/
typedef struct _REPINFODLG
{
  BOOL bArrow;                  /* ja:TRUE:下へ検索 */
  BOOL bCase;                   /* ja:TRUE:大文字小文字を区別する */
  BOOL bWidth;                  /* ja:TRUE:全角半角を区別する */
  LPCTSTR lpszSrc, lpszDst;
  POINT ptStart, ptEnd;
} REPINFODLG, *PREPINFODLG, *LPREPINFODLG;


BOOL CALLBACK
RepinfoDlgProc (HWND   hDlg,
                UINT   uMsg,
                WPARAM wParam,
                LPARAM lParam);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __REPINFO_H__ */
