/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WMISC_H__
#define __WMISC_H__


#include "wcommon.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:ドロップされたファイル名を取得する
    hDrop,ファイル名構造体のハンドル
    iFile,インデックス
      RET,ファイル名,NULL:エラー                                            */
LPWSTR WINAPI
DragQueryFileNewW (HDROP hDrop,
                   UINT  iFile);


/*  ja:ドロップされたファイル名を取得する
    hDrop,ファイル名構造体のハンドル
    iFile,インデックス
      RET,ファイル名,NULL:エラー                                            */
LPSTR WINAPI
DragQueryFileNewA (HDROP hDrop,
                   UINT  iFile);


/*  ja:ウインドウのクラス名を取得する
    hWnd,ウインドウ
     RET,クラス名,NULL:エラー                                               */
LPWSTR WINAPI
GetClassNameNewW (HWND hWnd);


/*  ja:ウインドウのクラス名を取得する
    hWnd,ウインドウ
     RET,クラス名,NULL:エラー                                               */
LPSTR WINAPI
GetClassNameNewA (HWND hWnd);


/*  ja:ウインドウのテキストを取得する
    hWnd,ウインドウ
     RET,テキスト,NULL:エラー                                               */
LPWSTR WINAPI
GetWindowTextNewW (HWND hWnd);


/*  ja:ウインドウのテキストを取得する
    hWnd,ウインドウ
     RET,テキスト,NULL:エラー                                               */
LPSTR WINAPI
GetWindowTextNewA (HWND hWnd);


/*  ja:メニュー項目のテキストを取得する
      hMenu,メニューのハンドル
    uIDItem,メニュー項目の識別子
      uFlag,オプション
        RET,テキスト,NULL:エラー                                               */
LPWSTR WINAPI
GetMenuStringNewW (HMENU hMenu,
                   UINT  uIDItem,
                   UINT  uFlag);


/*  ja:メニュー項目のテキストを取得する
      hMenu,メニューのハンドル
    uIDItem,メニュー項目の識別子
      uFlag,オプション
        RET,テキスト,NULL:エラー                                               */
LPSTR WINAPI
GetMenuStringNewA (HMENU hMenu,
                   UINT  uIDItem,
                   UINT  uFlag);


/*  ja:グローバルアトムに関連付けられている文字列を取得する
    nAtom,アトム識別子
      RET,文字列,NULL:エラー                                                */
LPWSTR WINAPI
GlobalGetAtomNameNewW (ATOM nAtom);


/*  ja:グローバルアトムに関連付けられている文字列を取得する
    nAtom,アトム識別子
      RET,文字列,NULL:エラー                                                */
LPSTR WINAPI
GlobalGetAtomNameNewA (ATOM nAtom);


/*  ja:リソースから文字列を読み込む
    hInstance,インスタンス
          uID,ID
          RET,文字列                                                        */
LPWSTR WINAPI
LoadTextW (HINSTANCE hInstance,
           UINT      uID);


/*  ja:リソースから文字列を読み込む
    hInstance,インスタンス
          uID,ID
          RET,文字列                                                        */
LPSTR WINAPI
LoadTextA (HINSTANCE hInstance,
           UINT      uID);


/*  ja:スクロールバーを設定する
     hWnd,ウインドウ
     nBar,スクロールバータイプ
     nMin,最小値
     nMax,最大値
    nPage,ページ
     nPos,位置                                                              */
VOID WINAPI
SetScrollBar (HWND hWnd,
              int  nBar,
              int  nMin,
              int  nMax,
              UINT nPage,
              int  nPos);


#ifdef UNICODE
# define DragQueryFileNew DragQueryFileNewW
# define GetClassNameNew GetClassNameNewW
# define GetWindowTextNew GetWindowTextNewW
# define GetMenuStringNew GetMenuStringNewW
# define GlobalGetAtomNameNew GlobalGetAtomNameNewW
# define LoadText LoadTextW
#else /* not UNICODE */
# define DragQueryFileNew DragQueryFileNewA
# define GetClassNameNew GetClassNameNewA
# define GetWindowTextNew GetWindowTextNewA
# define GetMenuStringNew GetMenuStringNewA
# define GlobalGetAtomNameNew GlobalGetAtomNameNewA
# define LoadText LoadTextA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WMISC_H__ */
