/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "wndtext.h"
#include <commctrl.h>
#include <shlwapi.h>
#include "abort.h"
#include "common.h"
#include "dialog.h"
#include "edit.h"
#include "file.h"
#include "find.h"
#include "general.h"
#include "history.h"
#include "imectrl.h"
#include "jump.h"
#include "other.h"
#include "print.h"
#include "property.h"
#include "reload.h"
#include "resource.h"
#include "repinfo.h"
#include "replace.h"
#include "valchr.h"


/******************************************************************************
*                                                                             *
* ja:eLXgEChE֐Q                                                 *
*                                                                             *
******************************************************************************/
LRESULT CALLBACK
TextWndProc (HWND   hWnd,
             UINT   uMsg,
             WPARAM wParam,
             LPARAM lParam)
{
  static BOOL fDblClk = FALSE;

  switch (uMsg)
    {
      case WM_CREATE:/* ja:EChEꂽ */
        {
          HDC hDC;
          LOGFONT logfont;
          LPTEXTWND ptw;
          SHFILEINFO shfi;
          TEXTMETRIC tm;

          ptw = (LPTEXTWND)((LPMDICREATESTRUCT)
                        (((LPCREATESTRUCT)lParam)->lpCreateParams))->lParam;
          SetWindowLong (hWnd, 0, (LONG)ptw);
          if (!ptw->fSysColor)
            {
              if (!(ptw->hBrushWindow = CreateSolidBrush(ptw->crColor[1]))
                    || !(ptw->hBrushSpace
                                        = CreateSolidBrush (ptw->crColor[3]))
                    || !(ptw->hBrushCrlf
                                        = CreateSolidBrush (ptw->crColor[4]))
                    || !(ptw->hBrushHighLight
                                        = CreateSolidBrush (ptw->crColor[9])))
                {
                  MessageBox (hWnd, _T("CreateSolidBrush"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  DestroyWindow (hWndMain);
                  return 0;
                }
              if (!(ptw->hPenTab = CreatePen (PS_SOLID, 0, ptw->crColor[5]))
                    || !(ptw->hPenMargin
                                = CreatePen (PS_SOLID, 0, ptw->crColor[6]))
                    || !(ptw->hPenGrid
                                = CreatePen (PS_SOLID, 0, ptw->crColor[7])))
                {
                  MessageBox (hWnd, _T("CreatePen"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  DestroyWindow (hWndMain);
                  return 0;
                }
            }
          logfont = ptw->lf;
          logfont.lfHeight /= 2;
          if (!(ptw->hFont = CreateFontIndirect (&ptw->lf))
                            || !(ptw->hFontsm = CreateFontIndirect (&logfont)))
            {
              MessageBox (hWnd, _T("CreateFontIndirect"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWndMain);
              return 0;
            }
          hDC = GetDC (hWnd);
          if (!hDC)
            {
              MessageBox (hWnd, _T("GetDC"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWndMain);
              return 0;
            }
          ptw->hFont = SelectObject (hDC, ptw->hFont);
          if (!GetTextMetrics (hDC, &tm))
            {
              MessageBox (hWnd, _T("GetTextMetrics"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              SelectObject (hDC, ptw->hFont);
              ReleaseDC (hWnd, hDC);
              DestroyWindow (hWndMain);
              return 0;
            }
          ptw->hFont = SelectObject (hDC, ptw->hFont);
          if (ReleaseDC (hWnd, hDC) != 1)
            {
              MessageBox (hWnd, _T("ReleaseDC"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWndMain);
              return 0;
            }
          ptw->nFontSize = (tm.tmHeight + 1) / 2;
          if (SHGetFileInfo (ptw->szFile, 0, &shfi, sizeof (SHFILEINFO),
                    SHGFI_ICON | SHGFI_LARGEICON | SHGFI_USEFILEATTRIBUTES))
            {
              SendMessage (hWnd, WM_SETICON, TRUE,
                                                (LPARAM)CopyIcon (shfi.hIcon));
              DestroyIcon (shfi.hIcon);
            }
          if (SHGetFileInfo (ptw->szFile, 0, &shfi, sizeof (SHFILEINFO),
                    SHGFI_ICON | SHGFI_SMALLICON | SHGFI_USEFILEATTRIBUTES))
            {
              SendMessage (hWnd, WM_SETICON, FALSE,
                                                (LPARAM)CopyIcon (shfi.hIcon));
              DestroyIcon (shfi.hIcon);
            }
          SetFocus (hWnd);
        }
        return 0;
      case WM_SIZE:/* ja:TCYύXꂽ */
        {
          int sx, sy, nMax;
          LPTEXTWND ptw;

          ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
          ptw->siWnd.cx = LOWORD (lParam);
          ptw->siWnd.cy = HIWORD (lParam);
          nMax = GetWidthMax (ptw);
          sx = max (ptw->siWnd.cx / ptw->nFontSize, 1);
          sy = max (ptw->siWnd.cy / (ptw->nFontSize * 2), 1);
          if (ptw->ptTop.x > nMax - sx + 1)
            ptw->ptTop.x = max (nMax - sx + 1, 0);
          if (ptw->ptTop.y > ptw->nMax - sy)
            ptw->ptTop.y = max (ptw->nMax - sy, 0);
          SetScrollBar (hWnd, SB_HORZ, 0, nMax, sx, ptw->ptTop.x);
          SetScrollBar (hWnd, SB_VERT, 0, ptw->nMax - 1, sy, ptw->ptTop.y);
          DrawCaret (hWnd);
        }
        break;
      case WM_PAINT:/* ja:` */
        {
          int y, nBkMode;
          COLORREF crTextColor, crText, crCtrl, crMbcs, crCrlf, crSelc;
          HBRUSH hBrush, hBrushOld;
          HPEN hPenOld;
          LPLINEBUF p;
          LPTEXTWND ptw;
          PAINTSTRUCT ps;
          POINT ptStart, ptEnd;

          ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
         if (!BeginPaint (hWnd, &ps))
           {
              MessageBox (hWnd, _T("BeginPaint"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWndMain);
              return 0;
            }
          if (ptw->ptSelect.x < 0)
            {
              /* ja:I͈͂ȂƂ */
              ptStart.x=-1;
            }
          else if (ptw->ptSelect.y < ptw->ptCursor.y
                                        || ptw->ptSelect.y == ptw->ptCursor.y
                                        && ptw->ptSelect.x < ptw->ptCursor.x)
            {
              /* ja:I͈͂Ƃ */
              ptStart = ptw->ptSelect;
              ptEnd.x = GetAlignPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
              ptEnd.y = ptw->ptCursor.y;
            }
          else
            {
              /* ja:I͈͂Ƃ */
              ptStart.x = GetAlignPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
              ptStart.y = ptw->ptCursor.y;
              ptEnd = ptw->ptSelect;
            }
          ptw->hFont = SelectObject (ps.hdc, ptw->hFont);
          nBkMode = SetBkMode (ps.hdc, TRANSPARENT);
          crTextColor = GetTextColor (ps.hdc);
          if (ps.fErase)/* ja:wi */
            FillRect (ps.hdc, &ps.rcPaint,
                            ptw->fSysColor ? hBrushWindow : ptw->hBrushWindow);
          if (ptw->fGline)
            {
              /* ja:Obh */
              int x, y;

              hPenOld = SelectObject (ps.hdc, ptw->fSysColor
                                                ? hPenGrid : ptw->hPenGrid);
              for (x = ptw->nFontSize - 1; x < ptw->siWnd.cx;
                                                        x += ptw->nFontSize)
                {
                  MoveToEx (ps.hdc, x, 0, NULL);
                  LineTo (ps.hdc, x, ptw->siWnd.cy);
                }
              for (y = ptw->nFontSize * 2 - 1;
                                    y < ptw->siWnd.cy; y += ptw->nFontSize * 2)
                {
                  MoveToEx (ps.hdc, 0, y, NULL);
                  LineTo (ps.hdc, ptw->siWnd.cx, y);
                }
              SelectObject (ps.hdc, hPenOld);
            }
          if (ptw->fVline)
            {
              /* ja:c */
              int x;

              hPenOld = SelectObject (ps.hdc, ptw->fSysColor
                                                ? hPenGrid : ptw->hPenGrid);
              for (x = (ptw->nTab - ptw->ptTop.x % ptw->nTab)
                                                        * ptw->nFontSize - 1;
                            x < ptw->siWnd.cx; x += ptw->nFontSize * ptw->nTab)
                {
                  MoveToEx (ps.hdc, x, 0, NULL);
                  LineTo (ps.hdc, x, ptw->siWnd.cy);
                }
              SelectObject (ps.hdc, hPenOld);
            }
          if (ptw->fMline)
            {
              /* ja:E}[W */
              int x;

              hPenOld = SelectObject (ps.hdc, ptw->fSysColor
                                                ? hPenGray : ptw->hPenMargin);
              x = (ptw->nMargin - ptw->ptTop.x) * ptw->nFontSize;
              MoveToEx (ps.hdc, x, 0, NULL);
              LineTo (ps.hdc, x, ptw->siWnd.cy);
              SelectObject (ps.hdc, hPenOld);
            }
          if (ptw->fSysColor)
            {
              /* ja:VXeF */
              hBrush = hBrushHighLight;
              if (ptw->fCRLF)
                hBrushOld = SelectObject (ps.hdc, hBrushGray);
              hPenOld = SelectObject (ps.hdc, hPenGray);
              crText = crWindowText;
              crCtrl =
              crMbcs =
              crCrlf = crGrayText;
              crSelc = crHighLightText;
            }
          else
            {
              /* ja:JX^F */
              hBrush = ptw->hBrushHighLight;
              if (ptw->fCRLF)
                hBrushOld = SelectObject (ps.hdc, ptw->hBrushCrlf);
              hPenOld = SelectObject (ps.hdc, ptw->hPenTab);
              crText = ptw->crColor[0];
              crCtrl = ptw->crColor[2];
              crMbcs = ptw->crColor[3];
              crCrlf = ptw->crColor[4];
              crSelc = ptw->crColor[8];
            }
          for (y = 0,
                p = GetLineBuffer (&ptw->lpStart, &ptw->nOff, ptw->ptTop.y);
                                        y <= ps.rcPaint.bottom && p;
                                        y += ptw->nFontSize * 2, p = p->next)
            {
              int x, nDataPos = 0;

              if (y + ptw->nFontSize * 2 < ps.rcPaint.top)
                continue;
              x = -ptw->ptTop.x * ptw->nFontSize;
              while (x <= ps.rcPaint.right && nDataPos < p->nLength)
                {
                  RECT rc;

                  if (x + max (ptw->nTab, 2) * ptw->nFontSize
                                                            < ps.rcPaint.left)
                    {
                      /* ja:̕\ȂvZ */
                      if (p->lpszText[nDataPos] == '\t')
                        {
                          x = (((x / ptw->nFontSize + ptw->ptTop.x)
                                / ptw->nTab + 1) * ptw->nTab - ptw->ptTop.x)
                                                            * ptw->nFontSize;
                          nDataPos++;
                        }
                      else if (nDataPos + 1 == p->nLength
                                                || !IsDBCSLeadByteEx(CP_SJIS,
                                                        p->lpszText[nDataPos]))
                        {
                          x += ptw->nFontSize;
                          nDataPos++;
                        }
                      else
                        {
                          x += ptw->nFontSize * 2;
                          nDataPos += 2;
                        }
                      continue;
                    }
                  if (ptStart.x >= 0 && (ptStart.y == ptEnd.y
                    ? ptStart.y == ptw->ptTop.y + y / (ptw->nFontSize * 2)
                        && ptStart.x <= ptw->ptTop.x + x / ptw->nFontSize
                        && ptw->ptTop.x + x / ptw->nFontSize < ptEnd.x
                    : ptStart.y < ptw->ptTop.y + y / (ptw->nFontSize * 2)
                        && ptw->ptTop.y + y / (ptw->nFontSize * 2) < ptEnd.y
                        || ptStart.y == ptw->ptTop.y + y / (ptw->nFontSize * 2)
                        && ptStart.x <= ptw->ptTop.x + x / ptw->nFontSize
                        || ptEnd.y == ptw->ptTop.y + y / (ptw->nFontSize * 2)
                        && ptw->ptTop.x + x / ptw->nFontSize < ptEnd.x))
                    {
                      /* ja:I͈͓ */
                      rc.left = x;
                      rc.top = y;
                      rc.bottom = y + ptw->nFontSize * 2;
                      SetTextColor (ps.hdc, crSelc);
                    }
                  else
                    {
                      /* ja:I͈͊O */
                      rc.left = -1;
                      SetTextColor (ps.hdc, crText);
                    }
                  if (p->lpszText[nDataPos] == '\t')
                    {
                      /* ja:^u */
                      rc.right = (((x / ptw->nFontSize + ptw->ptTop.x)
                                                            / ptw->nTab + 1)
                                * ptw->nTab - ptw->ptTop.x) * ptw->nFontSize;
                      if (rc.left != -1)/* ja:I */
                        FillRect (ps.hdc, &rc, hBrush);
                      SetTextColor (ps.hdc, crCtrl);
                      if (ptw->fUline)
                        {
                          /* ja: */
                          MoveToEx (ps.hdc,
                                        x, y + ptw->nFontSize * 2 - 1, NULL);
                          LineTo (ps.hdc,
                                        rc.right, y + ptw->nFontSize * 2 - 1);
                        }
                      if (ptw->fCode)
                        {
                          /* ja:R[h */
                          ptw->hFontsm = SelectObject (ps.hdc, ptw->hFontsm);
                          TextOutA (ps.hdc, x, y,
                                    lpszCode[(BYTE)p->lpszText[nDataPos]], 1);
                          TextOutA (ps.hdc,
                                    x + ptw->nFontSize / 2, y + ptw->nFontSize,
                                lpszCode[(BYTE)p->lpszText[nDataPos]] + 1, 1);
                          ptw->hFontsm = SelectObject (ps.hdc, ptw->hFontsm);
                        }
                      nDataPos++;
                    }
                  else if (nDataPos == p->nLength - 1
                        || !IsDBCSLeadByteEx (CP_SJIS, p->lpszText[nDataPos]))
                    {
                      /* ja:1oCg */
                      rc.right = x + ptw->nFontSize;
                      if (rc.left != -1)/* ja:I */
                        FillRect (ps.hdc, &rc, hBrush);
                      if (!IsCharControl (p->lpszText[nDataPos]))
                        {
                          /* ja:ʏ1 */
                          TextOutA (ps.hdc, x, y, p->lpszText + nDataPos, 1);
                        }
                      else
                        {
                          /* ja:Rg[R[h */
                          int nLength;
                          LPSTR lpszText;

                          SetTextColor (ps.hdc, crCtrl);/* ja:DF */
                          lpszText = lpszCode[(BYTE)p->lpszText[nDataPos]];
                          nLength = lstrlenA (lpszText);
                          if (nLength == 1)
                            {
                              /* ja:1oCg1 */
                              TextOutA (ps.hdc, x, y, lpszText, 1);
                            }
                          else
                            {
                              ptw->hFontsm = SelectObject (ps.hdc,
                                                                ptw->hFontsm);
                              if (nLength == 2)
                                {
                                  /* ja:1oCg2 */
                                  if (IsDBCSLeadByteEx (CP_SJIS, *lpszText))
                                    {
                                      /* ja:Sp1 */
                                      TextOutA (ps.hdc, x,
                                                        y + ptw->nFontSize / 2,
                                                                lpszText, 2);
                                    }
                                  else
                                    {
                                      /* ja:p2 */
                                      TextOutA (ps.hdc, x, y, lpszText, 1);
                                      TextOutA (ps.hdc,x + ptw->nFontSize / 2,
                                        y + ptw->nFontSize, lpszText + 1, 1);
                                    }
                                }
                              else if (nLength == 3)
                                {
                                  /* ja:1oCg3 */
                                  if (!IsDBCSLeadByteEx (CP_SJIS, lpszText[0])
                                    && IsDBCSLeadByteEx (CP_SJIS, lpszText[1]))
                                    {
                                      /* ja:p+Sp */
                                      TextOutA (ps.hdc, x, y, lpszText, 1);
                                      TextOutA (ps.hdc, x, y + ptw->nFontSize,
                                                            lpszText + 1, 2);
                                    }
                                  else
                                    {
                                      /* ja:Sp+p p+p+p */
                                      TextOutA (ps.hdc, x, y, lpszText, 2);
                                      TextOutA (ps.hdc,x + ptw->nFontSize / 2,
                                        y + ptw->nFontSize, lpszText + 2, 1);
                                    }
                                }
                              else
                                {
                                  /* ja:1oCg4 */
                                  TextOutA (ps.hdc, x, y, lpszText,2 );
                                  TextOutA (ps.hdc, x, y + ptw->nFontSize,
                                                            lpszText + 2, 2);
                                }
                              ptw->hFontsm = SelectObject (ps.hdc,
                                                                ptw->hFontsm);
                            }
                        }
                      nDataPos++;
                    }
                  else
                    {
                      /* ja:2oCg */
                      rc.right = x + ptw->nFontSize * 2;
                      if (rc.left != -1)/* ja:I */
                        FillRect (ps.hdc, &rc, hBrush);
                      if (rc.left == -1 && ptw->fSpace
                                && GetCharType (p->lpszText + nDataPos, 2) & 8)
                        {
                          /* ja:SpXy[X */
                          rc.left = x + 1;
                          rc.top = y + 1;
                          rc.bottom = y + ptw->nFontSize * 2;
                          FillRect (ps.hdc, &rc, ptw->fSysColor
                                            ? hBrushGray : ptw->hBrushSpace);
                        }
                      else
                        {
                          TextOutA (ps.hdc, x, y, p->lpszText + nDataPos, 2);
                        }
                      nDataPos += 2;
                    }
                  x = rc.right;
                }
              if (nDataPos == p->nLength && ptw->fCRLF)
                {
                  if (ptStart.x >= 0
                        && ptStart.y <= ptw->ptTop.y + y / (ptw->nFontSize * 2)
                        && ptw->ptTop.y + y / (ptw->nFontSize * 2) < ptEnd.y)
                    {
                      /* ja:I */
                      RECT rc;

                      rc.left = x;
                      rc.top = y;
                      rc.right = x + ptw->nFontSize;
                      rc.bottom = y + ptw->nFontSize * 2;
                      FillRect (ps.hdc, &rc, hBrush);
                    }
                  hPenNull = SelectObject (ps.hdc, hPenNull);
                  if (!p->next)
                    {
                      /* ja:t@C̍Ō */
                      Ellipse (ps.hdc, x + ptw->nFontSize / 6,
                                        y + ptw->nFontSize * 2 / 3,
                                        x + ptw->nFontSize * 5 / 6,
                                        y + ptw->nFontSize * 4 / 3);
                    }
                  else
                    {
                      int nLength;
                      POINT pt[4];

                      if (p->fMargin)
                        {
                          /* ja:E}[Wɂs */
                          pt[0].x = pt[3].x = x + ptw->nFontSize / 6;
                          pt[0].y = pt[1].y = y + ptw->nFontSize * 2 / 3;
                          pt[1].x = pt[2].x = x + ptw->nFontSize * 5 / 6;
                          pt[2].y = pt[3].y = y + ptw->nFontSize * 4 / 3;
                          nLength = 4;
                        }
                      else
                        {
                          /* ja:ʏ̉s */
                          pt[0].x = x + ptw->nFontSize / 6;
                          pt[1].x = x + ptw->nFontSize * 5 / 6;
                          pt[0].y = pt[1].y = y + ptw->nFontSize * 2 / 3;
                          pt[2].x = x + ptw->nFontSize / 2;
                          pt[2].y = y + ptw->nFontSize * 4 / 3;
                          nLength = 3;
                        }
                      Polygon (ps.hdc,pt, nLength);
                    }
                  hPenNull = SelectObject (ps.hdc, hPenNull);
                }
            }
          SetBkMode (ps.hdc, nBkMode);
          SetTextColor (ps.hdc, crTextColor);
          if (ptw->fCRLF)
            SelectObject (ps.hdc, hBrushOld);
          SelectObject (ps.hdc, hPenOld);
          ptw->hFont = SelectObject (ps.hdc, ptw->hFont);
          EndPaint (hWnd, &ps);
        }
        return 0;
      case WM_SETFOCUS:
        {
          LPTEXTWND ptw;

          ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
          SetImeFont (hWnd, &ptw->lf);
          CreateCaret (hWnd, (HBITMAP)0,
                        uIns != 0 ? ptw->nFontSize : 2, ptw->nFontSize * 2);
          if (!DrawCaret (hWnd))
            return 0;
          ShowCaret (hWnd);
        }
        return 0;
      case WM_KILLFOCUS:
        DestroyCaret ();
        return 0;
      case WM_MDIACTIVATE:/* ja:MDIŃANeBuɂȂƂ */
        {
          LPTEXTWND ptw;

          ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
          if (hWnd == (HWND)lParam)
            {
              if (!SetMenuBar (ptw))
                return 0;
            }
          else
            {
              if (!SetMenuBar (NULL))
                return 0;
              SetImePos (hWnd, -1, -1);
              if (!SendMessage (hWndStat, SB_SETTEXT, 0, (LPARAM)_T("")))
                {
                  MessageBox (hWnd, _T("SB_SETTEXT"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  DestroyWindow (hWndMain);
                }
            }
        }
        return 0;
      case WM_MENUSELECT:/* ja:j[Iꂽ */
        {
          HMENU hMenu;
          UINT uIds[2] = {0, 0};

          hMenu = GetMenu (hWnd);
          if (!hMenu)
            {
              MessageBox (hWnd, _T("GetMenu"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWndMain);
              return 0;
            }
          MenuHelp (uMsg, wParam, lParam, hMenu, hInst, hWndStat, uIds);
        }
        return 0;
      case WM_HSCROLL:
        {
          int sx, nMax;
          LPTEXTWND ptw;
          POINT ptTop;

          ptw=(LPTEXTWND)GetWindowLong (hWnd, 0);
          ptTop = ptw->ptTop;
          sx = max (ptw->siWnd.cx / ptw->nFontSize, 1);
          switch (LOWORD (wParam))
            {
              case SB_LINELEFT:   ptw->ptTop.x--;     break;
              case SB_LINERIGHT:  ptw->ptTop.x++;     break;
              case SB_PAGELEFT:   ptw->ptTop.x -= sx; break;
              case SB_PAGERIGHT:  ptw->ptTop.x += sx; break;
              case SB_THUMBTRACK:
                {
                  SCROLLINFO si;

                  si.cbSize = sizeof (SCROLLINFO);
                  si.fMask = SIF_ALL;
                  if (!GetScrollInfo (hWnd, SB_HORZ, &si))
                    {
                      MessageBox (hWnd, _T("GetScrollInfo"),
                                            APPLICATION, MB_OK | MB_ICONSTOP);
                      DestroyWindow (hWndMain);
                      return 0;
                    }
                  ptw->ptTop.x = si.nTrackPos;
                }
                break;
              default: return 0;
            }
          nMax = GetWidthMax (ptw);
          if (ptw->ptTop.x < 0)
            ptw->ptTop.x = 0;
          else if (ptw->ptTop.x > nMax - sx + 1)
            ptw->ptTop.x = max (nMax - sx + 1, 0);
          HideCaret (hWnd);
          if (!MoveTextWindow (hWnd, &ptTop) || !DrawCaret (hWnd))
            return 0;
          ShowCaret (hWnd);
        }
        return 0;
      case WM_VSCROLL:
      case 0x020A:/* en:WM_MOUSEWHEEL: */
        {
          int sx, sy, nMax;
          LPTEXTWND ptw;
          POINT ptTop;

          ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
          ptTop = ptw->ptTop;
          sx = max (ptw->siWnd.cx / ptw->nFontSize, 1);
          sy = max (ptw->siWnd.cy / (ptw->nFontSize * 2), 1);
          if (uMsg == WM_VSCROLL)
            switch (LOWORD (wParam))
              {
                case SB_LINEUP:     ptw->ptTop.y--;     break;
                case SB_LINEDOWN:   ptw->ptTop.y++;     break;
                case SB_PAGEUP:     ptw->ptTop.y -= sy; break;
                case SB_PAGEDOWN:   ptw->ptTop.y += sy; break;
                case SB_THUMBTRACK:
                  {
                    SCROLLINFO si;

                    si.cbSize = sizeof (SCROLLINFO);
                    si.fMask = SIF_ALL;
                    if (!GetScrollInfo (hWnd, SB_VERT, &si))
                      {
                        MessageBox (hWnd, _T("GetScrollInfo"),
                                            APPLICATION, MB_OK | MB_ICONSTOP);
                        DestroyWindow (hWndMain);
                        return 0;
                      }
                    ptw->ptTop.y = si.nTrackPos;
                  }
                  break;
                default: return 0;
              }
          else/* en:WHEEL_DELTA=120 */
            ptw->ptTop.y -= (SHORT)HIWORD (wParam) * 4 / 120;
          if (ptw->ptTop.y < 0)
            ptw->ptTop.y = 0;
          else if (ptw->ptTop.y > ptw->nMax - sy)
            ptw->ptTop.y = max (ptw->nMax - sy, 0);
          nMax = GetWidthMax (ptw);
          if (ptw->ptTop.x > nMax - sx + 1)
            ptw->ptTop.x = max (nMax - sx + 1, 0);
          HideCaret (hWnd);
          if (!MoveTextWindow (hWnd, &ptTop) || !DrawCaret (hWnd))
            return 0;
          ShowCaret (hWnd);
        }
        return 0;
      case WM_LBUTTONDOWN:
        {
          BOOL fShift;
          POINT ptCursor;
          LPTEXTWND ptw;

          ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
          ptCursor = ptw->ptCursor;
          ptw->ptCursor.x = ptw->ptTop.x + LOWORD (lParam) / ptw->nFontSize;
          ptw->ptCursor.y = ptw->ptTop.y + HIWORD (lParam)
                                                        / (ptw->nFontSize * 2);
          fShift = GetKeyState (VK_SHIFT) & 0x8000;
          if (ptw->ptCursor.y < 0)
            ptw->ptCursor.y = 0;
          else if (ptw->ptCursor.y > ptw->nMax - 1)
            ptw->ptCursor.y = ptw->nMax - 1;
          if (ptw->ptCursor.x < GetWidth (&ptw->lpStart, &ptw->nOff,
                                                ptw->ptCursor.y, ptw->nTab))
            ptw->ptCursor.x = GetAlignPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
          if (ptw->ptSelect.x >= 0 && (!fShift
                                        || ptw->ptCursor.x == ptw->ptSelect.x
                                        && ptw->ptCursor.y == ptw->ptSelect.y))
            {
              HideCaret (hWnd);
              ClearSel (hWnd, &ptCursor, &ptw->ptSelect);
              ptw->ptSelect.x = -1;
              ShowCaret (hWnd);
              if (!SetMenuBar (ptw))
                return 0;
            }
          else if (fShift && (ptw->ptCursor.x != ptCursor.x
                                            || ptw->ptCursor.y != ptCursor.y))
            {
              HideCaret (hWnd);
              if (ptw->ptSelect.x < 0)
                {
                  ptw->ptSelect.x = GetAlignPos (&ptw->lpStart, &ptw->nOff,
                                    ptCursor.x, ptCursor.y, ptw->nTab, FALSE);
                  ptw->ptSelect.y = ptCursor.y;
                }
              ClearSel (hWnd, &ptCursor, &ptw->ptCursor);
              ShowCaret (hWnd);
              if (!SetMenuBar (ptw))
                return 0;
            }
          if (!DrawCaret (hWnd))
            return 0;
          SetCapture (hWnd);
        }
        return 0;
      case WM_LBUTTONUP:
        {
          int i = 0, j, nDataPos, ctype;
          LPLINEBUF p;
          LPTEXTWND ptw;
          MSG msg;

          while (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE))
            {
              TranslateMessage (&msg);
              DispatchMessage (&msg);
            }
          ReleaseCapture ();
          if (!fDblClk)
            return 0;
          /* ja:_uNbNƂPI */
          fDblClk = FALSE;
          ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
          if (ptw->ptSelect.x >= 0)
            return 0;
          p = GetLineBuffer (&ptw->lpStart, &ptw->nOff, ptw->ptCursor.y);
          if (p->nLength <= 0)
            return 0;
          j = nDataPos = GetDataPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
          if (nDataPos > 0)
            {
              /* ja:IJnʒu */
              LPBYTE lpbType;

              lpbType = MemoryAlloc (nDataPos * sizeof (BYTE));
              while (i < nDataPos)
                if (i + 1 < nDataPos
                                && IsDBCSLeadByteEx (CP_SJIS, p->lpszText[i]))
                  {
                    lpbType[i++] = 1;
                    lpbType[i++] = 2;
                  }
                else
                  {
                    lpbType[i++] = 0;
                  }
              if (nDataPos < p->nLength)
                {
                  int nLength;

                  nLength = nDataPos < p->nLength - 1 && IsDBCSLeadByteEx
                                    (CP_SJIS, p->lpszText[nDataPos]) ? 2 : 1;
                  ctype = GetCharType (p->lpszText + nDataPos, nLength);
                  if (ctype == -1)
                    {
                      MemoryFree (lpbType);
                      return 0;
                    }
                  j += nLength;
                }
              else
                {
                  int nLength;

                  nLength = lpbType[nDataPos - 1] == 2 ? 2 : 1;
                  nDataPos -= nLength;
                  ctype = GetCharType (p->lpszText + nDataPos, nLength);
                  if (ctype == -1)
                    {
                      MemoryFree (lpbType);
                      return 0;
                    }
                }
              for (i = nDataPos - 1; i >= 0; i--)
                {
                  int nLength, ct;

                  if (lpbType[i] >= 2)
                    continue;
                  nLength = lpbType[i] == 1 ? 2 : 1;
                  ct = GetCharType (p->lpszText + i, nLength);
                  if (ct == -1)
                    {
                      MemoryFree (lpbType);
                      return 0;
                    }
                  if (!(ctype & ct & 192) && ctype != ct)
                    {
                      i += nLength;
                      break;
                    }
                }
              MemoryFree (lpbType);
            }
          else
            {
              int nLength;

              nLength = p->nLength > 1
                        && IsDBCSLeadByteEx (CP_SJIS, p->lpszText[0]) ? 2 : 1;
              ctype = GetCharType (p->lpszText, nLength);
              if (ctype == -1)
                return 0;
              j += nLength;
            }
          /* ja:IIʒu */
          while (j < p->nLength)
            {
              int nLength, ct;

              nLength = j < p->nLength - 1
                        && IsDBCSLeadByteEx (CP_SJIS, p->lpszText[j]) ? 2 : 1;
              ct = GetCharType (p->lpszText + j, nLength);
              if (ct == -1)
                return 0;
              if (!(ctype & ct & 192) && ctype != ct)
                break;
              j += nLength;
            }
          ptw->ptSelect.x = GetScreenPos (&ptw->lpStart, &ptw->nOff,
                                                i, ptw->ptCursor.y, ptw->nTab);
          ptw->ptCursor.x = GetScreenPos (&ptw->lpStart, &ptw->nOff,
                                                j, ptw->ptCursor.y, ptw->nTab);
          ptw->ptSelect.y = ptw->ptCursor.y;
          if (ptw->ptSelect.x == ptw->ptCursor.x)
            ptw->ptSelect.x = -1;
          else if (SetMenuBar (ptw) && DrawCaret (hWnd))
            ClearSel (hWnd, &ptw->ptSelect, &ptw->ptCursor);
        }
        return 0;
      case WM_MOUSEMOVE:
        {
          int s, sx, sy;
          POINT ptCursor, ptTop;
          POINTS ps;
          LPTEXTWND ptw;

          if (!(wParam & MK_LBUTTON))
            return 0;
          ptw = (LPTEXTWND)GetWindowLong (hWnd,0);
          ptCursor = ptw->ptCursor;
          ptTop = ptw->ptTop;
          sx = max (ptw->siWnd.cx / ptw->nFontSize, 1);
          sy = max (ptw->siWnd.cy / (ptw->nFontSize * 2), 1);
          ps = MAKEPOINTS (lParam);
          if (ps.x < 0)
            ps.x = 0;
          else if (ps.x > ptw->siWnd.cx)
            ps.x = (SHORT)ptw->siWnd.cx;
          if (ps.y < 0)
            ps.y = 0;
          else if (ps.y > ptw->siWnd.cy)
            ps.y = (SHORT)ptw->siWnd.cy;
          /* ja:J[\OɂƂXN[ */
          if (sx > 1)
            {
              if ((SHORT)LOWORD (lParam) < 0 && ptw->ptTop.x > 0)
                ptw->ptTop.x--;
              else if ((SHORT)LOWORD (lParam) > ptw->siWnd.cx
                        && ptw->ptTop.x < GetWidth (&ptw->lpStart, &ptw->nOff,
                                        ptw->ptCursor.y, ptw->nTab) + 1 - sx)
                ptw->ptTop.x++;
            }
          if (sy > 1)
            {
              if ((SHORT)HIWORD (lParam) < 0 && ptw->ptTop.y > 0)
                ptw->ptTop.y--;
              else if ((SHORT)HIWORD (lParam) > ptw->siWnd.cy
                                            && ptw->ptTop.y < ptw->nMax - sy)
                ptw->ptTop.y++;
            }
          HideCaret (hWnd);
          if (!MoveTextWindow (hWnd, &ptTop))
            return 0;
          s = ps.x - ((ptw->ptSelect.x < 0 ? ptw->ptCursor.x : ptw->ptSelect.x)
                                            - ptw->ptTop.x) * ptw->nFontSize;
          if (s < ptw->nFontSize / 2 || ptw->nFontSize < s
                || (ptw->ptSelect.x < 0 ? ptw->ptCursor.y : ptw->ptSelect.y)
                                != ps.y / (ptw->nFontSize * 2) + ptw->ptTop.y)
            {
              if (ptw->ptSelect.x < 0)
                {
                  /* ja:VɑI */
                  ptw->ptSelect.x = GetAlignPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
                  ptw->ptSelect.y = ptw->ptCursor.y;
                }
              ptw->ptCursor.x = ps.x / ptw->nFontSize + ptw->ptTop.x;
              ptw->ptCursor.y = ps.y / (ptw->nFontSize * 2) + ptw->ptTop.y;
              if (ptw->ptCursor.y < 0)
                ptw->ptCursor.y = 0;
              else if (ptw->ptCursor.y > ptw->nMax - 1)
                ptw->ptCursor.y = ptw->nMax - 1;
              ptw->ptCursor.x = GetAlignPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
            }
          else if (ptw->ptSelect.x >= 0)
            {
              /* ja:I */
              ptw->ptCursor = ptw->ptSelect;
              ptw->ptSelect.x = -1;
            }
          if (ptw->ptSelect.x == ptw->ptCursor.x
                                        && ptw->ptSelect.y == ptw->ptCursor.y)
            ptw->ptSelect.x = -1;/* ja:Ȉ߂ƏI肪Ƃ */
          if ((ptw->ptCursor.x != ptCursor.x || ptw->ptCursor.y != ptCursor.y
                        || ptw->ptTop.x != ptTop.x || ptw->ptTop.y != ptTop.y)
                                    && (!SetMenuBar (ptw) || !DrawCaret (hWnd)
                            || !ClearSel (hWnd, &ptw->ptCursor, &ptCursor)))
            return 0;
          if ((ptw->ptTop.x != ptTop.x || ptw->ptTop.y != ptTop.y)
                                                    && !UpdateWindow (hWnd))
            {
              MessageBox (hWnd, _T("UpdateWindow"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWndMain);
              return 0;
            }
          ShowCaret (hWnd);
        }
        return 0;
      case WM_LBUTTONDBLCLK:
        fDblClk = TRUE;
        return 0;
      case WM_KEYDOWN:
        switch (wParam)
          {
            case VK_HOME:
            case VK_END:
            case VK_LEFT:
            case VK_RIGHT:
            case VK_UP:
            case VK_DOWN:
            case VK_PRIOR:
            case VK_NEXT:
              {
                int i, sx, sy, nCurPos, nScreenPos, nWidth;
                BOOL fCtrl;
                POINT ptCursor, ptTop, ptSelect;
                LPLINEBUF p;
                LPTEXTWND ptw;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                ptCursor = ptw->ptCursor;
                ptTop = ptw->ptTop;
                sx = max (ptw->siWnd.cx / ptw->nFontSize, 1);
                sy = max (ptw->siWnd.cy / (ptw->nFontSize * 2), 1);
                fCtrl = GetKeyState (VK_CONTROL) & 0x8000;
                switch (wParam)
                  {
                    case VK_HOME:
                      ptw->ptCursor.x = 0;
                      if (fCtrl)
                        ptw->ptCursor.y = 0;
                      break;
                    case VK_END:
                      if (fCtrl)
                        ptw->ptCursor.y = ptw->nMax - 1;
                      ptw->ptCursor.x = GetWidth (&ptw->lpStart, &ptw->nOff,
                                                ptw->ptCursor.y, ptw->nTab);
                      break;
                    case VK_LEFT:
                      ptw->ptCursor.x = GetAlignPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
                      if (ptw->ptCursor.x > 0)
                        {
                          nCurPos=-1;
                          if (fCtrl)
                            {
                              ptw->ptCursor.x = nCurPos < 0
                                    ? GetMovePos (&ptw->lpStart, &ptw->nOff,
                                            ptw->ptCursor.x, ptw->ptCursor.y,
                                                            ptw->nTab, FALSE)
                                    : nCurPos;
                            }
                          else
                            {
                              ptw->ptCursor.x = GetAlignPos (&ptw->lpStart,
                                                                &ptw->nOff,
                                        ptw->ptCursor.x - 1, ptw->ptCursor.y,
                                                            ptw->nTab, FALSE);
                            }
                        }
                      else if (ptw->ptCursor.y > 0)
                        {
                          /* ja:O̍s̍Ō */
                          ptw->ptCursor.y--;
                          ptw->ptCursor.x = GetWidth (&ptw->lpStart,
                                    &ptw->nOff, ptw->ptCursor.y, ptw->nTab);
                        }
                      break;
                    case VK_RIGHT:
                      nWidth = GetWidth (&ptw->lpStart, &ptw->nOff,
                                                ptw->ptCursor.y, ptw->nTab);
                      if (ptw->ptCursor.x < nWidth)
                        {
                          nCurPos = -1;
                          if (fCtrl)
                            {
                              ptw->ptCursor.x = nCurPos < 0
                                    ? GetMovePos (&ptw->lpStart, &ptw->nOff,
                                            ptw->ptCursor.x, ptw->ptCursor.y,
                                                            ptw->nTab, TRUE)
                                    : nCurPos;
                            }
                          else
                            {
                              ptw->ptCursor.x = GetAlignPos (&ptw->lpStart,
                                                                    &ptw->nOff,
                                        ptw->ptCursor.x + 1, ptw->ptCursor.y,
                                                            ptw->nTab, TRUE);
                            }
                        }
                      else if (ptw->ptCursor.y < ptw->nMax - 1)
                        {
                          /* ja:̍s̍ŏ */
                          ptw->ptCursor.x = 0;
                          ptw->ptCursor.y++;
                        }
                      break;
                    case VK_UP:
                      if (!fCtrl)
                        {
                          ptw->ptCursor.y--;
                        }
                      else if (ptw->ptTop.y > 0)
                        {
                          ptw->ptTop.y--;
                          if (ptw->ptCursor.y - sy + 1 > ptw->ptTop.y)
                            ptw->ptCursor.y--;
                        }
                      break;
                    case VK_DOWN:
                      if (!fCtrl)
                        {
                          ptw->ptCursor.y++;
                        }
                      else if (ptw->ptTop.y < ptw->nMax - sy)
                        {
                          ptw->ptTop.y++;
                          if (ptw->ptCursor.y < ptw->ptTop.y)
                            ptw->ptCursor.y++;
                        }
                      break;
                    case VK_PRIOR:
                      if (fCtrl)
                        {
                          ptw->ptCursor.y = ptw->ptTop.y;
                        }
                      else
                        {
                          ptw->ptCursor.y -= sy;
                          ptw->ptTop.y -= sy;
                        }
                      break;
                    case VK_NEXT:
                      if (fCtrl)
                        {
                          ptw->ptCursor.y = ptw->ptTop.y + sy - 1;
                        }
                      else
                        {
                          ptw->ptCursor.y += sy;
                          ptw->ptTop.y += sy;
                        }
                  }
                if (ptw->ptCursor.y < 0)
                  ptw->ptCursor.y = 0;
                else if (ptw->ptCursor.y > ptw->nMax - 1)
                  ptw->ptCursor.y = ptw->nMax - 1;
                if (ptw->ptTop.y < 0)
                  ptw->ptTop.y = 0;
                else if (ptw->ptTop.y > ptw->nMax - sy)
                  ptw->ptTop.y = max (ptw->nMax - sy, 0);
                if (ptw->ptCursor.x < ptw->ptTop.x)
                  ptw->ptTop.x = ptw->ptCursor.x;
                else if (ptw->ptCursor.x - sx + 1 > ptw->ptTop.x)
                  ptw->ptTop.x = ptw->ptCursor.x - sx + 1;
                if (ptw->ptCursor.y < ptw->ptTop.y)
                  ptw->ptTop.y = ptw->ptCursor.y;
                else if (ptw->ptCursor.y - sy + 1 > ptw->ptTop.y)
                  ptw->ptTop.y = ptw->ptCursor.y - sy + 1;
                ptSelect = ptw->ptSelect;
                if (GetKeyState (VK_SHIFT) & 0x8000)
                  {
                    if (ptw->ptSelect.x < 0)
                      {
                        /* ja:VɑI */
                        ptw->ptSelect.x = GetAlignPos (&ptw->lpStart,
                                                                    &ptw->nOff,
                                    ptCursor.x, ptCursor.y, ptw->nTab, FALSE);
                        ptw->ptSelect.y = ptCursor.y;
                      }
                    if (ptw->ptSelect.y == ptw->ptCursor.y
                            && ptw->ptSelect.x == GetAlignPos (&ptw->lpStart,
                                &ptw->nOff, ptw->ptCursor.x, ptw->ptCursor.y,
                                                            ptw->nTab, FALSE))
                      ptw->ptSelect.x = -1;/* ja:I͈͂Ƃ */
                  }
                else
                  {
                    /* ja:I */
                    ptw->ptSelect.x = -1;
                  }
                if (ptw->ptCursor.x == ptCursor.x
                                            && ptw->ptCursor.y == ptCursor.y
                        && ptw->ptTop.x == ptTop.x && ptw->ptTop.y == ptTop.y
                                            && ptw->ptSelect.x == ptSelect.x
                                            && ptw->ptSelect.y == ptSelect.y)
                  return 0;
                HideCaret (hWnd);
                if (ptw->ptSelect.x != ptSelect.x && !SetMenuBar (ptw)
                        || !DrawCaret (hWnd) || !MoveTextWindow (hWnd, &ptTop))
                  return 0;
                if (ptSelect.x >= 0 && ptw->ptSelect.x < 0)
                  {
                    if (!ClearSel (hWnd, &ptSelect, &ptCursor))
                      return 0;
                  }
                else if (ptw->ptSelect.x >= 0)
                  {
                    if (!ClearSel (hWnd, &ptw->ptCursor, &ptCursor))
                      return 0;
                  }
                ShowCaret (hWnd);
              }
              return 0;
            case VK_BACK:
              {
                LPDOING d;
                LPTEXTWND ptw;
                POINT ptSelect;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                ptSelect = ptw->ptSelect;
                if (ptw->ptSelect.x < 0)
                  {
                    ptw->ptCursor.x = GetAlignPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
                    if (ptw->ptCursor.x > 0)
                      {
                        if (GetKeyState (VK_CONTROL) & 0x8000)
                          {
                            if (ptw->ptSelect.x < 0)
                              ptw->ptSelect.x = GetMovePos (&ptw->lpStart,
                                                                    &ptw->nOff,
                                            ptw->ptCursor.x, ptw->ptCursor.y,
                                                            ptw->nTab, FALSE);
                          }
                        else
                          {
                            ptw->ptSelect.x = GetAlignPos (&ptw->lpStart,
                                                                    &ptw->nOff,
                                        ptw->ptCursor.x - 1, ptw->ptCursor.y,
                                                            ptw->nTab, FALSE);
                          }
                        ptw->ptSelect.y=ptw->ptCursor.y;
                      }
                    else if (ptw->ptCursor.y > 0)
                      {
                        /* ja:2̍s1ɂ */
                        ptw->ptSelect.y = ptw->ptCursor.y - 1;
                        ptw->ptSelect.x = GetWidth (&ptw->lpStart, &ptw->nOff,
                                                ptw->ptSelect.y, ptw->nTab);
                      }
                    else
                      {
                        return 0;
                      }
                  }
                d = EditOperation (hWnd, NULL, 0, FALSE, FALSE);
                if (!d)
                  return 0;
                d->next = ptw->lpUndo;
                ptw->lpUndo = d;
                if (DeleteList (&ptw->lpRedo) > 0 || !d->next
                                                            || ptSelect.x >= 0)
                  {
                    HideCaret (hWnd);
                    if (!SetMenuBar (ptw))
                      return 0;
                    ShowCaret (hWnd);
                  }
                ptw->fEdit = TRUE;
              }
              return 0;
            case VK_DELETE:
              {
                LPDOING d;
                LPTEXTWND ptw;
                POINT ptSelect;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                ptSelect = ptw->ptSelect;
                if (ptw->ptSelect.x < 0)
                  {
                    int nWidth;

                    nWidth = GetWidth (&ptw->lpStart, &ptw->nOff,
                                                ptw->ptCursor.y, ptw->nTab);
                    ptw->ptCursor.x = GetAlignPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
                    if (ptw->ptCursor.x < nWidth)
                      {
                        if (GetKeyState (VK_CONTROL) & 0x8000)
                          {
                            if (ptw->ptSelect.x < 0)
                                ptw->ptSelect.x = GetMovePos (&ptw->lpStart,
                                                                    &ptw->nOff,
                                            ptw->ptCursor.x, ptw->ptCursor.y,
                                                            ptw->nTab, TRUE);
                          }
                        else
                          {
                            ptw->ptSelect.x = GetAlignPos (&ptw->lpStart,
                                                                    &ptw->nOff,
                                        ptw->ptCursor.x + 1, ptw->ptCursor.y,
                                                            ptw->nTab, TRUE);
                          }
                        ptw->ptSelect.y = ptw->ptCursor.y;
                      }
                    else if (ptw->ptCursor.y < ptw->nMax - 1)
                      {
                        /* ja:2̍s1ɂ */
                        ptw->ptSelect.x = 0;
                        ptw->ptSelect.y = ptw->ptCursor.y + 1;
                      }
                    else
                      {
                        return 0;
                      }
                  }
                d = EditOperation (hWnd, NULL, 0, FALSE, FALSE);
                if (!d)
                  return 0;
                d->next = ptw->lpUndo;
                ptw->lpUndo = d;
                if (DeleteList (&ptw->lpRedo) > 0 || !d->next
                                                            || ptSelect.x >= 0)
                  {
                    HideCaret (hWnd);
                    if (!SetMenuBar (ptw))
                      return 0;
                    ShowCaret (hWnd);
                  }
                ptw->fEdit = TRUE;
              }
              return 0;
            case VK_ESCAPE:
              {
                int sx, sy;
                POINT ptTop;
                LPTEXTWND ptw;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                if (ptw->ptSelect.x < 0)
                  return 0;
                ptTop = ptw->ptTop;
                sx = max (ptw->siWnd.cx / ptw->nFontSize, 1);
                sy = max (ptw->siWnd.cy / (ptw->nFontSize * 2), 1);
                if (ptw->ptCursor.x < ptw->ptTop.x)
                  ptw->ptTop.x = ptw->ptCursor.x;
                else if (ptw->ptCursor.x - sx + 1 > ptw->ptTop.x)
                  ptw->ptTop.x = ptw->ptCursor.x - sx + 1;
                if (ptw->ptCursor.y < ptw->ptTop.y)
                  ptw->ptTop.y = ptw->ptCursor.y;
                else if (ptw->ptCursor.y - sy + 1 > ptw->ptTop.y)
                  ptw->ptTop.y = ptw->ptCursor.y - sy + 1;
                HideCaret (hWnd);
                if (!SetMenuBar (ptw) || !MoveTextWindow (hWnd, &ptTop)
                        || !ClearSel (hWnd, &ptw->ptSelect, &ptw->ptCursor))
                  return 0;
                ptw->ptSelect.x = -1;
                if (!DrawCaret (hWnd))
                  return 0;
                ShowCaret (hWnd);
              }
              return 0;
            case VK_TAB:
              {
                LPDOING d;
                LPTEXTWND ptw;
                POINT ptSelect;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                ptSelect = ptw->ptSelect;
                if (ptw->fTabConv ^ GetKeyState (VK_SHIFT) & 0x8000)
                  {
                    int n, nAlignPos;
                    LPSTR lpszText;

                    nAlignPos = GetAlignPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
                    n = (nAlignPos / ptw->nTab + 1) * ptw->nTab - nAlignPos;
                    lpszText = MemoryAlloc (n * sizeof (CHAR));
                    MemorySet (lpszText, ' ', n * sizeof (CHAR));
                    d = EditOperation (hWnd, lpszText, n, TRUE, FALSE);
                    MemoryFree (lpszText);
                  }
                else
                  {
                    d = EditOperation (hWnd, "\t", 1, TRUE, FALSE);
                  }
                if (!d)
                  return 0;
                d->next = ptw->lpUndo;
                ptw->lpUndo = d;
                if (DeleteList (&ptw->lpRedo) > 0 || !d->next
                                                            || ptSelect.x >= 0)
                  {
                    HideCaret (hWnd);
                    if (!SetMenuBar (ptw))
                      return 0;
                    ShowCaret (hWnd);
                  }
                ptw->fEdit = TRUE;
              }
              return 0;
            case VK_RETURN:
              {
                LPDOING d;
                LPTEXTWND ptw;
                POINT ptSelect;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                ptSelect = ptw->ptSelect;
                if (ptw->fAutoIndent)
                  {
                    int i, nDataPos;
                    LPLINEBUF p;
                    LPSTR lpszText;

                    nDataPos = GetDataPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
                    p = GetLineBuffer (&ptw->lpStart, &ptw->nOff,
                                                            ptw->ptCursor.y);
                    for (i = 0; i < nDataPos; i++)
                      if (p->lpszText[i] != '\t' && p->lpszText[i] != ' ')
                        break;
                    lpszText = MemoryAlloc ((i + 2) * sizeof (CHAR));
                    lpszText[0] = cCRLF[0];
                    lpszText[1] = cCRLF[1];
                    MemoryCopy (lpszText + 2, p->lpszText, i * sizeof (CHAR));
                    d = EditOperation (hWnd, lpszText, i + 2, TRUE, FALSE);
                    MemoryFree (lpszText);
                  }
                else
                  {
                    d = EditOperation (hWnd, cCRLF, 2, TRUE, FALSE);
                  }
                if (!d)
                  return 0;
                d->next = ptw->lpUndo;
                ptw->lpUndo = d;
                if (DeleteList (&ptw->lpRedo) > 0 || !d->next
                                                            || ptSelect.x >= 0)
                  {
                    HideCaret (hWnd);
                    if (!SetMenuBar (ptw))
                      return 0;
                    ShowCaret (hWnd);
                  }
                ptw->fEdit = TRUE;
              }
              return 0;
            case VK_INSERT:
              {
                LPTEXTWND ptw;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                uIns = (uIns == 0);
                CreateCaret (hWnd, (HBITMAP)0,
                        uIns != 0 ? ptw->nFontSize : 2, ptw->nFontSize * 2);
                if (!DrawCaret (hWnd))
                  return 0;
                ShowCaret (hWnd);
              }
          }
        return 0;
      case WM_CHAR:
        {
          static CHAR szText[2] = {'\0', '\0'};
          int nSize;
          LPDOING d;
          LPTEXTWND ptw;
          POINT ptSelect;
          TCHAR szCodePage[4096];
          UINT uCodePage;

          /* ja:̓P[̎擾 */
#ifdef UNICODE
          nSize = WideCharToMultiByte (CP_SJIS, 0, (LPCWSTR)&wParam, 1,
                                                        szText, 2, NULL, NULL);
          if (nSize <= 0 || nSize == 1 && IsCharControl (szText[0]))
            return 0;
#else /* not UNICODE */
          GetLocaleInfo (MAKELCID (LOWORD (GetKeyboardLayout (0)),
                                                                SORT_DEFAULT),
                                LOCALE_IDEFAULTANSICODEPAGE, szCodePage, 4096);
          StrVal (&uCodePage, szCodePage, 10);
          if (szText[0] == '\0')
            {
              if (IsDBCSLeadByteEx (uCodePage, (BYTE)wParam))
                {
                  szText[0] = wParam;
                  return 0;
                }
              else if (IsCharControl ((TCHAR)wParam))
                {
                  return 0;
                }
            }
          if (szText[0] == '\0')
            {
              szText[0] = (TCHAR)wParam;
              nSize = 1;
            }
          else
            {
              szText[1] = (TCHAR)wParam;
              nSize = 2;
            }
          if (uCodePage != CP_SJIS)
            {
              /* ja:R[hy[Wϊ */
              WCHAR wText;

              MultiByteToWideChar (uCodePage, 0, szText, nSize, &wText, 1);
              nSize = WideCharToMultiByte (CP_SJIS, 0, &wText, 1,
                                                        szText, 2, NULL, NULL);
            }
#endif /* not UNICODE */
          if (nSize <= 0)
            {
              szText[0] = '\0';
              return 0;
            }
          ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
          ptSelect = ptw->ptSelect;
          ptw->ptCursor.x = GetAlignPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
          if (ptw->ptSelect.x < 0 && uIns != 0)
            {
              ptw->ptSelect.x = GetAlignPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x + 1, ptw->ptCursor.y, ptw->nTab, TRUE);
              if (ptw->ptSelect.x <= ptw->ptCursor.x)
                ptw->ptSelect.x = -1;
              ptw->ptSelect.y = ptw->ptCursor.y;
            }
          d = EditOperation (hWnd, szText, nSize, TRUE, FALSE);
#ifndef UNICODE
          szText[0]='\0';
#endif /* not UNICODE */
          if (!d)
            return 1;
          d->next = ptw->lpUndo;
          ptw->lpUndo = d;
          if (DeleteList (&ptw->lpRedo) > 0 || !d->next || ptSelect.x >= 0)
            {
              HideCaret (hWnd);
              if (!SetMenuBar (ptw))
                return 0;
              ShowCaret (hWnd);
            }
          ptw->fEdit = TRUE;
        }
        return 0;
      case WM_CONTEXTMENU:
        {
          LPTEXTWND ptw;

          ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
          if (EnableMenuItem (hMenuPopup, CM_UNDO, ptw->lpUndo
                                    ? MF_ENABLED : MF_GRAYED) == 0xffffffff
                || EnableMenuItem (hMenuPopup, CM_CUT, ptw->ptSelect.x >= 0
                                    ? MF_ENABLED : MF_GRAYED) == 0xffffffff
                || EnableMenuItem (hMenuPopup, CM_COPY, ptw->ptSelect.x >= 0
                                    ? MF_ENABLED : MF_GRAYED) == 0xffffffff
                || EnableMenuItem (hMenuPopup, CM_PASTE, fClipBoard
                                    ? MF_ENABLED : MF_GRAYED) == 0xffffffff
                || EnableMenuItem (hMenuPopup, CM_DELETE, ptw->ptSelect.x >= 0
                                    ? MF_ENABLED : MF_GRAYED) == 0xffffffff)
            {
              MessageBox (hWnd, _T("EnableMenuItem"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWndMain);
              return 0;
            }
          TrackPopupMenu (hMenuPopup, TPM_RIGHTBUTTON,
                            LOWORD (lParam), HIWORD (lParam), 0, hWnd, NULL);
        }
        return 0;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case CM_SAVE:
              {
                LPTEXTWND ptw;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                if (!ptw->fCreate)
                  {
                    BOOL fResult;

                    fResult = !ptw->fOverWrite
                                            || !PathFileExists (ptw->szFile);
                    if (!fResult)
                      {
                        LPTSTR lpszFormat, lpszText;

                        lpszFormat = LoadText (hInst, IDS_PROMPT_WRITE);
                        wasprintf (&lpszText, lpszFormat, ptw->szFile);
                        MemoryFree (lpszFormat);
                        fResult = MessageBox (hWnd, lpszText, APPLICATION,
                                    MB_YESNO | MB_ICONINFORMATION) == IDYES;
                        MemoryFree (lpszText);
                      }
                    if (fResult && SaveTextFile (ptw->szFile,ptw))
                      {
                        ptw->fEdit = FALSE;
                        if (DeleteList (&ptw->lpUndo)
                                            + DeleteList (&ptw->lpRedo) > 0)
                          SetMenuBar (ptw);
                      }
                    return 0;
                  }
              }
            case CM_SAVEAS:
              {
                int i, nPos = 0;
                LPTEXTWND ptw;
                LPTSTR lpszName, lpszFilter = NULL;
                OPENFILENAME ofn;
                TCHAR szFile[MAX_PATH];

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                /* ja:tB^̐ݒ */
                for (i = 0; i < nFileType; i++)
                  {
                    int nLength;

                    nLength = lstrlen (lpFileType[i].szText) + 1;
                    lpszFilter = MemoryReAlloc (lpszFilter,
                                        (nPos + nLength + 1) * sizeof (TCHAR));
                    MemoryCopy (lpszFilter + nPos, lpFileType[i].szText,
                                                    nLength * sizeof (TCHAR));
                    nPos += nLength;
                    nLength = lstrlen (lpFileType[i].szExt) + 1;
                    lpszFilter = MemoryReAlloc (lpszFilter,
                                        (nPos + nLength + 1) * sizeof (TCHAR));
                    MemoryCopy (lpszFilter + nPos, lpFileType[i].szExt,
                                                    nLength * sizeof (TCHAR));
                    nPos += nLength;
                  }
                lpszFilter[nPos] = '\0';
                lpszName = PathFindFileName (ptw->szFile);
                if (lpszName)
                  lstrcpy (szFile, lpszName);
                else
                  szFile[0] = '\0';
                ofn.lStructSize =  sizeof(OPENFILENAME);
                ofn.hwndOwner = hWndClient;
                ofn.lpstrFilter = lpszFilter;
                ofn.lpstrCustomFilter = NULL;
                ofn.nFilterIndex = dwFilter + 1;
                ofn.lpstrFile = szFile;
                ofn.nMaxFile = MAX_PATH;
                ofn.lpstrFileTitle = NULL;
                ofn.lpstrInitialDir = szSavePath;
                ofn.lpstrTitle = NULL;
                ofn.Flags = OFN_HIDEREADONLY | OFN_NOCHANGEDIR
                                    | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST;
                ofn.lpstrDefExt = NULL;
                if (GetSaveFileName (&ofn))
                  {
                    dwFilter = ofn.nFilterIndex - 1;
                    MemoryCopy (szSavePath, szFile,
                                            ofn.nFileOffset * sizeof (TCHAR));
                    szSavePath[ofn.nFileOffset] = '\0';
                    if (SaveTextFile (szFile, ptw))
                      {
                        SHFILEINFO shfi;
                        TCHAR szTitle[MAX_PATH + 12];

                        ptw->fCreate = ptw->fEdit = FALSE;
                        DeleteEditFile (hWnd, ptw->szFile);
                        AddEditFile (hWnd,szFile, &ptw->nSame, szTitle);
                        lstrcpy (ptw->szFile, szFile);
                        DeleteList (&ptw->lpUndo);
                        DeleteList (&ptw->lpRedo);
                        if (SHGetFileInfo (ptw->szFile, 0, &shfi,
                                                sizeof (SHFILEINFO),
                                                SHGFI_ICON | SHGFI_LARGEICON))
                          SendMessage (hWnd, WM_SETICON,
                                                    TRUE, (LPARAM)shfi.hIcon);
                        if (SHGetFileInfo (ptw->szFile, 0, &shfi,
                                                sizeof (SHFILEINFO),
                                                SHGFI_ICON | SHGFI_SMALLICON))
                          SendMessage (hWnd, WM_SETICON,
                                                    FALSE, (LPARAM)shfi.hIcon);
                        if (!SetMenuBar (ptw))
                          return 0;
                        if (!SetHistory (szFile, hWndMain, nHistory,
                                                            MENUTOP, MENUFILE))
                          {
                            MessageBox ( hWnd,_T("SetHistory"),
                                            APPLICATION, MB_OK | MB_ICONSTOP);
                            DestroyWindow (hWndMain);
                            return 0;
                          }
                        if (!SetWindowText (hWnd, szTitle))
                          {
                            MessageBox (hWnd, _T("SetWindowText"),
                                            APPLICATION, MB_OK | MB_ICONSTOP);
                            DestroyWindow (hWndMain);
                            return 0;
                          }
                      }
                  }
                MemoryFree (lpszFilter);
              }
              return 0;
            case CM_RELOAD:
              {
                RELOAD stReload;
                LPLINEBUF p;
                LPTEXTWND ptw;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                if (ptw->fEdit)
                  {
                    int nResult;
                    LPTSTR lpszFormat, lpszText;

                    lpszFormat = LoadText (hInst, IDS_PROMPT_RELOAD);
                    wasprintf (&lpszText, lpszFormat, ptw->szFile);
                    MemoryFree (lpszFormat);
                    nResult = MessageBox (hWnd, lpszText, APPLICATION,
                                                MB_YESNO | MB_ICONINFORMATION);
                    MemoryFree (lpszText);
                    if (nResult != IDYES)
                      return 0;
                  }
                stReload.uRetCode = ptw->uRetCode;
                stReload.uCharSet = ptw->uCharSet;
                if (DialogBoxParamGUI (hInst, MAKEINTRESOURCE (DIALOG_2), hWnd,
                                    ReloadDlgProc, (LPARAM)&stReload) != IDOK)
                  return 0;
                /* ja:obt@ */
                ptw->uRetCode = stReload.uRetCode;
                ptw->uCharSet = stReload.uCharSet;
                while (ptw->lpStart->prev)
                  ptw->lpStart = ptw->lpStart->prev;
                while (ptw->lpStart)
                  {
                    p = ptw->lpStart->next;
                    MemoryFree (ptw->lpStart->lpszText);
                    MemoryFree (ptw->lpStart);
                    ptw->lpStart = p;
                  }
                /* ja:ēǂݍ */
                if (!OpenTextFile (ptw,
                                    ptw->uCharSet + 1, FALSE, ptw->uRetCode))
                  {
                    p = MemoryAlloc (sizeof (LINEBUF));
                    p->nLength = 0;
                    p->fMargin = FALSE;
                    p->lpszText = NULL;
                    p->prev = p->next = NULL;
                    ptw->nMax = 1;
                    ptw->nOff = 0;
                    ptw->lpStart = p;
                  }
                DeleteList (&ptw->lpUndo);
                DeleteList (&ptw->lpRedo);
                ptw->ptCursor.x = ptw->ptCursor.y = 0;
                ptw->ptTop.x = ptw->ptTop.y = 0;
                ptw->ptSelect.x = -1;
                ptw->fEdit = FALSE;
                SetScrollBar (hWnd, SB_HORZ, 0, GetWidthMax (ptw),
                        max (ptw->siWnd.cx / ptw->nFontSize, 1), ptw->ptTop.x);
                SetScrollBar (hWnd,SB_VERT, 0, ptw->nMax - 1,
                        max (ptw->siWnd.cy / (ptw->nFontSize * 2), 1),
                                                                ptw->ptTop.y);
                if (!SetMenuBar (ptw) || !DrawCaret (hWnd))
                  return 0;
                if (!InvalidateRect (hWnd, NULL, TRUE))
                  {
                    MessageBox (hWnd, _T("InvalidateRect"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                    DestroyWindow (hWndMain);
                  }
              }
              return 0;
            case CM_PROPERTY:
              {
                int i;
                LPTEXTWND ptw;
                FILETYPE stFileType;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                stFileType.nID = ptw->nID;
                stFileType.nMargin = ptw->nMargin;
                stFileType.nTab = ptw->nTab;
                stFileType.fAssociate = ptw->fAssociate;
                stFileType.fAutoIndent = ptw->fAutoIndent;
                stFileType.fCode = ptw->fCode;
                stFileType.fCRLF = ptw->fCRLF;
                stFileType.fEOF = ptw->fEOF;
                stFileType.fLimit = ptw->fLimit;
                stFileType.fOverWrite = ptw->fOverWrite;
                stFileType.fRecycle = ptw->fRecycle;
                stFileType.fSpace = ptw->fSpace;
                stFileType.fSysColor = ptw->fSysColor;
                stFileType.fTabConv = ptw->fTabConv;
                stFileType.fGline = ptw->fGline;
                stFileType.fMline = ptw->fMline;
                stFileType.fUline = ptw->fUline;
                stFileType.fVline = ptw->fVline;
                MemoryCopy (stFileType.crColor, ptw->crColor,
                                                    sizeof (COLORREF) * 12);
                stFileType.lf = ptw->lf;
                stFileType.uRetCode = ptw->uRetCode;
                stFileType.uCharSet = ptw->uCharSet;
                if (DialogBoxParamGUI (hInst, MAKEINTRESOURCE (DIALOG_5), hWnd,
                                PropertyDlgProc, (LPARAM)&stFileType) != IDOK)
                  return 0;
                ptw->uRetCode = stFileType.uRetCode;
                ptw->uCharSet = stFileType.uCharSet;
                if (stFileType.nID < 0)
                  {
                    /* ja:̂Ƃɂ͂̃EChEύX */
                    ChangeProperty (hWnd, &stFileType);
                  }
                else
                  {
                    /* ja:t@C^CvׂĕύX */
                    ptw->nID = stFileType.nID;
                    for (i = 0; i < nFileType; i++)
                      if (lpFileType[i].nID == stFileType.nID)
                        {
                          lpFileType[i].nMargin = stFileType.nMargin;
                          lpFileType[i].nTab = stFileType.nTab;
                          lpFileType[i].fAutoIndent = stFileType.fAutoIndent;
                          lpFileType[i].fCode = stFileType.fCode;
                          lpFileType[i].fCRLF = stFileType.fCRLF;
                          lpFileType[i].fEOF = stFileType.fEOF;
                          lpFileType[i].fLimit = stFileType.fLimit;
                          lpFileType[i].fOverWrite = stFileType.fOverWrite;
                          lpFileType[i].fRecycle = stFileType.fRecycle;
                          lpFileType[i].fSpace = stFileType.fSpace;
                          lpFileType[i].fSysColor = stFileType.fSysColor;
                          lpFileType[i].fTabConv = stFileType.fTabConv;
                          lpFileType[i].fGline = stFileType.fGline;
                          lpFileType[i].fMline = stFileType.fMline;
                          lpFileType[i].fUline = stFileType.fUline;
                          lpFileType[i].fVline = stFileType.fVline;
                          MemoryCopy (lpFileType[i].crColor,
                                stFileType.crColor, sizeof (COLORREF) * 12);
                          lpFileType[i].lf = stFileType.lf;
                          break;
                        }
                    EnumChildWindows (hWndClient, PropertyEnumProc,
                                                        (LPARAM)&stFileType);
                  }
              }
              return 0;
            case CM_PRINT:
              PrintOut (hWnd);
              return 0;
            case CM_UNDO:
              HistoryOperation (hWnd, FALSE);
              return 0;
            case CM_REDO:
              HistoryOperation (hWnd, TRUE);
              return 0;
            case CM_CUT:
              SendMessage (hWnd, WM_COMMAND, CM_COPY, (LPARAM)NULL);
              SendMessage (hWnd, WM_COMMAND, CM_DELETE, (LPARAM)NULL);
              return 0;
            case CM_COPY:
              {
                int nLength;
                HGLOBAL hGlobalA, hGlobalW;
                LPSTR lpszTextA;
                LPWSTR lpszTextW;
                LPTEXTWND ptw;

                ptw=(LPTEXTWND)GetWindowLong(hWnd,0);
                /* ja:I͈͂̕ */
                nLength = GetSelByte (&ptw->lpStart, &ptw->nOff,
                                    &ptw->ptSelect, &ptw->ptCursor, ptw->nTab);
                /* ja:m */
                hGlobalA = GlobalAlloc (GMEM_MOVEABLE,
                                                (nLength + 1) *  sizeof(CHAR));
                if (!hGlobalA)
                  {
                    MessageBox (hWnd, _T("GlobalAlloc"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                    DestroyWindow (hWndMain);
                    return 0;
                  }
                lpszTextA = GlobalLock (hGlobalA);
                if (!lpszTextA)
                  {
                    MessageBox (hWnd, _T("GlobalLock"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                    GlobalFree (hGlobalA);
                    DestroyWindow (hWndMain);
                    return 0;
                  }
                /* ja:ɕRs[ */
                CpySelMem (&ptw->lpStart, &ptw->nOff,
                        &ptw->ptSelect, &ptw->ptCursor, ptw->nTab, lpszTextA);
                lpszTextA[nLength] = '\0';
                /* ja:UNICODEɕϊ */
                nLength = MultiByteToWideChar (CP_SJIS, 0,
                                                    lpszTextA, -1, NULL, 0);
                hGlobalW = GlobalAlloc (GMEM_MOVEABLE,
                                                    nLength * sizeof (WCHAR));
                if (!hGlobalW)
                  {
                    MessageBox (hWnd, _T("GlobalAlloc"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                    GlobalUnlock (hGlobalA);
                    GlobalFree (hGlobalA);
                    DestroyWindow (hWndMain);
                    return 0;
                  }
                lpszTextW = GlobalLock (hGlobalW);
                if (!lpszTextW)
                  {
                    MessageBox (hWnd, _T("GlobalLock"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                    GlobalUnlock (hGlobalA);
                    GlobalFree (hGlobalA);
                    GlobalFree (hGlobalW);
                    DestroyWindow (hWndMain);
                    return 0;
                  }
                MultiByteToWideChar (CP_SJIS, 0, lpszTextA, -1,
                                                        lpszTextW, nLength);
                GlobalUnlock (hGlobalA);
                GlobalUnlock (hGlobalW);
                /* ja:Nbv{[h */
                if (!OpenClipboard (hWnd))
                  {
                    MessageBox (hWnd, _T("OpenClipboard"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    GlobalFree (hGlobalA);
                    GlobalFree (hGlobalW);
                    return 0;
                  }
                if (!EmptyClipboard ())
                  {
                    MessageBox (hWnd, _T("EmptyClipboard"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                    GlobalFree (hGlobalA);
                    GlobalFree (hGlobalW);
                    DestroyWindow (hWndMain);
                    return 0;
                  }
                if (!SetClipboardData (CF_TEXT, hGlobalA)
                            || !SetClipboardData (CF_UNICODETEXT, hGlobalW))
                  {
                    MessageBox (hWnd, _T("SetClipboardData"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                    GlobalFree (hGlobalA);
                    GlobalFree (hGlobalW);
                    DestroyWindow (hWndMain);
                    return 0;
                  }
                if (!CloseClipboard ())
                  {
                    MessageBox (hWnd, _T("CloseClipboard"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                    DestroyWindow (hWndMain);
                  }
              }
              return 0;
            case CM_PASTE:
              {
                int nLength;
                LPDOING d;
                HGLOBAL hGlobal;
                LPTEXTWND ptw;
                POINT ptSelect;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                ptSelect = ptw->ptSelect;
                if (!OpenClipboard (hWnd))
                  {
                    MessageBox (hWnd, _T("OpenClipboard"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    return 0;
                  }
                if (IsClipboardFormatAvailable (CF_UNICODETEXT))
                  {
                    /* en:UNICODE */
                    LPSTR lpszTextA;
                    LPWSTR lpszTextW;

                    hGlobal = GetClipboardData (CF_UNICODETEXT);
                    if (!hGlobal)
                      {
                        CloseClipboard ();
                        return 0;
                      }
                    lpszTextW = GlobalLock (hGlobal);
                    if (!lpszTextW)
                      {
                        CloseClipboard ();
                        MessageBox (hWnd, _T("GlobalLock"),
                                            APPLICATION, MB_OK | MB_ICONSTOP);
                        DestroyWindow (hWndMain);
                        return 0;
                      }
                    nLength = WideCharToMultiByte (CP_SJIS, 0,
                                        lpszTextW, -1, NULL, 0, NULL, NULL);
                    lpszTextA = MemoryAlloc (nLength * sizeof (CHAR));
                    WideCharToMultiByte (CP_SJIS, 0,
                                lpszTextW, -1, lpszTextA, nLength, NULL, NULL);
                    d = EditOperation (hWnd,
                                lpszTextA, lstrlenA (lpszTextA), TRUE, FALSE);
                    MemoryFree (lpszTextA);
                  }
                else
                  {
                    /* en:ANSI/OEM */
                    LPSTR lpszTextA;

                    hGlobal = GetClipboardData (CF_TEXT);
                    if (!hGlobal)
                      {
                        CloseClipboard ();
                        return 0;
                      }
                    lpszTextA = GlobalLock (hGlobal);
                    if (!lpszTextA)
                      {
                        CloseClipboard ();
                        MessageBox (hWnd, _T("GlobalLock"),
                                            APPLICATION, MB_OK | MB_ICONSTOP);
                        DestroyWindow (hWndMain);
                        return 0;
                      }
                    d = EditOperation (hWnd,
                                lpszTextA, lstrlenA (lpszTextA), TRUE, FALSE);
                  }
                GlobalUnlock (hGlobal);
                if (!CloseClipboard ())
                  {
                    MessageBox (hWnd, _T("CloseClipboard"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                    DestroyWindow (hWndMain);
                    return 0;
                  }
                if (!d)
                  return 0;
                d->next = ptw->lpUndo;
                ptw->lpUndo = d;
                if (DeleteList (&ptw->lpRedo) > 0 || !d->next
                                                            || ptSelect.x >= 0)
                  {
                    HideCaret (hWnd);
                    if (!SetMenuBar (ptw))
                      return 0;
                    ShowCaret (hWnd);
                  }
                ptw->fEdit = TRUE;
              }
              return 0;
            case CM_DELETE:
              {
                LPDOING d;
                LPTEXTWND ptw;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                d = EditOperation (hWnd, NULL, 0, TRUE, FALSE);
                if (!d)
                  return 0;
                d->next = ptw->lpUndo;
                ptw->lpUndo = d;
                DeleteList (&ptw->lpRedo);
                HideCaret (hWnd);
                if (!SetMenuBar (ptw))
                  return 0;
                ShowCaret (hWnd);
                ptw->fEdit = TRUE;
              }
              return 0;
            case CM_MARGIN:
              {
                LPTSTR lpszText;

                lpszText = LoadText (hInst, IDS_PROMPT_MARGIN);
                if (MessageBox (hWnd, lpszText,
                        APPLICATION, MB_YESNO | MB_ICONINFORMATION) == IDYES)
                  MarginOperation (hWnd);
                MemoryFree (lpszText);
              }
              return 0;
            case CM_TAB:
              {
                LPTSTR lpszText;

                lpszText = LoadText (hInst, IDS_PROMPT_TAB);
                if (MessageBox (hWnd, LoadText (hInst, IDS_PROMPT_TAB),
                        APPLICATION, MB_YESNO | MB_ICONINFORMATION) == IDYES)
                  TabOperation (hWnd);
                MemoryFree (lpszText);
              }
              return 0;
            case CM_DATE:
              {
                int nLength;
                BOOL fCtrl;
                LPDOING d;
                LPTSTR lpszText;
#ifdef UNICODE
                LPSTR lpszTextA;
#endif /* UNICODE */
                LPTEXTWND ptw;
                POINT ptSelect;

                fCtrl = GetKeyState (VK_CONTROL) & 0x8000;
                nLength = GetDateFormat (LOCALE_USER_DEFAULT, fCtrl
                        ? DATE_LONGDATE : DATE_SHORTDATE, NULL, NULL, NULL, 0)
                    + GetTimeFormat (LOCALE_USER_DEFAULT, TIME_NOSECONDS
                                | TIME_FORCE24HOURFORMAT, NULL, NULL, NULL, 0);
                lpszText = MemoryAlloc (nLength * sizeof (TCHAR));
                if (GetKeyState (VK_MENU) & 0x8000)
                  {
                    int nPos;

                    nPos = GetDateFormat (LOCALE_USER_DEFAULT, fCtrl
                                            ? DATE_LONGDATE : DATE_SHORTDATE,
                                                NULL, NULL, lpszText, nLength);
                    lpszText[nPos - 1] = ' ';
                    GetTimeFormat (LOCALE_USER_DEFAULT,
                                    TIME_NOSECONDS | TIME_FORCE24HOURFORMAT,
                                NULL, NULL, lpszText + nPos, nLength - nPos);
                  }
                else
                  {
                    int nPos;

                    nPos = GetTimeFormat (LOCALE_USER_DEFAULT,
                                    TIME_NOSECONDS | TIME_FORCE24HOURFORMAT,
                                                NULL, NULL, lpszText, nLength);
                    lpszText[nPos - 1] = ' ';
                    GetDateFormat (LOCALE_USER_DEFAULT, fCtrl
                                ? DATE_LONGDATE : DATE_SHORTDATE, NULL, NULL,
                                            lpszText + nPos, nLength - nPos);
                  }
                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                ptSelect = ptw->ptSelect;
#ifdef UNICODE
                nLength = WideCharToMultiByte (CP_SJIS, 0, lpszText, -1,
                                                        NULL, 0, NULL, NULL);
                lpszTextA = MemoryAlloc (nLength * sizeof (CHAR));
                WideCharToMultiByte (CP_SJIS, 0, lpszText, -1,
                                            lpszTextA, nLength, NULL, NULL);
                d = EditOperation (hWnd,
                                lpszTextA, lstrlenA (lpszTextA), TRUE, FALSE);
                MemoryFree (lpszTextA);
#else /* not UNICODE */
                d = EditOperation (hWnd,
                                    lpszText, lstrlen (lpszText), TRUE, FALSE);
#endif /* not UNICODE */
                MemoryFree (lpszText);
                if (!d)
                  return 0;
                d->next = ptw->lpUndo;
                ptw->lpUndo = d;
                if (DeleteList (&ptw->lpRedo) > 0 || !d->next
                                                            || ptSelect.x >= 0)
                  {
                    HideCaret (hWnd);
                    if (!SetMenuBar (ptw))
                      return 0;
                    ShowCaret (hWnd);
                  }
                ptw->fEdit = TRUE;
              }
              return 0;
            case CM_CODE:
              {
                int nCode;
                LPDOING d;
                LPTEXTWND ptw;
                POINT ptSelect;

                nCode = nCodeDef;
                if (DialogBoxParamGUI (hInst, MAKEINTRESOURCE (DIALOG_6), hWnd,
                                        ValChrDlgProc, (LPARAM)&nCode) != IDOK)
                  return 0;
                nCodeDef = nCode;
                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                ptSelect = ptw->ptSelect;
                d = EditOperation (hWnd, (LPSTR)&nCode, 1, TRUE, FALSE);
                if (!d)
                  return 0;
                d->next = ptw->lpUndo;
                ptw->lpUndo = d;
                if (DeleteList (&ptw->lpRedo) > 0 || !d->next
                                                            || ptSelect.x >= 0)
                  {
                    HideCaret (hWnd);
                    if (!SetMenuBar (ptw))
                      return 0;
                    ShowCaret (hWnd);
                  }
                ptw->fEdit = TRUE;
              }
              return 0;
            case CM_JUMP:
              {
                JMPDLG jmp;
                LPTEXTWND ptw;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                jmp.nMax = ptw->nMax;
                jmp.nCursor = ptw->ptCursor.y + 1;
                if (DialogBoxParamGUI (hInst, MAKEINTRESOURCE (DIALOG_7), hWnd,
                                            JumpDlgProc, (LPARAM)&jmp) == IDOK
                                        && ptw->ptCursor.y != jmp.nCursor - 1)
                  JumpOperation (hWnd, jmp.nCursor);
              }
              return 0;
            case CM_ALL:
              {
                int sx, sy;
                POINT ptTop;
                LPTEXTWND ptw;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                if (ptw->nMax <= 1 && ptw->lpStart->nLength <= 0)
                  return 0;
                ptTop = ptw->ptTop;
                sx = max (ptw->siWnd.cx / ptw->nFontSize, 1);
                sy = max (ptw->siWnd.cy / (ptw->nFontSize * 2), 1);
                ptw->ptSelect.x = ptw->ptSelect.y = 0;
                ptw->ptCursor.x = GetWidth (&ptw->lpStart, &ptw->nOff,
                                ptw->ptCursor.y = ptw->nMax - 1, ptw->nTab);
                if (ptw->ptCursor.x < ptw->ptTop.x)
                  ptw->ptTop.x = ptw->ptCursor.x;
                else if (ptw->ptCursor.x - sx + 1 > ptw->ptTop.x)
                  ptw->ptTop.x = ptw->ptCursor.x - sx + 1;
                if (ptw->ptCursor.y < ptw->ptTop.y)
                  ptw->ptTop.y = ptw->ptCursor.y;
                else if (ptw->ptCursor.y - sy + 1 > ptw->ptTop.y)
                  ptw->ptTop.y = ptw->ptCursor.y - sy + 1;
                HideCaret (hWnd);
                if (!SetMenuBar (ptw) || !DrawCaret (hWnd))
                  return 0;
                if (ptw->ptTop.x != ptTop.x)
                  SetScrollBar (hWnd, SB_HORZ, 0,
                                        GetWidthMax (ptw), sx, ptw->ptTop.x);
                if (ptw->ptTop.y != ptTop.y)
                  SetScrollBar (hWnd, SB_VERT, 0,
                                        ptw->nMax - 1, sy, ptw->ptTop.y);
                if (!InvalidateRect (hWnd, NULL, TRUE))
                  {
                    MessageBox (hWnd, _T("InvalidateRect"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                    DestroyWindow (hWndMain);
                    return 0;
                  }
                ShowCaret (hWnd);
              }
              return 0;
            case CM_FIND:
              {
                int i;
                FIND fd;
                LPTEXTWND ptw;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                fd.szText[0] = '\0';
                fd.bArrow = bFindArrow;
                fd.bCase = bFindCase;
                fd.bWidth = bFindWidth;
                if (ptw->ptSelect.x >= 0)
                  fd.bArrow = ptw->ptCursor.y < ptw->ptSelect.y
                                        || ptw->ptCursor.y == ptw->ptSelect.y
                                        && ptw->ptCursor.x < ptw->ptSelect.x;
                if (DialogBoxParamGUI (hInst, MAKEINTRESOURCE (DIALOG_8), hWnd,
                                            FindDlgProc, (LPARAM)&fd) != IDOK)
                  return 0;
                if (!SetMenuBar (ptw))
                  return 0;
                bFindArrow = fd.bArrow;
                bFindCase = fd.bCase;
                bFindWidth = fd.bWidth;
                for (i = 0; i < nFind; i++)
                  if (lstrcmp (fd.szText, lpszFind[i]) == 0)
                    break;
                if (i == nFind)
                  {
                    if (nFind >= 32)
                      MemoryFree (lpszFind[31]);
                    else
                      nFind++;
                    for (i = nFind - 1; i > 0; i--)
                      lpszFind[i] = lpszFind[i - 1];
                    lpszFind[0] = MemoryAlloc ((lstrlen (fd.szText) + 1)
                                                            * sizeof (TCHAR));
                    lstrcpy (lpszFind[0], fd.szText);
                  }
                else
                  {
                    LPTSTR lpszText;

                    lpszText = lpszFind[i];
                    MemoryCopy (lpszFind + 1, lpszFind, i * sizeof (LPTSTR));
                    lpszFind[0] = lpszText;
                  }
              }
            case CM_NEXT:
              {
                LPTEXTWND ptw;
                TCHAR szText[MAXFIND + 256];

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                if (!FindOperation (hWnd, &ptw->ptCursor, &ptw->ptSelect,
                                                                lpszFind[0],
                            GetKeyState (VK_SHIFT) & 0x8000
                            ? !bFindArrow : bFindArrow, bFindCase, bFindWidth))
                  return 0;
                if (fUserBreak && ptw->ptSelect.x < 0)
                  {
                    LPTSTR lpszFormat, lpszText;

                    lpszFormat = LoadText (hInst, IDS_REPINFO_ZERO);
                    wasprintf (&lpszText, lpszFormat, lpszFind[0]);
                    MemoryFree (lpszFormat);
                    MessageBox (hWnd, lpszText,
                                    APPLICATION, MB_OK | MB_ICONINFORMATION);
                    MemoryFree (lpszText);
                  }
                SetMenuBar (ptw);
              }
              return 0;
            case CM_REPLACE:
              {
                int i, nBytes, nCount = 0, nResult;
                BOOL fReplace = FALSE;
                LPDOING d;
                LPTEXTWND ptw;
                POINT ptSelect;
                REPINFO ri;
                REPLACE rp;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                rp.szSrc[0] = rp.szDst[0] = '\0';
                rp.bArrow = bReplaceArrow;
                rp.bCase = bReplaceCase;
                rp.bWidth = bReplaceWidth;
                if (ptw->ptSelect.x >= 0)
                  rp.bArrow = ptw->ptCursor.y < ptw->ptSelect.y
                                        || ptw->ptCursor.y == ptw->ptSelect.y
                                        && ptw->ptCursor.x < ptw->ptSelect.x;
                nResult = DialogBoxParamGUI (hInst, MAKEINTRESOURCE (DIALOG_9),
                                            hWnd, ReplaceDlgProc, (LPARAM)&rp);
                if (nResult == IDCANCEL)
                  return 0;
                bReplaceArrow = rp.bArrow;
                bReplaceCase = rp.bCase;
                bReplaceWidth = rp.bWidth;
                for (i = 0; i < nFind; i++)
                  if (lstrcmp (rp.szSrc, lpszFind[i]) == 0)
                    break;
                if (i == nFind)
                  {
                    if (nFind >= 32)
                      MemoryFree (lpszFind[31]);
                    else
                      nFind++;
                    for (i = nFind - 1; i > 0; i--)
                      lpszFind[i] = lpszFind[i - 1];
                    lpszFind[0] = MemoryAlloc ((lstrlen (rp.szSrc) + 1)
                                                            * sizeof (TCHAR));
                    lstrcpy (lpszFind[0], rp.szSrc);
                  }
                else
                  {
                    LPTSTR lpszText;

                    lpszText = lpszFind[i];
                    MemoryCopy (lpszFind + 1, lpszFind, i * sizeof (LPTSTR));
                    lpszFind[0] = lpszText;
                  }
                if (rp.szDst[0] != '\0')
                  {
                    for (i = 0; i < nReplace; i++)
                      if (lstrcmp (rp.szDst, lpszReplace[i]) == 0)
                        break;
                    if (i == nReplace)
                      {
                        if (nReplace >= 32)
                          MemoryFree (lpszReplace[31]);
                        else
                          nReplace++;
                        for (i = nReplace - 1; i > 0; i--)
                          lpszReplace[i] = lpszReplace[i - 1];
                        lpszReplace[0] = MemoryAlloc ((lstrlen (rp.szDst) + 1)
                                                            * sizeof (TCHAR));
                        lstrcpy (lpszReplace[0], rp.szDst);
                      }
                    else
                      {
                        LPTSTR lpszText;

                        lpszText = lpszReplace[i];
                        MemoryCopy (lpszReplace + 1, lpszReplace,
                                                        i * sizeof (LPTSTR));
                        lpszReplace[0] = lpszText;
                      }
                  }
                ptSelect = ptw->ptSelect;
                ri.bArrow = rp.bArrow;
                ri.bCase = rp.bCase;
                ri.bWidth = rp.bWidth;
                lstrcpy (ri.szDst, rp.szDst);
                do
                  {
                    int nDataPos;
                    CHAR szDst[MAXFIND];

                    if (!FindOperation (hWnd, &ptw->ptCursor, &ptSelect,
                                    rp.szSrc, rp.bArrow, rp.bCase, rp.bWidth))
                      return 0;
                    if (ptw->ptSelect.x < 0)
                      break;
                    fReplace = TRUE;
                    nBytes = GetSelByte (&ptw->lpStart, &ptw->nOff,
                                    &ptw->ptSelect, &ptw->ptCursor, ptw->nTab);
                    if (nResult < 100)
                      {
#ifdef UNICODE
                        CHAR szSrc[MAXFIND * 2];
#endif /* UNICODE */
                        if (nBytes >= MAXFIND * 2)
                          continue;
#ifdef UNICODE
                        CpySelMem (&ptw->lpStart, &ptw->nOff,
                                                &ptw->ptSelect, &ptw->ptCursor,
                                                            ptw->nTab, szSrc);
                        szSrc[nBytes] = '\0';
                        MultiByteToWideChar (CP_SJIS, 0, szSrc, -1,
                                                        ri.szSrc, MAXFIND * 2);
#else /* not UNICODE */
                        CpySelMem (&ptw->lpStart, &ptw->nOff,
                                                &ptw->ptSelect, &ptw->ptCursor,
                                                        ptw->nTab, ri.szSrc);
                        ri.szSrc[nBytes] = '\0';
#endif /* not UNICODE */
                        ri.ptStart = ptw->ptSelect;
                        ri.ptEnd = ptw->ptCursor;
                        nResult = DialogBoxParamGUI (hInst,
                                            MAKEINTRESOURCE (DIALOG_A),
                                            hWnd, RepinfoDlgProc, (LPARAM)&ri);
                        if (nResult == IDNO || nResult == IDCANCEL)
                          continue;
                      }
                    if (ptSelect.x >= 0 && ptw->ptCursor.y == ptSelect.y
                                                                && rp.bArrow)
                      nDataPos = GetDataPos (&ptw->lpStart, &ptw->nOff,
                                    ptSelect.x, ptSelect.y, ptw->nTab, FALSE);
#ifdef UNICODE
                    WideCharToMultiByte (CP_SJIS, 0, ri.szDst, -1,
                                                szDst, MAXFIND, NULL, NULL);
                    d = EditOperation (hWnd, szDst, lstrlenA (szDst),
                                                            rp.bArrow, TRUE);
#else /* not UNICODE */
                    d = EditOperation (hWnd, rp.szDst, lstrlen (rp.szDst),
                                                            rp.bArrow, TRUE);
#endif /* not UNICODE */
                    if (ptSelect.x >= 0 && ptw->ptCursor.y == ptSelect.y
                                                                && rp.bArrow)
                      ptSelect.x = GetScreenPos (&ptw->lpStart, &ptw->nOff,
                                        nDataPos + lstrlen (rp.szDst) - nBytes,
                                                        ptSelect.y, ptw->nTab);
                    if (nResult >= 100)
                      nCount++;
                    d->next = ptw->lpUndo;
                    ptw->lpUndo = d;
                    if (DeleteList (&ptw->lpRedo) > 0 || !d->next)
                      {
                        HideCaret (hWnd);
                        if (!SetMenuBar (ptw))
                          return 0;
                        ShowCaret (hWnd);
                      }
                    ptw->fEdit = TRUE;
                  }
                while (nResult != IDCANCEL);
                if (!fReplace)
                  {
                    LPTSTR lpszFormat, lpszText;

                    lpszFormat = LoadText (hInst, IDS_REPINFO_ZERO);
                    wasprintf (&lpszText, lpszFormat, rp.szSrc);
                    MemoryFree (lpszFormat);
                    MessageBox (hWnd, lpszText,
                                    APPLICATION, MB_OK | MB_ICONINFORMATION);
                    MemoryFree (lpszText);
                  }
                else if (nResult >= 100)
                  {
                    LPTSTR lpszFormat, lpszText;

                    lpszFormat = LoadText (hInst, IDS_REPINFO_DONE);
                    wasprintf (&lpszText, lpszFormat, nCount);
                    MemoryFree (lpszFormat);
                    MessageBox (hWnd, lpszText,
                                    APPLICATION, MB_OK | MB_ICONINFORMATION);
                    MemoryFree (lpszText);
                  }
                SetMenuBar (ptw);
              }
              return 0;
            case CM_LINE:
              {
                LPDOING d;
                LPTEXTWND ptw;
                POINT ptSelect;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                ptSelect = ptw->ptSelect;
                if (ptw->ptSelect.x < 0)
                  {
                    if (ptw->nMax - 1 <= ptw->ptCursor.y)
                      {
                        ptw->ptCursor.x = 0;
                        ptw->ptSelect.x = GetWidth (&ptw->lpStart, &ptw->nOff,
                                                ptw->ptCursor.y, ptw->nTab);
                        if (ptw->ptSelect.x <= 0)
                          {
                            if (ptw->ptCursor.y <= 0)
                              {
                                ptw->ptSelect.x = -1;
                                return 0;
                              }
                            ptw->ptSelect.y = ptw->ptCursor.y - 1;
                          }
                        else
                          {
                            ptw->ptSelect.y = ptw->ptCursor.y;
                          }
                      }
                    else
                      {
                        ptw->ptCursor.x = ptw->ptSelect.x = 0;
                        ptw->ptSelect.y = ptw->ptCursor.y + 1;
                      }
                  }
                d = EditOperation (hWnd, NULL, 0, FALSE, FALSE);
                if (!d)
                  return 0;
                d->next = ptw->lpUndo;
                ptw->lpUndo = d;
                if (DeleteList (&ptw->lpRedo) > 0 || !d->next
                                                            || ptSelect.x >= 0)
                  {
                    HideCaret (hWnd);
                    if (!SetMenuBar (ptw))
                      return 0;
                    ShowCaret (hWnd);
                  }
                ptw->fEdit = TRUE;
              }
              return 0;
            case CM_MENU:
              {
                int sx, sy;
                POINT ptScreen, ptTop;
                LPTEXTWND ptw;

                ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
                ptTop = ptw->ptTop;
                sx = max (ptw->siWnd.cx / ptw->nFontSize, 1);
                sy = max (ptw->siWnd.cy / (ptw->nFontSize * 2), 1);
                if (ptw->ptCursor.x < ptw->ptTop.x)
                  ptw->ptTop.x = ptw->ptCursor.x;
                else if (ptw->ptCursor.x - sx + 1 > ptw->ptTop.x)
                  ptw->ptTop.x = ptw->ptCursor.x - sx + 1;
                if (ptw->ptCursor.y < ptw->ptTop.y)
                  ptw->ptTop.y = ptw->ptCursor.y;
                else if (ptw->ptCursor.y - sy + 1 > ptw->ptTop.y)
                  ptw->ptTop.y = ptw->ptCursor.y - sy + 1;
                if (!MoveTextWindow (hWnd, &ptTop))
                  return 0;
                ptScreen.x = (GetAlignPos (&ptw->lpStart, &ptw->nOff,
                            ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE)
                                            - ptw->ptTop.x) * ptw->nFontSize;
                ptScreen.y = (ptw->ptCursor.y - ptw->ptTop.y)
                                                        * ptw->nFontSize * 2;
                if (!ClientToScreen (hWnd, &ptScreen))
                  {
                    MessageBox (hWnd, _T("ClientToScreen"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                    DestroyWindow (hWndMain);
                    return 0;
                  }
                if (EnableMenuItem (hMenuPopup, CM_UNDO, ptw->lpUndo
                                    ? MF_ENABLED : MF_GRAYED) == 0xffffffff
                        || EnableMenuItem (hMenuPopup, CM_CUT,
                                                        ptw->ptSelect.x >= 0
                                    ? MF_ENABLED : MF_GRAYED) == 0xffffffff
                        || EnableMenuItem (hMenuPopup, CM_COPY,
                                                        ptw->ptSelect.x >= 0
                                    ? MF_ENABLED : MF_GRAYED) == 0xffffffff
                        || EnableMenuItem (hMenuPopup, CM_PASTE, fClipBoard
                                    ? MF_ENABLED : MF_GRAYED) == 0xffffffff
                        || EnableMenuItem (hMenuPopup, CM_DELETE,
                                                        ptw->ptSelect.x>=0
                                    ? MF_ENABLED : MF_GRAYED) == 0xffffffff)
                  {
                    MessageBox (hWnd, _T("EnableMenuItem"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                    DestroyWindow (hWndMain);
                    return 0;
                  }
                TrackPopupMenu (hMenuPopup, TPM_RIGHTBUTTON,
                                        ptScreen.x, ptScreen.y, 0, hWnd, NULL);
              }
          }
        return 0;
      case WM_QUERYENDSESSION:
      case WM_CLOSE:
        {
          LPTEXTWND ptw;

          ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
          if (ptw && ptw->fEdit)
            {
              int nResult;
              LPTSTR lpszFormat, lpszText;

              lpszFormat = LoadText (hInst, IDS_PROMPT_SAVE);
              wasprintf (&lpszText, lpszFormat, ptw->szFile);
              MemoryFree (lpszFormat);
              nResult = MessageBox (hWnd, lpszText, APPLICATION,
                                        MB_YESNOCANCEL | MB_ICONINFORMATION);
              MemoryFree (lpszText);
              switch (nResult)
                {
                  case IDYES:
                    SendMessage (hWnd, WM_COMMAND, CM_SAVE, (LPARAM)NULL);
                    if (!ptw->fEdit)
                      break;
                  case IDCANCEL:
                    return 0;
                }
            }
        }
        break;
      case WM_DESTROY:
        {
          LPLINEBUF p;
          LPTEXTWND ptw;

          ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
          DeleteEditFile (hWnd, ptw->szFile);
          if ((ptw->hBrushWindow && !DeleteObject (ptw->hBrushWindow))
            | (ptw->hBrushSpace && !DeleteObject (ptw->hBrushSpace))
            | (ptw->hBrushCrlf && !DeleteObject (ptw->hBrushCrlf))
            | (ptw->hBrushHighLight && !DeleteObject (ptw->hBrushHighLight))
            | (ptw->hPenTab && !DeleteObject (ptw->hPenTab))
            | (ptw->hPenMargin && !DeleteObject (ptw->hPenMargin))
            | (ptw->hPenGrid && !DeleteObject (ptw->hPenGrid))
            | (ptw->hFont && !DeleteObject (ptw->hFont))
            | (ptw->hFontsm && !DeleteObject (ptw->hFontsm)))
            MessageBox (hWnd, _T("DeleteObject"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
          while (ptw->lpStart->prev)
            ptw->lpStart = ptw->lpStart->prev;
          while (ptw->lpStart)
            {
              p = ptw->lpStart->next;
              if (ptw->lpStart->lpszText)
                MemoryFree (ptw->lpStart->lpszText);
              MemoryFree (ptw->lpStart);
              ptw->lpStart = p;
            }
          DeleteList (&ptw->lpUndo);
          DeleteList (&ptw->lpRedo);
          SetWindowLong (hWnd, 0, (LONG)NULL);
          MemoryFree (ptw);
          fZoomed = IsZoomed (hWnd);
        }
        return 0;
    }
  return DefMDIChildProc (hWnd, uMsg, wParam, lParam);
}
