/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "repinfo.h"
#include <limits.h>
#include "common.h"
#include "other.h"
#include "resource.h"


/******************************************************************************
*                                                                             *
* ja:u_CAOQ                                                     *
*                                                                             *
******************************************************************************/
BOOL CALLBACK RepinfoDlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
  static POINT ptDlg = {INT_MIN, INT_MIN};/* ja:_CAO̕\ʒu */

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          BOOL fResult;
          LPTSTR lpszFormat, lpszText3, lpszText4, lpszText5, lpszText6;

          if (ptDlg.x != INT_MIN && ptDlg.y != INT_MIN && !SetWindowPos (hDlg,
                        0, ptDlg.x, ptDlg.y, 0, 0, SWP_NOSIZE | SWP_NOZORDER))
            {
              MessageBox (hDlg, _T("SetWindowPos"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          lpszFormat = LoadText (hInst, IDS_REPINFO_SELECT);
          wasprintf (&lpszText3, lpszFormat,
                                        ((LPREPINFO)lParam)->ptStart.x + 1,
                                        ((LPREPINFO)lParam)->ptStart.y + 1,
                                        ((LPREPINFO)lParam)->ptEnd.x + 1,
                                        ((LPREPINFO)lParam)->ptEnd.y + 1);
          MemoryFree (lpszFormat);
          lpszText4 = LoadText (hInst, ((LPREPINFO)lParam)->bCase
                                        ? IDS_REPINFO_BS0 : IDS_REPINFO_BS1);
          lpszText5 = LoadText (hInst, ((LPREPINFO)lParam)->bWidth
                                        ? IDS_REPINFO_FH0 : IDS_REPINFO_FH1);
          lpszText6 = LoadText (hInst, ((LPREPINFO)lParam)->bArrow
                                        ? IDS_REPINFO_UD0 : IDS_REPINFO_UD1);
          fResult = SetDlgItemText (hDlg, IDC_STATICA1,
                                                    ((LPREPINFO)lParam)->szSrc)
                 && SetDlgItemText (hDlg, IDC_STATICA2,
                                                    ((LPREPINFO)lParam)->szDst)
                 && SetDlgItemText (hDlg, IDC_STATICA3, lpszText3)
                 && SetDlgItemText (hDlg, IDC_STATICA4, lpszText4)
                 && SetDlgItemText (hDlg, IDC_STATICA5, lpszText5)
                 && SetDlgItemText (hDlg, IDC_STATICA6, lpszText6);
          MemoryFree (lpszText3);
          MemoryFree (lpszText4);
          MemoryFree (lpszText5);
          MemoryFree (lpszText6);
          if (!fResult)
            {
              MessageBox (hDlg, _T("SetDlgItemText"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
            }
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDC_PUSHBUTTONA1:
            case IDYES:
            case IDNO:
            case IDCANCEL:
              {
                RECT rc;

                if (GetWindowRect (hDlg, &rc))
                  {
                    ptDlg.x = rc.left;
                    ptDlg.y = rc.top;
                  }
                else
                  {
                    MessageBox (hDlg, _T("GetWindowRect"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  }
                if (!EndDialog (hDlg, LOWORD (wParam)))
                  MessageBox (hDlg, _T("EndDialog"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              }
          }
        return TRUE;
    }
  return FALSE;
}
