/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "reload.h"
#include "common.h"
#include "other.h"
#include "resource.h"


/******************************************************************************
*                                                                             *
* ja:ēǂݍ݃_CAO֐Q                                               *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
ReloadDlgProc (HWND   hDlg,
               UINT   uMsg,
               WPARAM wParam,
               LPARAM lParam)
{
  static LPRELOAD lpReload;

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i;
          LPTSTR lpszText, *plpszArray;

          lpReload = (LPRELOAD)lParam;
          /* ja:R{{bNX̐ݒ */
          lpszText = LoadText (hInst, IDS_FTYPE_CRLF);
          plpszArray = StringSplitDelimiter (lpszText, _T(","));
          MemoryFree (lpszText);
          for (i = 0; plpszArray[i]; i++)
            SendDlgItemMessage (hDlg, IDC_COMBOBOX21, CB_ADDSTRING,
                                                    0, (LPARAM)plpszArray[i]);
          MemoryFree (plpszArray);
          SendDlgItemMessage (hDlg, IDC_COMBOBOX21, CB_SETCURSEL,
                                                        lpReload->uRetCode, 0);
          lpszText = LoadText (hInst, IDS_FTYPE_CHARSET);
          plpszArray = StringSplitDelimiter (lpszText, _T(","));
          MemoryFree (lpszText);
          for (i = 0; plpszArray[i]; i++)
            SendDlgItemMessage (hDlg, IDC_COMBOBOX22, CB_ADDSTRING,
                                                    0, (LPARAM)plpszArray[i]);
          MemoryFree (plpszArray);
          SendDlgItemMessage (hDlg, IDC_COMBOBOX22, CB_SETCURSEL,
                                                        lpReload->uCharSet, 0);
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              lpReload->uRetCode = SendDlgItemMessage (hDlg,
                                        IDC_COMBOBOX21, CB_GETCURSEL, 0, 0);
              lpReload->uCharSet = SendDlgItemMessage (hDlg,
                                        IDC_COMBOBOX22, CB_GETCURSEL, 0, 0);
            case IDCANCEL:
              if (!EndDialog (hDlg, LOWORD (wParam)))
                MessageBox (hDlg, _T("EndDialog"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
          }
        return TRUE;
    }
  return FALSE;
}
