/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "find.h"
#include "abort.h"
#include "common.h"
#include "dialog.h"
#include "edit.h"
#include "general.h"
#include "other.h"
#include "resource.h"


int nFind = 0;                  /* ja:o^Ă錟 */
BOOL bFindArrow = TRUE;         /* ja:TRUE:֌ */
BOOL bFindCase = FALSE;         /* ja:TRUE:啶ʂ */
BOOL bFindWidth = FALSE;        /* ja:TRUE:Sppʂ */
LPTSTR lpszFind[32];            /* ja:镶 */


/******************************************************************************
*                                                                             *
* ja:֐Q                                                               *
*                                                                             *
******************************************************************************/
/*  ja:̎ނ߂
     lpbType,̑i[obt@,0:ANK,1:SJIS1oCg,2:SJIS2oCg
    lpszText,
     nLength,f[^TCY                                                   */
static void
mCharType (LPBYTE lpbType,
           LPCSTR lpszText,
           int    nLength)
{
  int i = 0;

  while (i < nLength)
    if (IsDBCSLeadByteEx (CP_SJIS, lpszText[i]))
      {
        lpbType[i++] = 1;
        lpbType[i++] = 2;
      }
    else
      {
        lpbType[i++] = 0;
      }
}


/*  ja:
         hWnd,EChE
    lpptStart,͈
      lpptEnd,͈(x=-1ȂΑI͈͂Ȃ)
     lpszFind,
       bArrow,TRUE:,FALSE:
        bCase,TRUE:啶ʂ,FALSE:啶ʂȂ
       bWidth,TRUE:Sppʂ,FALSE:SppʂȂ
          RET,TRUE:I,FALSE:G[                                    */
BOOL
FindOperation (HWND    hWnd,
               LPPOINT lpptStart,
               LPPOINT lpptEnd,
               LPCTSTR lpszFind,
               BOOL    bArrow,
               BOOL    bCase,
               BOOL    bWidth)
{
  int i = 0;
  int nLength0;                 /* ja:(oCgP) */
  int nLeng0 = 0;               /* ja:(P) */
  BYTE bType[MAXFIND * 2];
  CHAR szText0[MAXFIND * 2];
  LPTSTR lpszText;
  LPLINEBUF p, q;
  LPTEXTWND ptw;
  POINT ptStart, ptEnd, ptData;

  ptStart = *lpptStart;
  ptEnd = *lpptEnd;
  ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
  ptw->ptCursor.x = GetAlignPos (&ptw->lpStart, &ptw->nOff,
                        ptw->ptCursor.x, ptw->ptCursor.y, ptw->nTab, FALSE);
#if UNICODE
  WideCharToMultiByte (CP_SJIS,0, lpszFind, -1,
                                            szText0, MAXFIND * 2, NULL, NULL);
#else /* not UNICODE */
  lstrcpy (szText0, lpszFind);
#endif /* not UNICODE */
  nLength0 = lstrlenA (szText0);
  while (i < nLength0)
    {
      i += IsDBCSLeadByteEx (CP_SJIS, szText0[i]) ? 2 : 1;
      nLeng0++;
    }
  HideCaret (hWnd);
  if (ptw->ptSelect.x >= 0)
    {
      /* ja:I͈͂ */
      if (!ClearSel (hWnd, &ptw->ptSelect, &ptw->ptCursor))
        return FALSE;
      ptw->ptSelect.x = -1;
    }
  if (ptEnd.x >= 0)
    {
      /* ja:ʂɂÎƂɂ͑I𖳌 */
      i = GetSelByte (&ptw->lpStart, &ptw->nOff, &ptStart, &ptEnd, ptw->nTab);
      if (i < MAXFIND * 2)
        {
          BOOL fResult;/* ja:ř,TRUE:,FALSE:قȂ */
          CHAR szText1[MAXFIND * 2];

          CpySelMem (&ptw->lpStart, &ptw->nOff,
                                        &ptStart, &ptEnd, ptw->nTab, szText1);
          szText1[i] = '\0';
          if (!bWidth)/* ja:Sp/p̋ʂȂ */
            fResult = CompareStringA (LOCALE_USER_DEFAULT,
                            (bCase ? 0 : NORM_IGNORECASE) | NORM_IGNOREWIDTH,
                                                szText0, -1, szText1, -1) == 2;
          else if (bCase)/* ja:啶/̋ʂ */
            fResult = lstrcmpA (szText0, szText1) == 0;
          else
            fResult = lstrcmpiA (szText0, szText1) == 0;
          if (fResult)
            ptEnd.x = -1;
        }
    }
  if (ptEnd.x < 0)
    if (bArrow)
      {
        ptEnd.x = GetWidth (&ptw->lpStart, &ptw->nOff,
                                                    ptw->nMax - 1, ptw->nTab);
        ptEnd.y = ptw->nMax - 1;/* ja: */
      }
    else
      {
        ptEnd.x = ptEnd.y = 0;/* ja: */
      }
  if (bArrow && (ptEnd.y < ptStart.y
                            || ptStart.y == ptEnd.y && ptEnd.x <= ptStart.x)
            || !bArrow && (ptStart.y < ptEnd.y
                            || ptStart.y == ptEnd.y && ptStart.x <= ptEnd.x))
    /* ja:Ɣ͈͂Ƃ */
    return TRUE;
  fUserBreak = TRUE;
  EnableWindow (hWndMain, FALSE);
  lpszText = LoadText (hInst, IDS_JOB_FIND);
  hDlgCancel = CreateDialogParamGUI (hInst, MAKEINTRESOURCE (DIALOG_G),
                                hWndClient, AbortDlgProc, (LPARAM)lpszText);
  MemoryFree (lpszText);
  if (!hDlgCancel)
    {
      MessageBox (hWnd, _T("CreateDialogGUIParam"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      EnableWindow (hWndMain, TRUE);
      ShowCaret (hWnd);
      return FALSE;
    }
  ptEnd.x = GetDataPos (&ptw->lpStart, &ptw->nOff,
                                    ptEnd.x, ptEnd.y, ptw->nTab, FALSE);
  ptStart.x = GetDataPos (&ptw->lpStart, &ptw->nOff,
                                    ptStart.x, ptStart.y, ptw->nTab, FALSE);
  p = GetLineBuffer (&ptw->lpStart, &ptw->nOff, ptStart.y);
  /* ja:Ŕr邽߂ɕ𐔂 */
  q = p;
  ptData = ptStart;
  if (ptStart.y < ptEnd.y || (ptStart.y == ptEnd.y && ptStart.x < ptEnd.x))
    {
      /* ja:ォ牺 */
      int nLength1 = 0; /* ja:(oCgP) */
      int nLeng1 = 0;   /* ja:(P) */
      CHAR szText1[MAXFIND * 2];

      while (ptStart.y < ptEnd.y
                                || ptStart.y == ptEnd.y && ptStart.x < ptEnd.x)
        {
          BOOL fResult;/* ja:ř,TRUE:,FALSE:قȂ */

          /* ja:obt@̍Ōɕ */
          while (nLeng1 < nLeng0 && (ptData.y < ptEnd.y
                                || ptData.y == ptEnd.y && ptData.x < ptEnd.x))
            {
              if (ptData.x < q->nLength)
                {
                  /* ja: */
                  if (ptData.x < q->nLength - 1 && IsDBCSLeadByteEx (CP_SJIS,
                                                        q->lpszText[ptData.x]))
                    {
                      MemoryCopy (szText1 + nLength1, q->lpszText + ptData.x,
                                                            sizeof (CHAR) * 2);
                      nLength1 += 2;
                      ptData.x += 2;
                    }
                  else
                    {
                      szText1[nLength1] = q->lpszText[ptData.x];
                      nLength1++;
                      ptData.x++;
                    }
                  nLeng1++;
                }
              else
                {
                  /* ja:s */
                  MSG msg;

                  while (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE))
                    if (!hDlgCancel || !IsDialogMessage (hDlgCancel, &msg))
                      {
                        TranslateMessage (&msg);
                        DispatchMessage (&msg);
                      }
                  if (!fUserBreak)
                    goto loop;
                  if (!q->fMargin)
                    {
                      szText1[nLength1] = '\n';
                      nLength1++;
                      nLeng1++;
                    }
                  ptData.x = 0;
                  ptData.y++;
                  q = q->next;
                }
            }
          szText1[nLength1] = '\0';
          /* ja:r */
          if (!bWidth)/* ja:Sp/p̋ʂȂ */
            fResult = CompareStringA (LOCALE_USER_DEFAULT,
                            (bCase ? 0 : NORM_IGNORECASE) | NORM_IGNOREWIDTH,
                                    szText0, -1, szText1, -1) == CSTR_EQUAL;
          else if (bCase)/* ja:啶/̋ʂ */
            fResult = lstrcmpA (szText0, szText1) == 0;
          else
            fResult = lstrcmpiA (szText0, szText1) == 0;
          if (fResult)
            {
              /* ja:vƂ */
              if (p->fMargin && p->nLength <= ptStart.x)
                {
                  /* ja:E}[ŴƂɂ͎̍s̐擪 */
                  ptStart.x = 0;
                  ptStart.y++;
                }
              ptw->ptSelect.x = GetScreenPos (&ptw->lpStart, &ptw->nOff,
                                            ptStart.x, ptStart.y, ptw->nTab);
              ptw->ptSelect.y = ptStart.y;
              if (q->fMargin && q->nLength <= ptData.x)
                {
                  /* ja:E}[ŴƂɂ͎̍s̐擪 */
                  ptData.x = 0;
                  ptData.y++;
                }
              ptw->ptCursor.x = GetScreenPos( &ptw->lpStart, &ptw->nOff,
                                                ptData.x, ptData.y, ptw->nTab);
              ptw->ptCursor.y = ptData.y;
              break;
            }
          /* ja:obt@̐擪̕j */
          if (IsDBCSLeadByteEx (CP_SJIS, szText1[0]))
            {
              MemoryCopy (szText1, szText1 + 2,
                                            (MAXFIND * 2 - 2) * sizeof (CHAR));
              nLength1 -= 2;
              if (ptStart.x < p->nLength)
                {
                  ptStart.x += 2;
                }
              else
                {
                  ptStart.x = 2;
                  ptStart.y++;
                  p = p->next;
                }
            }
          else
            {
              MemoryCopy (szText1, szText1 + 1,
                                            (MAXFIND * 2 - 1) * sizeof (CHAR));
              nLength1--;
              if (ptStart.x < p->nLength)
                {
                  ptStart.x++;
                }
              else
                {
                  ptStart.x = p->fMargin ? 1 : 0;
                  ptStart.y++;
                  p = p->next;
                }
            }
          nLeng1--;
        }
    }
  else
    {
      /* ja: */
      int nLength1 = 0; /* ja:(oCgP) */
      int nLeng1 = 0;   /* ja:(P) */
      CHAR szText1[MAXFIND * 2];
      LPBYTE lpbType;

      lpbType = MemoryAlloc (p->nLength * sizeof (BYTE));
      mCharType (lpbType, p->lpszText, p->nLength);
      while (ptEnd.y < ptStart.y
                                || ptStart.y == ptEnd.y && ptEnd.x < ptStart.x)
        {
          BOOL fResult;/* ja:ř,TRUE:,FALSE:قȂ */
          /* ja:obt@̍ŏɕ */
          while (nLeng1 < nLeng0 && (ptEnd.y < ptData.y
                                || ptData.y == ptEnd.y && ptEnd.x < ptData.x))
            {
              if (0 < ptData.x)
                {
                  /* ja: */
                  if (lpbType[ptData.x - 1] == 2)
                    {
                      MemoryCopy (szText1 + 2, szText1,
                                            (MAXFIND * 2 - 2) * sizeof (CHAR));
                      MemoryCopy (bType + 2, bType,
                                            (MAXFIND * 2 - 2) * sizeof (BYTE));
                      MemoryCopy (szText1, q->lpszText + ptData.x - 2,
                                                            sizeof (CHAR) * 2);
                      bType[0] = 1;
                      bType[1] = 2;
                      nLength1 += 2;
                      ptData.x -= 2;
                    }
                  else
                    {
                      MemoryCopy (szText1 + 1, szText1,
                                            (MAXFIND * 2 - 1) * sizeof (CHAR));
                      MemoryCopy (bType + 1, bType,
                                            (MAXFIND * 2 - 1) * sizeof (BYTE));
                      szText1[0] = q->lpszText[ptData.x - 1];
                      bType[0] = 0;
                      nLength1++;
                      ptData.x--;
                    }
                  nLeng1++;
                }
              else
                {
                  /* ja:s */
                  MSG msg;

                  while (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE))
                    if (!hDlgCancel || !IsDialogMessage (hDlgCancel, &msg))
                      {
                        TranslateMessage (&msg);
                        DispatchMessage (&msg);
                      }
                  if (!fUserBreak)
                    goto loop;
                  q = q->prev;
                  lpbType = MemoryReAlloc (lpbType,
                                                q->nLength * sizeof (BYTE));
                  mCharType (lpbType, q->lpszText, q->nLength * sizeof (CHAR));
                  if (!q->fMargin)
                    {
                      MemoryCopy (szText1 + 1, szText1,
                                            (MAXFIND * 2 - 1) * sizeof (CHAR));
                      MemoryCopy (bType + 1, bType,
                                            (MAXFIND * 2 - 1) * sizeof (BYTE));
                      szText1[0] = '\n';
                      bType[0] = 0;
                      nLength1++;
                      nLeng1++;
                    }
                  ptData.x = q->nLength;
                  ptData.y--;
                }
            }
          szText1[nLength1] = '\0';
          /* ja:r */
          if (!bWidth)/* ja:Sp/p̋ʂȂ */
            fResult = CompareStringA (LOCALE_USER_DEFAULT,
                            (bCase ? 0 : NORM_IGNORECASE) | NORM_IGNOREWIDTH,
                                                szText0, -1, szText1, -1) == 2;
          else if (bCase)/* ja:啶/̋ʂ */
            fResult = lstrcmpA (szText0, szText1) == 0;
          else
            fResult = lstrcmpiA (szText0, szText1) == 0;
          if (fResult)
            {
              /* ja:vƂ */
              if (p->fMargin && p->nLength <= ptStart.x)
                {
                  /* ja:E}[ŴƂɂ͎̍s̐擪 */
                  ptStart.x = 0;
                  ptStart.y++;
                }
              ptw->ptSelect.x = GetScreenPos (&ptw->lpStart, &ptw->nOff,
                                            ptStart.x, ptStart.y, ptw->nTab);
              ptw->ptSelect.y = ptStart.y;
              if (q->fMargin && q->nLength <= ptData.x)
                {
                  /* ja:E}[ŴƂɂ͎̍s̐擪 */
                  ptData.x = 0;
                  ptData.y++;
                }
              ptw->ptCursor.x = GetScreenPos (&ptw->lpStart, &ptw->nOff,
                                                ptData.x, ptData.y, ptw->nTab);
              ptw->ptCursor.y = ptData.y;
              break;
            }
          /* ja:obt@̍Ō̕j */
          if (bType[nLength1 - 1] == 2)
            {
              nLength1 -= 2;
              if (ptStart.x > 0)
                {
                  ptStart.x -= 2;
                }
              else
                {
                  p = p->prev;
                  ptStart.x = p->nLength - 2;
                  ptStart.y--;
                }
            }
          else
            {
              nLength1--;
              if (ptStart.x > 0)
                {
                  ptStart.x--;
                }
              else
                {
                  p = p->prev;
                  ptStart.x = p->nLength - (p->fMargin ? 1 : 0);
                  ptStart.y--;
                }
            }
          nLeng1--;
        }
      MemoryFree (lpbType);
    }
  loop:
  EnableWindow (hWndMain, TRUE);
  if (!DestroyWindow (hDlgCancel))
    {
      MessageBox (hWnd, _T("DestroyWindow"),
                        APPLICATION, MB_OK | MB_ICONEXCLAMATION);
      ptw->ptSelect.x = -1;
      ShowCaret (hWnd);
      return FALSE;
    }
  if (ptw->ptSelect.x >= 0)
    {
      int sx, sy;
      POINT ptTop;

      ptTop = ptw->ptTop;
      sx = max (ptw->siWnd.cx / ptw->nFontSize, 1);
      sy = max (ptw->siWnd.cy / (ptw->nFontSize * 2), 1);
      if (!ClearSel (hWnd, &ptw->ptSelect, &ptw->ptCursor))
        return FALSE;
      if (ptw->ptCursor.x < ptw->ptTop.x)
        ptw->ptTop.x = ptw->ptCursor.x;
      else if (ptw->ptCursor.x - sx + 1 > ptw->ptTop.x)
        ptw->ptTop.x = ptw->ptCursor.x - sx + 1;
      if (ptw->ptCursor.y < ptw->ptTop.y)
        ptw->ptTop.y = ptw->ptCursor.y;
      else if (ptw->ptCursor.y - sy + 1 > ptw->ptTop.y)
        ptw->ptTop.y = ptw->ptCursor.y - sy + 1;
      if (!DrawCaret (hWnd) || !MoveTextWindow (hWnd, &ptTop))
        return FALSE;
    }
  ShowCaret (hWnd);
  return TRUE;
}


/******************************************************************************
*                                                                             *
* ja:_CAOQ                                                         *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
FindDlgProc (HWND   hDlg,
             UINT   uMsg,
             WPARAM wParam,
             LPARAM lParam)
{
  static LPFIND lpfd;

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i;

          lpfd = (LPFIND)lParam;
          /* ja:`FbN{bNX̐ݒ */
          if (!CheckDlgButton (hDlg, IDC_CHECKBOX81,
                                lpfd->bCase ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX82,
                                lpfd->bWidth ? BST_CHECKED : BST_UNCHECKED))
            {
              MessageBox (hDlg, _T("CheckDlgButton"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:R{{bNX̐ݒ */
          SendDlgItemMessage (hDlg, IDC_COMBOBOX81, CB_LIMITTEXT,
                                                            MAXFIND - 1, 0);
          for (i = 0; i < nFind; i++)
            SendDlgItemMessage (hDlg, IDC_COMBOBOX81, CB_ADDSTRING,
                                                    0, (LPARAM)lpszFind[i]);
          if (nFind > 0)
            {
              SendDlgItemMessage (hDlg, IDC_COMBOBOX81, CB_SETCURSEL, 0, 0);
              /* ja:Rg[̕\ */
              if (!EnableDlgItem (hDlg, IDOK, TRUE))
                {
                  MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
            }
          /* ja:WI{^̐ݒ */
          if (!CheckRadioButton (hDlg, IDC_RADIOBUTTON81, IDC_RADIOBUTTON82,
                        lpfd->bArrow ? IDC_RADIOBUTTON82 : IDC_RADIOBUTTON81))
            {
              MessageBox (hDlg, _T("CheckRadioButton"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
            }
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              lpfd->bCase = IsDlgButtonChecked (hDlg, IDC_CHECKBOX81)
                                                                == BST_CHECKED;
              lpfd->bWidth = IsDlgButtonChecked (hDlg, IDC_CHECKBOX82)
                                                                == BST_CHECKED;
              lpfd->bArrow = IsDlgButtonChecked (hDlg, IDC_RADIOBUTTON82)
                                                                == BST_CHECKED;
              GetDlgItemText (hDlg, IDC_COMBOBOX81, lpfd->szText, MAXFIND);
            case IDCANCEL:
              if (!EndDialog (hDlg, LOWORD (wParam)))
                MessageBox (hDlg, _T("EndDialog"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              return TRUE;
            case IDC_COMBOBOX81:
              {
                int nLength;

                switch (HIWORD (wParam))
                  {
                    case CBN_EDITCHANGE:
                      nLength = GetWindowTextLength ((HWND)lParam);
                      break;
                    case CBN_SELCHANGE:
                      nLength = 1;
                      break;
                    default: return TRUE;
                  }
                /* ja:Rg[̕\ */
                if (!EnableDlgItem (hDlg, IDOK, nLength > 0))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION,MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                  }
              }
          }
        return TRUE;
    }
  return FALSE;
}
