/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "auto.h"
#include "common.h"
#include "dialog.h"
#include "other.h"
#include "resource.h"


/******************************************************************************
*                                                                             *
* ja:ʊ֐Q                                                           *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
AutoDlgProc (HWND   hDlg,
             UINT   uMsg,
             WPARAM wParam,
             LPARAM lParam)
{
  static LPDWORD lpdwCharSet;

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i;
          BYTE bBit = 0;
          DWORD dwCharSet;
          LPTSTR lpszText, *plpszArray;

          lpdwCharSet = (LPDWORD)lParam;
          /* ja:Xg{bNX̐ݒ */
          lpszText = LoadText (hInst, IDS_FTYPE_CHARSET);
          plpszArray = StringSplitDelimiter (lpszText, _T(","));
          MemoryFree (lpszText);
          for (dwCharSet = *lpdwCharSet; dwCharSet & 15; dwCharSet >>= 4)
            {
              SendDlgItemMessage (hDlg, IDC_LISTBOXC2, LB_SETITEMDATA,
                        SendDlgItemMessage (hDlg, IDC_LISTBOXC2, LB_ADDSTRING,
                0, (LPARAM)plpszArray[(dwCharSet & 15) - 1]), dwCharSet & 15);
              bBit |= 1 << (dwCharSet & 15) - 1;
            }
          for (i = 0; i < 7; i++)
            if (!(bBit >> i & 1))
              SendDlgItemMessage (hDlg, IDC_LISTBOXC1, LB_SETITEMDATA,
                        SendDlgItemMessage (hDlg, IDC_LISTBOXC1, LB_ADDSTRING,
                                            0, (LPARAM)plpszArray[i]), i + 1);
          MemoryFree (plpszArray);
        }
        goto loop;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              {
                int i;

                *lpdwCharSet = 0;
                for (i = SendDlgItemMessage (hDlg, IDC_LISTBOXC2,
                                        LB_GETCOUNT, 0, 0) - 1; i >= 0; i--)
                  *lpdwCharSet = *lpdwCharSet << 4 | SendDlgItemMessage (hDlg,
                                        IDC_LISTBOXC2, LB_GETITEMDATA, i, 0);
              }
            case IDCANCEL:
              EndDialog (hDlg, LOWORD (wParam));
              return TRUE;
            case IDC_LISTBOXC1:
            case IDC_LISTBOXC2:
              if (HIWORD (wParam) == LBN_SELCHANGE
                    && !EnableDlgItem (hDlg, LOWORD (wParam) == IDC_LISTBOXC1
                                        ? IDC_PUSHBUTTONC1 : IDC_PUSHBUTTONC2,
                                    SendDlgItemMessage (hDlg, LOWORD (wParam),
                                                    LB_GETSELCOUNT, 0, 0) > 0))
                EndDialog (hDlg, IDCANCEL);
              return TRUE;
            case IDC_PUSHBUTTONC1:
            case IDC_PUSHBUTTONC2:
            case IDC_PUSHBUTTONC3:
            case IDC_PUSHBUTTONC4:
              {
                int i, *p, nCount, nIDSrc, nIDDst;
                TCHAR szName[4096];

                if (LOWORD (wParam) == IDC_PUSHBUTTONC1
                                        || LOWORD (wParam) == IDC_PUSHBUTTONC3)
                  {
                    nIDSrc = IDC_LISTBOXC1;
                    nIDDst = IDC_LISTBOXC2;
                  }
                else
                  {
                    nIDSrc = IDC_LISTBOXC2;
                    nIDDst = IDC_LISTBOXC1;
                  }
                nCount = SendDlgItemMessage (hDlg, nIDSrc,
                                            LOWORD (wParam) <= IDC_PUSHBUTTONC2
                                        ? LB_GETSELCOUNT : LB_GETCOUNT, 0, 0);
                if (nCount <= 0)
                  return TRUE;
                p = MemoryAlloc (nCount * sizeof (int));
                if (LOWORD (wParam) <= IDC_PUSHBUTTONC2)
                  SendDlgItemMessage (hDlg, nIDSrc,
                                            LB_GETSELITEMS, nCount, (LPARAM)p);
                else
                  for (i = 0; i < nCount; i++)
                    p[i] = i;
                for (i = 0; i < nCount; i++)
                  {
                    SendDlgItemMessage (hDlg, nIDSrc, LB_GETTEXT, p[i],
                                                            (LPARAM)szName);
                    SendDlgItemMessage (hDlg, nIDDst, LB_SETITEMDATA,
                    SendDlgItemMessage (hDlg, nIDDst, LB_ADDSTRING,
                                                            0, (LPARAM)szName),
                    SendDlgItemMessage (hDlg, nIDSrc, LB_GETITEMDATA,
                                                                    p[i], 0));
                  }
                for (i = nCount - 1; i >= 0; i--)
                  SendDlgItemMessage (hDlg, nIDSrc, LB_DELETESTRING, p[i], 0);
                MemoryFree (p);
                if (!EnableDlgItem (hDlg, IDOK, TRUE))
                  {
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
              }
              loop:
              {
                BOOL fItem;

                fItem = SendDlgItemMessage (hDlg, IDC_LISTBOXC2,
                                                        LB_GETCOUNT, 0, 0) > 0;
                if (!EnableDlgItem (hDlg, IDC_PUSHBUTTONC1,
                                    SendDlgItemMessage (hDlg, IDC_LISTBOXC1,
                                                    LB_GETSELCOUNT, 0, 0) > 0)
                 || !EnableDlgItem (hDlg, IDC_PUSHBUTTONC2,
                                    SendDlgItemMessage (hDlg, IDC_LISTBOXC2,
                                                    LB_GETSELCOUNT, 0, 0) > 0)
                 || !EnableDlgItem (hDlg, IDC_PUSHBUTTONC3,
                                    SendDlgItemMessage (hDlg, IDC_LISTBOXC1,
                                                        LB_GETCOUNT, 0, 0) > 0)
                 || !EnableDlgItem (hDlg, IDC_PUSHBUTTONC4, fItem)
                 || !EnableDlgItem (hDlg, IDOK, fItem))
                  EndDialog (hDlg, IDCANCEL);
              }
          }
        return TRUE;
    }
  return FALSE;
}
