/*
    fndir
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "fndir.h"
#include "common.h"


/******************************************************************************
*                                                                             *
* ja:t@C͊֐                                                       *
*                                                                             *
******************************************************************************/
/*  ja:Ot@C擾
     lpszLongName,Ot@C
    lpszShortName,t@C                                                */
VOID WINAPI
GetLongFile (LPTSTR  lpszLongName,
             LPCTSTR lpszShortName)
{
  int i = 0, j;
  DWORD dwSize;             /* ja:tpX̒ */
  LPTSTR p;
  TCHAR szFile[MAX_PATH];   /* ja:tpX */

  dwSize = GetFullPathName (lpszShortName, MAX_PATH, szFile, &p);
  if (dwSize == 0 || dwSize >= MAX_PATH)
    {
      lstrcpy (lpszLongName, lpszShortName);
      return;
    }
  if (dwSize >= 2)
    {
      if (szFile[1] == ':')
        {
          lpszLongName[0] = (TCHAR)CharUpper ((LPTSTR)szFile[0]);
          lpszLongName[1] = ':';
          if (szFile[2] == '\\')
            {
              lpszLongName[2] = '\\';
              i = 3;
            }
          else
            {
              i = 2;
            }
        }
      else if (szFile[0] == '\\' && szFile[1] == '\\')
        {
          int k = 2;

          i = 2;
          while (i < dwSize)
            {
              if (szFile[i] == '\\' && --k <= 0)
                {
                  i++;
                  break;
                }
#ifdef UNICODE
              i++;
#else /* not UNICODE */
              i += IsDBCSLeadByteEx (CP_ACP, szFile[i]) ? 2 : 1;
#endif /* not UNICODE */
            }
          MemoryCopy (lpszLongName, szFile, i * sizeof (TCHAR));
        }
    }
  lpszLongName[i] = '\0';
  j = i;
  while (i <= dwSize)
    {
      if (szFile[i] == '\0' || szFile[i] == '\\')
        {
          int s;
          HANDLE hFind;             /* ja:nh */
          WIN32_FIND_DATA rcf;

          s = lstrlen (lpszLongName);
          MemoryCopy (lpszLongName + s, szFile + j, (i - j) * sizeof (TCHAR));
          lpszLongName[s + i - j] = '\0';
          hFind = FindFirstFile (lpszLongName, &rcf);
          if (hFind != INVALID_HANDLE_VALUE)
            FindClose (hFind);
          else
            lstrcpy (rcf.cFileName, _T("."));
          if (lstrcmp (rcf.cFileName, _T(".")) != 0)
            {
              MemoryCopy (lpszLongName + s, rcf.cFileName,
                                    lstrlen (rcf.cFileName) * sizeof (TCHAR));
              s += lstrlen (rcf.cFileName);
            }
          else
            {
              s += i - j;
            }
          if (szFile[i] == '\\')
            lpszLongName[s++] = '\\';
          lpszLongName[s] = '\0';
          j = i + 1;
        }
#ifdef UNICODE
      i++;
#else /* not UNICODE */
      i += IsDBCSLeadByteEx (CP_ACP, szFile[i]) ? 2 : 1;
#endif /* not UNICODE */
    }
}
